/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <fnmatch.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "data.h"
#include "search.xpm"
#include "search.h"
#include "icons2.h"
#include "edit.h"
//#include "images.h"
//#include "interface.h"

search_info *search_files;

Folder *selected_search_folder;
extern Folder *selected_folder;


int in_foldername;
int in_filename;
int case_sensitive;
GtkWidget *result_window;
GtkWidget *search_list;
GtkWidget *search_entry;
GtkWidget *categorie_entry;
GtkWidget *information_entry;
GtkWidget *info_entry;
GtkWidget *cat_combo;
GtkWidget *desc_combo;

GtkWidget *description_entry;
int nb_files;
int nb_folders;
int search_is_open;

extern GtkWidget *path_entry;

int cat_search; //contient le numero de la categories recherche! -1 si toutes!
int nb_search_desc;
int *search_descs;
int last_sort;

GtkWidget *search_dialog_window;


void change_in_filename (GtkWidget *checkbutton,
				   GtkWidget *entry)
{
  if (in_filename == 0) in_filename = 1;
  else in_filename = 0;
}


void change_in_foldername (GtkWidget *checkbutton,
				   GtkWidget *entry)
{
  if (in_foldername == 0) in_foldername = 1;
  else in_foldername = 0;
}

void change_case_sensitive (GtkWidget *checkbutton,
				   GtkWidget *entry)
{
  if (case_sensitive == 0) case_sensitive = 1;
  else case_sensitive = 0;
}



void exit_search_dialog (GtkWidget *w)
{
  gtk_grab_remove(search_dialog_window);
  gtk_widget_destroy(search_dialog_window);
}


void exit_search_result (GtkWidget *w)
{
  search_is_open = 0;
  gtk_grab_remove(w);
  gtk_widget_destroy(w);
}


void take_cat()
{
  char *temp;
  int i;

  cat_search = -1;
  temp = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cat_combo)->entry)));  
  if (strlen(temp) == 0)
    {
      cat_search = 0;
      return;
    }
  for(i=1;i<nb_categories;i++)
    {
      if (strcmp(temp,categories[i]) == 0)
	{
	  cat_search = i;
	  return;
	}
    }
}

void take_desc_tab(int sensitive)
{
  char *temp;
  int i;
  
  nb_search_desc = -1;
  temp = g_strdup(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(desc_combo)->entry)));
  if (strlen(temp) == 0)
    {
      search_descs = (int *)malloc(sizeof(int));
      search_descs[0] = 0;
      nb_search_desc = 1;
      return;
    }
  if ((strcmp(temp,"*") == 0)&&(strlen(temp) == 1))
    {
      nb_search_desc = -1;
      return;
    }
  for (i=0;i<nb_descriptions;i++)
    {
      if (((sensitive!=1)&&(fnmatch(temp,descriptions[i],(1 << 4)) == 0))||((sensitive==1)&&(fnmatch(temp,descriptions[i],0) == 0)))
	{
	  if (nb_search_desc < 1)
	    {
	      search_descs = (int *)malloc(sizeof(int));
	      search_descs[0] = i;
	      nb_search_desc = 1;
	    }  
	  else 
	    {
	      search_descs = (int *)realloc(search_descs,(nb_search_desc)*sizeof(int));  
	      search_descs[nb_search_desc] = i;
	      nb_search_desc++;
	    }
	}
    }
}


void start_search(GtkWidget *w)
{
  int i;
  gchar cur_path[]="/";
  gchar *filename;
  gchar *infostring;
  gchar data[100];

  nb_folders = 0;
  nb_files = 0;
  take_desc_tab(case_sensitive);//creer la liste des valeur des description valide
  take_cat();//donne la valeur de la categorie valide. -1 si toutes.
  filename = g_strdup(gtk_entry_get_text(GTK_ENTRY(search_entry)));
  infostring = g_strdup(gtk_entry_get_text(GTK_ENTRY(information_entry)));
 
  search_files = NULL;
  search_files = (search_info *)malloc(sizeof(search_info));

  exit_search_dialog(w);
  if (search_is_open == 0)
    {
      open_result_dialog(w);
    }
  else gtk_clist_clear((GtkCList *)search_list);
  gtk_clist_freeze ((GtkCList *)search_list);
  if (racine.nb_folders > 0)
    {
      for(i=0;i<racine.nb_folders;i++)
	{
	  search_in_data(&racine.folders[i], filename, infostring,in_filename,in_foldername,case_sensitive,racine.folders[i].name, cur_path);
	}
    }
  sprintf(data,"Find %d folders & %d files",nb_folders,nb_files - nb_folders);
  gtk_entry_set_text(GTK_ENTRY(info_entry),data);

  affiche_files();

  gtk_clist_sort ((GtkCList *)search_list);
 // gtk_clist_set_auto_sort ((GtkCList *)search_list,TRUE);
  gtk_clist_thaw   ((GtkCList *)search_list);
}

void open_search_dialog(GtkWidget *w)
{

  
    GtkWidget *frame;
    GtkWidget *ok_button;
    GtkWidget *cancel_button;
    GtkWidget *check;
    GtkWidget *image;
    GtkWidget *table;
    static GtkStyle *style;
    static GdkPixmap *logo_pixmap;
    static GdkBitmap *logo_mask;

    GList *cat_list;
    GList *desc_list;
    int i;

    in_foldername = 0;
    in_filename = 0;
    case_sensitive = 0;
    
    nb_files = 0;

    search_dialog_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize( GTK_WIDGET (search_dialog_window), 350, 205);
    gtk_container_border_width (GTK_CONTAINER (search_dialog_window), 10);
    gtk_window_set_policy(GTK_WINDOW(search_dialog_window), FALSE, FALSE, TRUE);
    gtk_window_set_title(GTK_WINDOW (search_dialog_window), "Search");
    gtk_signal_connect(GTK_OBJECT (search_dialog_window), "delete_event",
                       exit_search_dialog, search_dialog_window);
    gtk_window_set_position (GTK_WINDOW (search_dialog_window), GTK_WIN_POS_MOUSE);
    gtk_grab_add(search_dialog_window);

    if (logo_pixmap == NULL)
      {
	gtk_widget_realize(search_dialog_window);
	style = gtk_widget_get_style(search_dialog_window);
	logo_pixmap = gdk_pixmap_create_from_xpm_d( search_dialog_window->window,
						    &logo_mask, &style->bg[GTK_STATE_NORMAL],
						    (gchar **)search_xpm);					
	gtk_widget_unrealize(search_dialog_window);
      }
    
    table = gtk_table_new(50, 40, TRUE);
    gtk_container_add (GTK_CONTAINER (search_dialog_window), table);
    gtk_widget_show(table);

    image =gtk_pixmap_new(logo_pixmap, logo_mask);
    gtk_table_attach_defaults (GTK_TABLE(table), image, 1, 4, 1, 15);
    gtk_widget_show(image);

/***********/
    frame = gtk_frame_new(NULL);
    gtk_frame_set_label( GTK_FRAME(frame), "Enter file to be searched." );
    gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
    gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_table_attach_defaults (GTK_TABLE(table), frame, 6, 39, 1, 14);
    gtk_widget_show(frame);
	
    search_entry = gtk_entry_new_with_max_length (100);
    gtk_signal_connect(GTK_OBJECT(search_entry), "activate",
		       GTK_SIGNAL_FUNC(start_search),
		       GTK_OBJECT (search_dialog_window));
    gtk_entry_set_text (GTK_ENTRY (search_entry), "*");
    gtk_container_add(GTK_CONTAINER(frame), search_entry);
    gtk_widget_show (search_entry);

/**********/
    frame = gtk_frame_new(NULL);
    gtk_frame_set_label( GTK_FRAME(frame), "In category" );
    gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
    gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_table_attach_defaults (GTK_TABLE(table), frame, 0, 19, 17, 27);
    gtk_widget_show(frame);
	
    cat_combo = gtk_combo_new();                                                                           
    gtk_combo_set_value_in_list(GTK_COMBO(cat_combo), FALSE, TRUE);                                        
    gtk_combo_set_use_arrows_always(GTK_COMBO(cat_combo), TRUE);                                           
    gtk_combo_disable_activate(GTK_COMBO(cat_combo));                                                      
    cat_list=NULL;	
    for(i=0;i<nb_categories;i++) cat_list = g_list_append(cat_list, categories[i]);
    cat_list = g_list_append(cat_list, "All");
    gtk_combo_set_popdown_strings(GTK_COMBO(cat_combo), cat_list);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(cat_combo)->entry), FALSE);
    gtk_container_add(GTK_CONTAINER(frame), cat_combo);
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(cat_combo)->entry), "All");
    gtk_signal_connect(GTK_OBJECT(GTK_COMBO(cat_combo)->entry), "activate",
		       start_search,
		       GTK_OBJECT (search_dialog_window));
    gtk_widget_show (cat_combo);


/***************/
    frame = gtk_frame_new(NULL);
    gtk_frame_set_label( GTK_FRAME(frame), "With description" );
    gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
    gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_table_attach_defaults (GTK_TABLE(table), frame, 21, 40, 17, 27);
    gtk_widget_show(frame);


    desc_combo = gtk_combo_new();                                                                           
    gtk_combo_set_value_in_list(GTK_COMBO(desc_combo), FALSE, TRUE);                                        
    gtk_combo_set_use_arrows_always(GTK_COMBO(desc_combo), TRUE);                                           
    gtk_combo_disable_activate(GTK_COMBO(desc_combo));                                                      
    desc_list=NULL;	
    for(i=0;i<nb_descriptions;i++) desc_list = g_list_append(desc_list, descriptions[i]);
    desc_list = g_list_append(desc_list, "*");
    gtk_combo_set_popdown_strings(GTK_COMBO(desc_combo), desc_list);
    gtk_container_add(GTK_CONTAINER(frame), desc_combo);
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(desc_combo)->entry), "*");
    gtk_signal_connect(GTK_OBJECT(GTK_COMBO(desc_combo)->entry), "activate",
		       GTK_SIGNAL_FUNC(start_search),
		       GTK_OBJECT (search_dialog_window));
    gtk_widget_show (desc_combo);	
  

/***********/
    frame = gtk_frame_new(NULL);
    gtk_frame_set_label( GTK_FRAME(frame), "Search in informations" );
    gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
    gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_table_attach_defaults (GTK_TABLE(table), frame, 1, 39, 27, 37);
    gtk_widget_show(frame);
	
    information_entry = gtk_entry_new_with_max_length (100);
    gtk_signal_connect(GTK_OBJECT(information_entry), "activate",
		       GTK_SIGNAL_FUNC(start_search),
		       GTK_OBJECT (search_dialog_window));
    gtk_entry_set_text (GTK_ENTRY (information_entry), "*");
    gtk_container_add(GTK_CONTAINER(frame), information_entry);
    gtk_widget_show (information_entry);

/************/                                  
    check = gtk_check_button_new_with_label("Search File");
    gtk_signal_connect (GTK_OBJECT(check), "toggled",
			GTK_SIGNAL_FUNC(change_in_filename), search_entry);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
    gtk_table_attach_defaults (GTK_TABLE(table), check, 1, 14, 37, 45);
    gtk_widget_show (check);
    
    check = gtk_check_button_new_with_label("Search Folder");
    gtk_signal_connect (GTK_OBJECT(check), "toggled",
			GTK_SIGNAL_FUNC(change_in_foldername), search_entry);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
    gtk_table_attach_defaults (GTK_TABLE(table), check, 15, 28, 37, 45);
    gtk_widget_show (check);

    check = gtk_check_button_new_with_label("Case sensitive");
    gtk_signal_connect (GTK_OBJECT(check), "toggled",
			GTK_SIGNAL_FUNC(change_case_sensitive), search_entry);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);
    gtk_table_attach_defaults (GTK_TABLE(table), check, 29, 40, 37, 45);
    gtk_widget_show (check);
                             
    ok_button = gtk_button_new_with_label ("Ok");
    gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			       start_search,
			       GTK_OBJECT (search_dialog_window));
    gtk_table_attach_defaults (GTK_TABLE(table), ok_button, 5, 15, 45, 50);
    gtk_widget_show (ok_button);

    cancel_button = gtk_button_new_with_label ("Cancel");
    gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			       exit_search_dialog,
			       GTK_OBJECT (search_dialog_window));
    gtk_table_attach_defaults (GTK_TABLE(table), cancel_button, 25, 35, 45, 50);
    gtk_widget_show (cancel_button);
    
    gtk_widget_show(search_dialog_window);
}

void selection_made2( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  Folder *folder;  
  gchar *rep;
  gchar *path;
  gchar *data;
  gchar *name;
  gint8 pouet;
  GdkPixmap *da_pix;
  GdkBitmap *da_mask ;
 

  
   if(event != NULL && event->button == 1 && event->type == GDK_2BUTTON_PRESS)
    {
      gtk_clist_get_pixtext((GtkCList *)clist,row,0,&name,&pouet,&da_pix,&da_mask);
      folder = gtk_clist_get_row_data((GtkCList *)clist, row ); 

      gtk_clist_get_text((GtkCList *)search_list,row,1,&rep);
      gtk_clist_get_text((GtkCList *)search_list,row,2,&path);
      data = (char *)malloc((strlen(rep)+strlen(path)+5)*sizeof(char));
      sprintf(data,"[%s]->%s",rep,path);	
      gtk_entry_set_text(GTK_ENTRY (path_entry),data);

      if (is_file(folder) == 0)
	{
	  list_folder(folder);
	}
      else list_folder(folder->parent);
    }
  else
    { 
      folder = gtk_clist_get_row_data((GtkCList *)clist, row ); 
      selected_search_folder = folder; 
    }
}


void unselection_made2( GtkWidget *clist, gint row, gint column, GdkEventButton *event)
{
  selected_search_folder = NULL;  
}





void sort_list(GtkWidget *wid, gpointer data)
{
  selected_search_folder = NULL;
  gtk_clist_set_sort_column ((GtkCList *)search_list, (gint) data);
  affiche_files((gint) data);
  last_sort = (gint) data;
}


void search_clist_pressed(GtkWidget *wid, GdkEventButton *event, gpointer data)
{
  GtkWidget *list_menu_items;
  GtkWidget *list_menu;
  char buf[128];

 if((event->button == 2)&& (selected_search_folder != NULL))
    {
      selected_folder = selected_search_folder;
      edit_folder(wid);
    }
  if(event->button == 3)
    {
      GdkEventButton *bevent = (GdkEventButton *) event; 
      list_menu = gtk_menu_new();

      if (selected_search_folder != NULL)
	{
	  selected_folder = selected_search_folder ;
	  if(is_folder(selected_search_folder) == 1 )
	     {
	       list_menu_items = gtk_menu_item_new_with_label("Edit folder");
	       gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	       gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					 GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	       gtk_widget_show(list_menu_items);
	     }
	  else
	    {
	      list_menu_items = gtk_menu_item_new_with_label("Edit file"); 
	      gtk_menu_append(GTK_MENU (list_menu), list_menu_items);
	      gtk_signal_connect_object(GTK_OBJECT(list_menu_items), "activate",
					GTK_SIGNAL_FUNC(edit_folder), (gpointer) g_strdup(buf));
	      gtk_widget_show(list_menu_items);
	    }
        }
      gtk_menu_popup (GTK_MENU(list_menu), NULL, NULL, NULL, NULL,
		      bevent->button, bevent->time);
    }
}




void open_result_dialog(GtkWidget *w)
{
    GtkWidget *vbox, *hbox;
    GtkWidget *button_exit, *button_search_again, *scrolled_window;    
    gchar *titles[7] = { "File", "Disk", "Path", "Size", "Date","Category","Description" };

    search_is_open = 1;
    
    result_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_usize(GTK_WIDGET(result_window),500, 200);

    gtk_window_set_title(GTK_WINDOW(result_window), "Search result");
    gtk_signal_connect(GTK_OBJECT(result_window),
		       "destroy",
		       exit_search_result,
		       result_window);
    
    vbox=gtk_vbox_new(FALSE, 5);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(result_window), vbox);
    gtk_widget_show(vbox);
    
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, 
				    GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show(scrolled_window);

    search_list = gtk_clist_new_with_titles( 7, titles);
    gtk_signal_connect(GTK_OBJECT(search_list), "select_row",
		   GTK_SIGNAL_FUNC(selection_made2),NULL);
    gtk_signal_connect(GTK_OBJECT(search_list), "unselect_row",
		   GTK_SIGNAL_FUNC(unselection_made2),NULL);

    gtk_clist_set_shadow_type (GTK_CLIST(search_list), GTK_SHADOW_OUT);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 0, 165);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 1, 50);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 2, 150);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 3, 50);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 4, 50);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 5, 75);
    gtk_clist_set_column_width (GTK_CLIST(search_list), 6, 150);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scrolled_window), search_list);
////////////////// 
	gtk_signal_connect(GTK_OBJECT(search_list), "button_press_event", GTK_SIGNAL_FUNC(search_clist_pressed), NULL);
	gtk_signal_connect(GTK_OBJECT(search_list), "click_column", GTK_SIGNAL_FUNC(sort_list), NULL);
///////////////
    gtk_widget_show(search_list);

    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);
    gtk_widget_show(hbox);

    button_search_again = gtk_button_new_with_label(" Search again ");
    button_exit = gtk_button_new_with_label("      Exit     ");

    gtk_box_pack_start(GTK_BOX(hbox), button_search_again, TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), button_exit, TRUE, FALSE, 0);

 
    gtk_signal_connect_object(GTK_OBJECT(button_search_again), "clicked",
			      GTK_SIGNAL_FUNC(open_search_dialog),
			      (gpointer) result_window);
    gtk_signal_connect_object(GTK_OBJECT(button_exit), "clicked",
			      GTK_SIGNAL_FUNC(exit_search_result),
			      (gpointer) result_window);
   
    gtk_widget_show(button_exit);
    gtk_widget_show(button_search_again);


    info_entry = gtk_entry_new_with_max_length (100);
    gtk_entry_set_editable(GTK_ENTRY(info_entry),FALSE);
    gtk_box_pack_start(GTK_BOX(hbox), info_entry, TRUE, FALSE, 0);
    gtk_widget_show (info_entry);

    gtk_widget_show(result_window);

}


int test_file(gchar *filename, gchar *dataname,int sensitive)
{
  int i;
  
  if (sensitive == 0)
    {
      i = fnmatch(filename,dataname, (1 << 4)/* FNM_CASEFOLD*/);
      return(i);
    }
  else 
    {
      i = fnmatch(filename,dataname,0);
      return(i);
    }
}

int test_desc(int desc)
{
  int i;

  if (nb_search_desc == -1) return(1);
  else
    {
      for(i=0;i<nb_search_desc;i++)
	{
	  if (search_descs[i] == desc) return(1);
	}
    }
  return(0);
}

int test_cat(int cat)
{
  if (cat_search == -1) return(1);
  else if (cat_search == cat)return(1);
  return(0);
}


void affiche_files(gint col)
{
  int i;
  int fin = 0;
  int trouve;

  gtk_clist_clear((GtkCList *)search_list);
  gtk_clist_freeze((GtkCList *)search_list);
  if ((col != 3)&&(col != 4))
    {
      for(i=0;i<nb_files;i++) affiche_row(&search_files[i]); 
      gtk_clist_sort((GtkCList *)search_list);
    }
  else 
    {
      for (i=0;i<nb_files;i++) search_files[i].val = 0;
      while (fin == 0)
	{
	  fin = 1;
	  trouve = 0;
	  while(fin == 1)
	    {
	      if ((search_files[trouve].val == 0)||(trouve == nb_files)) fin = 2;
	      else trouve++;
	    }
	  if (trouve != nb_files)
	    {
	      for (i=trouve;i<nb_files;i++)
		{
		  if((col == 3)&&(search_files[i].val == 0)&&((search_files[i].folder->taille & size_mask) < (search_files[trouve].folder->taille & size_mask))) trouve = i;
		  else if ((col == 4)&&(search_files[i].val == 0)&&((search_files[i].folder->date) < (search_files[trouve].folder->date))) trouve = i;
		}
	      affiche_row(&search_files[trouve]);
	      search_files[trouve].val = 1;
	      fin = 0;
	    }
	}
    }
  gtk_clist_thaw((GtkCList *)search_list);
}



void affiche_row(search_info *info)
{
  gchar *data[7];
  int fin;
  int j;
  int row;
  char temp[100];

  if (is_folder(info->folder) == 1)
    {
      data[0] = g_strdup(" ");
      data[3] = g_strdup("0");
      data[4] = g_strdup(get_time(info->folder->date));
      data[2] = g_strdup(info->data[0]);
      data[1] = g_strdup(info->data[1]);
      data[5] = g_strdup(categories[info->folder->categorie]);
      data[6] = g_strdup(descriptions[info->folder->description]);
      row = gtk_clist_append( (GtkCList *) search_list, data);
      gtk_clist_set_pixtext((GtkCList  *)search_list,row,0,info->folder->name,3,base_pixmap[0],base_mask[0] );
      gtk_clist_set_row_data((GtkCList  *)search_list,row,info->folder);
    }
  if (is_file(info->folder) == 1)
    {
      data[0] = g_strdup(info->folder->name);
      data[3] = g_strdup(get_size(info->folder->taille));
      data[4] = g_strdup(get_time(info->folder->date));
      data[2] = g_strdup(info->data[0]);
      data[1] = g_strdup(info->data[1]);
      data[5] = g_strdup(categories[info->folder->categorie]);
      if ((info->folder->categorie == 0)&&(info->folder->information != NULL))
	{
	  strncpy(temp,info->folder->information,90);
	  temp[89] = '\0';
       	  data[6] = temp;
	}
      else data[6] = g_strdup(descriptions[info->folder->description]);	
      row = gtk_clist_append( (GtkCList *) search_list, data); 
	      
      j = 0;
      fin = 0;
      while ((fin == 0)&&(j <nb_extensions))
	{
	  if (fnmatch(ext_list[j].name,info->folder->name, (1 << 4)) == 0)
	    {
	      gtk_clist_set_pixtext((GtkCList  *)search_list,row,0,info->folder->name,3,pixmap_list[ext_list[j].pos],mask_list[ext_list[j].pos] );
	      fin = 1;
	    }
	  j++;
	}
      if (fin == 0) gtk_clist_set_pixtext((GtkCList  *)search_list,row,0,info->folder->name,3,base_pixmap[1],base_mask[1] );
      gtk_clist_set_row_data((GtkCList  *)search_list,row,info->folder);
    }
}




void search_in_data(Folder *folder, gchar *filename,gchar *infostring, int in_file, int in_folder, int sensitive, gchar *cur_disk, gchar *cur_path)
{
  gchar *path;
  int i;

  if (is_disk(folder) == 0)
    {
      path = g_strconcat(cur_path,folder->name,NULL);
      path = g_strconcat(path,"/",NULL);
    }
  else path = g_strdup(cur_path);
  if ((in_folder == 1)&& (test_file(filename, folder->name, sensitive) == 0)&&(test_cat(folder->categorie) == 1)&&(test_desc(folder->description) == 1)&&
      ((folder->information != NULL)&&(test_file(infostring, folder->information, sensitive) == 0)))
    {
      search_files = (search_info *)realloc(search_files,(nb_files +1)*sizeof(search_info));
      search_files[nb_files].data[0] = g_strdup(path);
      search_files[nb_files].data[1] = g_strdup(cur_disk);
      search_files[nb_files].val = 0;
      search_files[nb_files].folder = folder;
      
      nb_files++;
      nb_folders++;
    }
  if ((folder->nb_files > 0)&&(in_file == 1))
    {
      for(i=0;i<folder->nb_files;i++)
	{
	  if((test_file(filename, folder->files[i].name, sensitive) == 0)&&(test_cat(folder->files[i].categorie) == 1)&&(test_desc(folder->files[i].description) == 1&&((folder->files[i].information != NULL)&&(test_file(infostring, folder->files[i].information, sensitive) == 0))))
	    {
	      search_files = (search_info *)realloc(search_files,(nb_files +1)*sizeof(search_info));
	      search_files[nb_files].data[0] = g_strdup(path);
	      search_files[nb_files].data[1] = g_strdup(cur_disk);
	      search_files[nb_files].val = 0;
	      search_files[nb_files].folder = &folder->files[i];
	      
	     /* j = 0;
	      fin = 0;
	      while ((fin == 0)&&(j <nb_extensions))
		{
		  if (fnmatch(ext_list[j].name,folder->files[i].name, (1 << 4)) == 0)
		    {
		      gtk_clist_set_pixtext((GtkCList  *)search_list,nb_files,0,folder->files[i].name,3,pixmap_list[ext_list[j].pos],mask_list[ext_list[j].pos] );
		      fin = 1;
		    }
		  j++;
		}
	      if (fin == 0) gtk_clist_set_pixtext((GtkCList  *)search_list,nb_files,0,folder->files[i].name,3,base_pixmap[1],base_mask[1] );
	      gtk_clist_set_row_data((GtkCList  *)search_list,nb_files,folder->files[i].parent);*/
	      nb_files++;  
	    }
	}
    }
  if (folder->nb_folders > 0)
    {
      for(i=0;i<folder->nb_folders;i++)
	{
	  search_in_data(&folder->folders[i], filename,infostring, in_file, in_folder, sensitive, cur_disk, path);
	}
    }
}


