.TH GMTCONVERT l "1 November 1999"
.SH NAME
gmtconvert \- Convert between ASCII and binary 1-D tables
.SH SYNOPSIS
\fBgmtconvert\fP [ \fIinputfiles\fP] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-V\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP]\fIn\fP ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBgmtconvert\fP reads its standard input [or inputfiles] and writes out
the information to standard output.  Its main purpose is to convert between
binary and ASCII data tables.  Input (and hence output) may have multiple
subheaders if \fB\-M\fP is selected.
.TP
\fIdatafile(s)\fP
ASCII (or binary, see \fB\-bi\fP) file(s) holding a number of data columns. 
.SH OPTIONS
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To convert the binary file test.b (single precision) with 4 columns to ASCII, try
.br
.sp
gmtconvert test.b \fB\-bis\fP4 > test.dat
.br
.sp
To convert the multiple segment ASCII table test.d to a double precision binary file, try
.br
.sp
gmtconvert test.d \fB\-M \-bo\fP > test.b
.SH BUGS
When GMT is installed under a non-UNIX operating system, such as Windows 95/98/NT or
the Cygnus or DJGPP ports of GNU to Windows, binary output to stdout will not work.
This is because stdout is done in TEXT mode (instead of BINARY) mode; on Unix systems there
is only one mode and no problem.  The workaround on Win32 platforms is to append
\fB:\fP\fIbname\fP to the \fB\-bo\fP which forces an internal redirection of output to the
file \fIbname\fP.  See GMT Technical Reference Appendix L for more details.
.SH "SEE ALSO"
.IR gmt (l),
.IR minmax (l)
