.TH BLOCKMODE l "1 November 1999"
.SH NAME
blockmode \- filter to block average (x,y,z) data by mode estimation.
.SH SYNOPSIS
\fBblockmode\fP [ \fIxyz[w]file(s)\fP ] \fB\-I\fP\fIx_inc\fP[\fBm|c\fP][/\fIy_inc\fP[\fBm|c\fP]]  
\fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-N\fP ] [ \fB\-Q\fP ] [ \fB\-V\fP ] 
[ \fB\-W\fP[\fBio\fP] ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] [ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBblockmode\fP reads arbitrarily located (x,y,z) triples [or optionally weighted
quadruples (x,y,z,w)] from standard input [or \fIxyz[w]file(s)\fP] and writes to standard output mode estimates of position and
value for every non-empty block in a grid region defined by the \fB\-R\fP and \fB\-I\fP arguments.
Either \fBblockmean\fP, \fBblockmedian\fP, or \fBblockmode\fP should be used as a pre-processor before running \fBsurface\fP to avoid
aliasing short wavelengths.  These routines are also  generally useful for decimating or averaging
(x,y,z) data.  You can modify the
precision of the output format by editing the D_FORMAT parameter in your .gmtdefaults file, or
you may choose binary input and/or output using single or double precision storage.
.TP
\fIxyz[w]file(s)\fP
3 [or 4] column ASCII file(s) [or binary, see \fB\-b\fP] holding (x,y,z[,w]) data values.  [w] is an optional weight for the data.
If no file is specified, \fBblockmode\fP will read from standard input.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to indicate minutes or \fBc\fP to indicate seconds.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
.sp
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
Not used with binary data.
.TP
.B \-N
Block centers have pixel registration. [Default:  grid registration.]  (Registrations are defined in 
GMT Cookbook Appendix B on grid file formats.)  Each block is the locus of points nearest the grid value 
location.  For example, with \fB\-R\fP10/15/10/15 and and \fB\-I\fP1:  with the \fB\-N\fP option 10 <= 
(x,y) < 11 is one of 25 blocks; without it 9.5 <= (x,y) < 10.5 is one of 36 blocks.
.TP
.B \-Q
(Quicker) Finds mode z and mean (x, y) [Default finds mode x, mode y, mode z].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Weighted modifier[s].  Unweighted input and output has 3 columns x,y,z; Weighted i/o has 4 columns x,y,z,w.
Weights can be used in input to construct weighted modal values in blocks.  Weight sums can be reported in
output for later combining several runs, etc.  Use \fB\-W\fP for weighted i/o, \fB\-Wi\fP for weighted input
only, \fB\-Wo\fP for weighted output only.  [Default uses unweighted i/o]
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 3 (or 4 if \fP\-W\fP is set) columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To find 5 by 5 minute block mode estimates from the double precision binary data in hawaii_b.xyg and output an ASCII table, try
.sp
blockmode hawaii_b.xyg \fB\-R\fP198/208/18/25 \fB\-I\fP5\fBm \-bi\fP3 > hawaii_5x5.xyg
.SH "SEE ALSO"
.IR blockmean (l),
.IR blockmedian (l),
.IR gmt (l),
.IR gmtdefaults (l),
.IR nearneighbor (l),
.IR surface (l),
.IR triangulate (l)
