
/*  A Bison parser, made from rules.y with Bison version GNU Bison version 1.22
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TOK_IF	258
#define	TOK_PRECIOUS	259
#define	TOK_MODULO	260
#define	TOK_GEQ	261
#define	TOK_LEQ	262
#define	TOK_NEQ	263
#define	TOK_ARROW	264
#define	TOK_SHIFT	265
#define	INDEX	266
#define	INTEGER	267
#define	IDENTIFIER	268
#define	BIG_INTEGER	269
#define	QSTRING	270
#define	UNARY_PLUS	271
#define	UNARY_MINUS	272

#line 10 "rules.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "saml.h"
#include "induce.h"

#define yyerror(s) fprintf(stderr, "induce: %s\n", s)

static char* bcode_three (char* bc1, char* bc2, char* bc3, const char* bc4)
{
	bc1 = realloc(bc1, strlen(bc1) + strlen(bc2) + strlen(bc3)
		+ strlen(bc4) + 4);
	assert(bc1 != NULL);
	strcat(bc1, bc2); free(bc2);
	strcat(bc1, bc3); free(bc3);
	return strcat(bc1, bc4);
}

static char* bcode_join (char* bc1, char* bc2, const char* bc3)
{
	bc1 = realloc(bc1, strlen(bc1)+strlen(bc2)+strlen(bc3)+3);
	assert(bc1 != NULL);
	strcat(bc1, bc2);
	free(bc2);
	return strcat(bc1, bc3);
}

static char* bcode_append (char* bc1, const char* bc2)
{
	bc1 = realloc(bc1, strlen(bc1)+strlen(bc2)+2);
	assert(bc1 != NULL);
	return strcat(bc1, bc2);
}

static char* bcode_exponent (char* bc1, int exp)
{
	char buff[24];
	
	if (exp < -1)
	  	sprintf(buff, "i%d^", -exp);
	else if (exp == -1)
		strcpy(buff, "i");
	else /* if (exp >= 0) */
		sprintf(buff, "%d^", exp);

	return bcode_append(bc1, buff);
}

static char* bcode_function (char *bc1, int fn)
{
	char buff[24];
	sprintf(buff, "%df", fn);
	return bcode_append(bc1, buff);
}

static char* bcode_index (int index)
{
	char buff[24];
	sprintf(buff, "%dp", index);
	return strdup(buff);
}

static char* bcode_integer (int i)
{
	char buff[24];
	sprintf(buff, "%d.", i);
	return strdup(buff);
}

static void restricted_index (char* bcode)
{
	int i = new_index(strdup("$__restricted__$"));
	char *cond = bcode_join(bcode, bcode_index(i), "-!");
	collect_condition(cond);
}


#line 90 "rules.y"
typedef union {
	int	integer;
	char*	string;
	alist	arglist;
} YYSTYPE;

#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		153
#define	YYFLAG		-32768
#define	YYNTBASE	37

#define YYTRANSLATE(x) ((unsigned)(x) <= 272 ? yytranslate[x] : 65)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    25,     2,     2,     2,    24,     2,     2,    32,
    33,    21,    19,    31,    20,    22,    23,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    29,    30,    18,
    16,    17,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    34,     2,    35,    28,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,    36,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    26,    27
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     5,     9,    13,    14,    16,    18,    22,    27,
    28,    33,    34,    38,    39,    43,    48,    50,    54,    56,
    58,    59,    62,    64,    68,    73,    74,    76,    78,    82,
    84,    86,    94,    98,   102,   106,   110,   114,   118,   121,
   124,   127,   131,   135,   143,   145,   151,   157,   158,   162,
   164,   166,   168,   169,   173,   178,   180,   184,   189,   190,
   192,   194,   198,   200,   202,   204,   208,   212,   216,   220,
   224,   228,   232,   236,   239,   242,   245,   249,   253,   257,
   261,   265,   269,   271
};

static const short yyrhs[] = {    -1,
    37,    42,    30,     0,    37,    38,    30,     0,     4,    39,
    40,     0,     0,    15,     0,    41,     0,    40,    31,    41,
     0,    13,    32,    12,    33,     0,     0,    43,    16,    53,
    48,     0,     0,    13,    44,    45,     0,     0,    45,    34,
    35,     0,    45,    34,    46,    35,     0,    47,     0,    46,
    31,    47,     0,    13,     0,    63,     0,     0,     3,    49,
     0,    63,     0,    49,    31,    63,     0,    13,    32,    51,
    33,     0,     0,    52,     0,    53,     0,    52,    31,    53,
     0,    57,     0,    50,     0,    53,     5,    32,    53,    31,
    53,    33,     0,    32,    54,    33,     0,    53,    19,    53,
     0,    53,    20,    53,     0,    53,    21,    53,     0,    53,
    22,    53,     0,    53,    23,    53,     0,    20,    53,     0,
    19,    53,     0,    25,    53,     0,    53,    28,    12,     0,
    53,    29,    55,     0,    36,    55,    32,    53,    31,    53,
    33,     0,    53,     0,    54,    31,    53,     9,    53,     0,
    54,    31,    53,    10,    53,     0,     0,    13,    56,    58,
     0,    55,     0,    64,     0,    11,     0,     0,    58,    34,
    35,     0,    58,    34,    59,    35,     0,    63,     0,    59,
    31,    63,     0,    13,    32,    61,    33,     0,     0,    62,
     0,    63,     0,    62,    31,    63,     0,    60,     0,    11,
     0,    12,     0,    32,    63,    33,     0,    63,    19,    63,
     0,    63,    20,    63,     0,    63,    21,    63,     0,    63,
    22,    63,     0,    63,    23,    63,     0,    63,    24,    63,
     0,    63,    28,    12,     0,    20,    63,     0,    19,    63,
     0,    25,    63,     0,    63,    16,    63,     0,    63,     8,
    63,     0,    63,    18,    63,     0,    63,    17,    63,     0,
    63,     6,    63,     0,    63,     7,    63,     0,    12,     0,
    14,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   113,   114,   115,   118,   120,   121,   124,   125,   128,   132,
   133,   137,   140,   142,   143,   144,   147,   148,   151,   153,
   157,   158,   161,   163,   167,   172,   174,   177,   179,   184,
   185,   186,   193,   195,   197,   199,   201,   203,   205,   207,
   209,   211,   213,   215,   219,   221,   223,   227,   230,   233,
   235,   237,   243,   244,   245,   248,   250,   254,   259,   261,
   264,   266,   271,   272,   274,   276,   278,   280,   282,   284,
   286,   288,   290,   292,   294,   296,   298,   300,   302,   304,
   306,   308,   312,   315
};

static const char * const yytname[] = {   "$","error","$illegal.","TOK_IF","TOK_PRECIOUS",
"TOK_MODULO","TOK_GEQ","TOK_LEQ","TOK_NEQ","TOK_ARROW","TOK_SHIFT","INDEX","INTEGER",
"IDENTIFIER","BIG_INTEGER","QSTRING","'='","'>'","'<'","'+'","'-'","'*'","'.'",
"'/'","'%'","'!'","UNARY_PLUS","UNARY_MINUS","'^'","':'","';'","','","'('","')'",
"'['","']'","'~'","list_of_rules","precious_decl","opt_memo_name","list_precious_things",
"precious_thing","rule","rule_lhs","@1","optional_indices","list_of_indices",
"ident_or_iexpr","optional_condition","list_of_conditions","ext_function","opt_exfn_args",
"exfn_args","expr","nested_expr","ident","@2","idx_var","optional_list_iexprs",
"list_iexprs","iext_function","opt_iexfn_args","iexfn_args","iexpr","number",
""
};
#endif

static const short yyr1[] = {     0,
    37,    37,    37,    38,    39,    39,    40,    40,    41,    42,
    42,    44,    43,    45,    45,    45,    46,    46,    47,    47,
    48,    48,    49,    49,    50,    51,    51,    52,    52,    53,
    53,    53,    53,    53,    53,    53,    53,    53,    53,    53,
    53,    53,    53,    53,    54,    54,    54,    56,    55,    57,
    57,    57,    58,    58,    58,    59,    59,    60,    61,    61,
    62,    62,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    63,    63,    63,    63,    63,    63,    63,    63,    63,
    63,    63,    64,    64
};

static const short yyr2[] = {     0,
     0,     3,     3,     3,     0,     1,     1,     3,     4,     0,
     4,     0,     3,     0,     3,     4,     1,     3,     1,     1,
     0,     2,     1,     3,     4,     0,     1,     1,     3,     1,
     1,     7,     3,     3,     3,     3,     3,     3,     2,     2,
     2,     3,     3,     7,     1,     5,     5,     0,     3,     1,
     1,     1,     0,     3,     4,     1,     3,     4,     0,     1,
     1,     3,     1,     1,     1,     3,     3,     3,     3,     3,
     3,     3,     3,     2,     2,     2,     3,     3,     3,     3,
     3,     3,     1,     1
};

static const short yydefact[] = {     1,
    10,     5,    12,     0,     0,     0,     6,     0,    14,     3,
     2,     0,     0,     4,     7,    13,    52,    83,    48,    84,
     0,     0,     0,     0,     0,    31,    21,    50,    30,    51,
     0,     0,     0,    26,    53,    40,    39,    41,    45,     0,
    48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,    11,     0,     8,    64,    65,    19,     0,     0,     0,
     0,    15,     0,    17,    63,    20,     0,    27,    28,    49,
     0,    33,     0,     0,    22,    23,     0,    34,    35,    36,
    37,    38,    42,    43,     9,    59,    75,    74,    76,     0,
     0,    16,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    25,     0,     0,     0,     0,
     0,     0,     0,    60,    61,    66,    18,    81,    82,    78,
    77,    80,    79,    67,    68,    69,    70,    71,    72,    73,
    29,    54,     0,    56,     0,     0,     0,    24,     0,    58,
     0,     0,    55,    46,    47,     0,     0,    62,    57,    44,
    32,     0,     0
};

static const short yydefgoto[] = {     1,
     4,     8,    14,    15,     5,     6,     9,    16,    63,    64,
    52,    75,    26,    67,    68,    27,    40,    28,    35,    29,
    70,   133,    65,   113,   114,    66,    30
};

static const short yypact[] = {-32768,
     4,    -4,-32768,   -23,    -7,    -1,-32768,     9,-32768,-32768,
-32768,   168,     7,    10,-32768,     6,-32768,-32768,    12,-32768,
   168,   168,   168,   168,    33,-32768,   125,-32768,-32768,-32768,
    36,     9,   199,   168,-32768,    -8,    -8,    -8,   216,   -15,
-32768,    13,    76,    17,   168,   168,   168,   168,   168,    39,
    33,-32768,    25,-32768,-32768,-32768,    27,    76,    76,    76,
    76,-32768,   -26,-32768,-32768,   249,    29,    46,   216,    44,
   168,-32768,   168,    27,    49,   249,   168,    32,    32,    -8,
    -8,    -8,-32768,-32768,-32768,    76,    35,    35,    35,   103,
   263,-32768,    76,    76,    76,    76,    76,    76,    76,    76,
    76,    76,    76,    76,    69,-32768,   168,   229,   186,   136,
    76,   155,    50,    53,   249,-32768,-32768,   270,   270,   270,
   270,   270,   270,   111,   111,    35,    35,    35,    35,-32768,
   216,-32768,   -25,   249,   168,   168,   168,   249,   168,-32768,
    76,    76,-32768,   216,   216,    14,    71,   249,   249,-32768,
-32768,    85,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,    65,-32768,-32768,-32768,-32768,-32768,    11,
-32768,-32768,-32768,-32768,-32768,   -21,-32768,   -13,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,   -29,-32768
};


#define	YYLAST		298


static const short yytable[] = {    36,
    37,    38,    39,   152,    91,   142,    10,     2,    92,   143,
     7,    42,    69,    76,    12,    71,     3,    72,    44,    50,
    51,    13,    11,    78,    79,    80,    81,    82,    87,    88,
    89,    90,    45,    46,    47,    48,    49,    84,    31,    33,
    32,    50,    51,    34,    73,    41,   150,    53,    77,   109,
    83,   110,    47,    48,    49,   112,   115,    85,    86,    50,
    51,   106,   105,   118,   119,   120,   121,   122,   123,   124,
   125,   126,   127,   128,   129,    44,   107,   108,   134,   111,
   130,   138,   140,   141,   153,   131,    55,    56,    74,    45,
    46,    47,    48,    49,    58,    59,    54,     0,    50,    51,
    60,   117,     0,   151,     0,     0,     0,    61,    93,    94,
    95,   148,   149,   144,   145,   146,     0,   147,    96,    97,
    98,    99,   100,   101,   102,   103,   104,    43,     0,    44,
   105,   101,   102,   103,   104,   116,     0,     0,   105,     0,
    44,     0,     0,    45,    46,    47,    48,    49,     0,     0,
     0,     0,    50,    51,    45,    46,    47,    48,    49,    44,
     0,     0,     0,    50,    51,     0,   137,     0,     0,     0,
     0,     0,     0,    45,    46,    47,    48,    49,    17,    18,
    19,    20,    50,    51,     0,   139,    21,    22,     0,     0,
    44,     0,    23,     0,   135,   136,     0,     0,     0,    24,
     0,     0,     0,    25,    45,    46,    47,    48,    49,    55,
    56,    57,     0,    50,    51,     0,     0,    58,    59,     0,
    44,     0,     0,    60,     0,     0,     0,     0,     0,     0,
    61,     0,     0,    62,    45,    46,    47,    48,    49,    55,
    56,    74,     0,    50,    51,     0,     0,    58,    59,     0,
     0,     0,     0,    60,    93,    94,    95,     0,     0,     0,
    61,     0,     0,   132,    96,    97,    98,    99,   100,   101,
   102,   103,   104,    55,    56,    57,   105,     0,     0,     0,
     0,    58,    59,     0,     0,     0,     0,    60,    99,   100,
   101,   102,   103,   104,    61,     0,     0,   105
};

static const short yycheck[] = {    21,
    22,    23,    24,     0,    31,    31,    30,     4,    35,    35,
    15,    25,    34,    43,    16,    31,    13,    33,     5,    28,
    29,    13,    30,    45,    46,    47,    48,    49,    58,    59,
    60,    61,    19,    20,    21,    22,    23,    51,    32,    34,
    31,    28,    29,    32,    32,    13,    33,    12,    32,    71,
    12,    73,    21,    22,    23,    77,    86,    33,    32,    28,
    29,    33,    28,    93,    94,    95,    96,    97,    98,    99,
   100,   101,   102,   103,   104,     5,    31,    34,   108,    31,
    12,   111,    33,    31,     0,   107,    11,    12,    13,    19,
    20,    21,    22,    23,    19,    20,    32,    -1,    28,    29,
    25,    91,    -1,    33,    -1,    -1,    -1,    32,     6,     7,
     8,   141,   142,   135,   136,   137,    -1,   139,    16,    17,
    18,    19,    20,    21,    22,    23,    24,     3,    -1,     5,
    28,    21,    22,    23,    24,    33,    -1,    -1,    28,    -1,
     5,    -1,    -1,    19,    20,    21,    22,    23,    -1,    -1,
    -1,    -1,    28,    29,    19,    20,    21,    22,    23,     5,
    -1,    -1,    -1,    28,    29,    -1,    31,    -1,    -1,    -1,
    -1,    -1,    -1,    19,    20,    21,    22,    23,    11,    12,
    13,    14,    28,    29,    -1,    31,    19,    20,    -1,    -1,
     5,    -1,    25,    -1,     9,    10,    -1,    -1,    -1,    32,
    -1,    -1,    -1,    36,    19,    20,    21,    22,    23,    11,
    12,    13,    -1,    28,    29,    -1,    -1,    19,    20,    -1,
     5,    -1,    -1,    25,    -1,    -1,    -1,    -1,    -1,    -1,
    32,    -1,    -1,    35,    19,    20,    21,    22,    23,    11,
    12,    13,    -1,    28,    29,    -1,    -1,    19,    20,    -1,
    -1,    -1,    -1,    25,     6,     7,     8,    -1,    -1,    -1,
    32,    -1,    -1,    35,    16,    17,    18,    19,    20,    21,
    22,    23,    24,    11,    12,    13,    28,    -1,    -1,    -1,
    -1,    19,    20,    -1,    -1,    -1,    -1,    25,    19,    20,
    21,    22,    23,    24,    32,    -1,    -1,    28
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#define YYLEX		yylex(&yylval, &yylloc)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_bcopy(FROM,TO,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (char *from, char *to, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 184 "/usr/lib/bison.simple"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 5:
#line 120 "rules.y"
{ register_memo(memo_file); ;
    break;}
case 6:
#line 121 "rules.y"
{ register_memo(yyvsp[0].string); ;
    break;}
case 9:
#line 129 "rules.y"
{ declare_precious(yyvsp[-3].string,yyvsp[-1].integer); ;
    break;}
case 11:
#line 134 "rules.y"
{ add_this_rule(yyvsp[-1].string); ;
    break;}
case 12:
#line 138 "rules.y"
{ start_new_rule(yyvsp[0].string); ;
    break;}
case 19:
#line 152 "rules.y"
{ new_index(yyvsp[0].string); ;
    break;}
case 20:
#line 154 "rules.y"
{ restricted_index(yyvsp[0].string); ;
    break;}
case 23:
#line 162 "rules.y"
{ collect_condition(yyvsp[0].string); ;
    break;}
case 24:
#line 164 "rules.y"
{ collect_condition(yyvsp[0].string); ;
    break;}
case 25:
#line 168 "rules.y"
{ int fn = register_function(yyvsp[-3].string, yyvsp[-1].arglist.arity);
	    yyval.string = bcode_function(yyvsp[-1].arglist.bytecode, fn); ;
    break;}
case 26:
#line 173 "rules.y"
{ yyval.arglist.arity = 0; yyval.arglist.bytecode = strdup(""); ;
    break;}
case 28:
#line 178 "rules.y"
{ yyval.arglist.arity = 1; yyval.arglist.bytecode = yyvsp[0].string; ;
    break;}
case 29:
#line 180 "rules.y"
{ yyval.arglist.arity = yyvsp[-2].arglist.arity + 1;
	      yyval.arglist.bytecode = bcode_join(yyvsp[-2].arglist.bytecode, yyvsp[0].string, ""); ;
    break;}
case 32:
#line 187 "rules.y"
{
	    	int fn = register_function("modulo", 3);
	    	char buff[24];
	    	sprintf(buff, "%df", fn);
	    	yyval.string = bcode_three(yyvsp[-6].string,yyvsp[-3].string,yyvsp[-1].string,buff);
	    ;
    break;}
case 33:
#line 194 "rules.y"
{ yyval.string = yyvsp[-1].string; ;
    break;}
case 34:
#line 196 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"+"); ;
    break;}
case 35:
#line 198 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-"); ;
    break;}
case 36:
#line 200 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"*"); ;
    break;}
case 37:
#line 202 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"*"); ;
    break;}
case 38:
#line 204 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"/"); ;
    break;}
case 39:
#line 206 "rules.y"
{ yyval.string = bcode_append(yyvsp[0].string,"n"); ;
    break;}
case 40:
#line 208 "rules.y"
{ yyval.string = yyvsp[0].string; ;
    break;}
case 41:
#line 210 "rules.y"
{ yyval.string = bcode_append(yyvsp[0].string,"!"); ;
    break;}
case 42:
#line 212 "rules.y"
{ yyval.string = bcode_exponent(yyvsp[-2].string,yyvsp[0].integer); ;
    break;}
case 43:
#line 214 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"d"); ;
    break;}
case 44:
#line 216 "rules.y"
{ yyval.string = bcode_three(yyvsp[-5].string,yyvsp[-3].string,yyvsp[-1].string,"r"); ;
    break;}
case 45:
#line 220 "rules.y"
{ yyval.string = yyvsp[0].string; ;
    break;}
case 46:
#line 222 "rules.y"
{ yyval.string = bcode_three(yyvsp[-4].string,yyvsp[-2].string,yyvsp[0].string,"s"); ;
    break;}
case 47:
#line 224 "rules.y"
{ yyval.string = bcode_three(yyvsp[-4].string,yyvsp[-2].string,yyvsp[0].string,"S"); ;
    break;}
case 48:
#line 228 "rules.y"
{ start_idxvar(yyvsp[0].string); ;
    break;}
case 49:
#line 230 "rules.y"
{ yyval.string = collect_idxvar(); ;
    break;}
case 50:
#line 234 "rules.y"
{ yyval.string = yyvsp[0].string; ;
    break;}
case 51:
#line 236 "rules.y"
{ start_idxvar(yyvsp[0].string); yyval.string = collect_idxvar(); ;
    break;}
case 52:
#line 238 "rules.y"
{ start_idxvar("__value__");
	      collect_iexpr(bcode_index(yyvsp[0].integer));
	      yyval.string = collect_idxvar(); ;
    break;}
case 56:
#line 249 "rules.y"
{ collect_iexpr(yyvsp[0].string); ;
    break;}
case 57:
#line 251 "rules.y"
{ collect_iexpr(yyvsp[0].string); ;
    break;}
case 58:
#line 255 "rules.y"
{ int fn = register_function(yyvsp[-3].string, yyvsp[-1].arglist.arity);
	    yyval.string = bcode_function(yyvsp[-1].arglist.bytecode, fn); ;
    break;}
case 59:
#line 260 "rules.y"
{ yyval.arglist.arity = 0; yyval.arglist.bytecode = strdup(""); ;
    break;}
case 61:
#line 265 "rules.y"
{ yyval.arglist.arity = 1; yyval.arglist.bytecode = yyvsp[0].string; ;
    break;}
case 62:
#line 267 "rules.y"
{ yyval.arglist.arity = yyvsp[-2].arglist.arity + 1;
	      yyval.arglist.bytecode = bcode_join(yyvsp[-2].arglist.bytecode, yyvsp[0].string, ""); ;
    break;}
case 64:
#line 273 "rules.y"
{ yyval.string = bcode_index(yyvsp[0].integer); ;
    break;}
case 65:
#line 275 "rules.y"
{ yyval.string = bcode_integer(yyvsp[0].integer); ;
    break;}
case 66:
#line 277 "rules.y"
{ yyval.string = yyvsp[-1].string; ;
    break;}
case 67:
#line 279 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"+"); ;
    break;}
case 68:
#line 281 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-"); ;
    break;}
case 69:
#line 283 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"*"); ;
    break;}
case 70:
#line 285 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"*"); ;
    break;}
case 71:
#line 287 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"/"); ;
    break;}
case 72:
#line 289 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"%"); ;
    break;}
case 73:
#line 291 "rules.y"
{ yyval.string = bcode_exponent(yyvsp[-2].string,yyvsp[0].integer); ;
    break;}
case 74:
#line 293 "rules.y"
{ yyval.string = bcode_append(yyvsp[0].string,"n"); ;
    break;}
case 75:
#line 295 "rules.y"
{ yyval.string = yyvsp[0].string; ;
    break;}
case 76:
#line 297 "rules.y"
{ yyval.string = bcode_append(yyvsp[0].string,"!"); ;
    break;}
case 77:
#line 299 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-!"); ;
    break;}
case 78:
#line 301 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-!!"); ;
    break;}
case 79:
#line 303 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-<"); ;
    break;}
case 80:
#line 305 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"->"); ;
    break;}
case 81:
#line 307 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"-<!"); ;
    break;}
case 82:
#line 309 "rules.y"
{ yyval.string = bcode_join(yyvsp[-2].string,yyvsp[0].string,"->!"); ;
    break;}
case 83:
#line 313 "rules.y"
{ char buff[24]; sprintf(buff, "%d", yyvsp[0].integer);
	      yyval.string = strdup(buff); ;
    break;}
case 84:
#line 316 "rules.y"
{ yyval.string = yyvsp[0].string; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 465 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 318 "rules.y"
