-*- indented-text -*-

($Revision: 5.3 $)

ESS: Using SAS
==============

The SAS module in ESS (ESS[SAS]) is currently undergoing development.
It is not yet as stable as the S language support.  It is functional,
although slightly rough.  Please send any suggestions and bug reports
to ess-bugs@stat.math.ethz.ch.

ESS (originally S-mode) was initially designed for use with S and
S-PLUS(tm).  ESS has recently been extended to support other
languages, including SAS(tm).  The editing of SAS files is based on
the stable, old SAS mode by Cook
(ftp://ftp.biostat.wisc.edu/pub/cook/sas-mode/sas.tar.gz).  Those
editing features and new advanced features are being merged with the
development of ESS[SAS].  The user interface with ESS[SAS] is similar
in behavior to the interface for S (unlike Cook's SAS mode) and to the
windowing interface that SAS itself uses.

We denote by _Emacs_ one of the GNU family of editors, either Emacs
(as developed and maintained by the Free Software Foundation) or
XEmacs (which is a derivative work).

The following is covered in this document:
- general Emacs features.
- Editing files.
- running a SAS process as an inferior process to Emacs
- Scenarios for use (possibilities, based on actual usage)
- using transcripts.
- Design Philosophy


Emacs: General features
=======================

We assume that you are familiar with Emacs terminology and syntax:
file, buffer, region, description of keys etc.  If not, please read
the New Users guide (found in the info pages, "C-h i" (by pressing
control h, i) or Tutorial, "C-h t").


ESS[SAS]: Editing Files
=======================

ESS[SAS] is the mode for editing S language files.  This mode handles:

- proper indenting, generated by both [Tab] and [Return].
- color and font choices based on syntax.
- ability to send the contents of an entire buffer, a highlighted region,
  or a single line to an inferior SAS process, if one is currently running.
- ability to switch between processes which would be the target of the
  buffer (for the above).

ESS[SAS] should be automatically turned on when loading a file with a
".sas" suffix (or other, if specified in ess-site).  However, one will
have to start up an inferior process to take advantage of the
interactive capabilities.

At this writing (ESS release 5.0), the indenting and syntactic
highlighting are not completely correct.


iESS: Inferior ESS processes
============================

iESS (inferior ESS) is the mode for interfacing with active
statistical processes (programs).  This mode handles:

- proper indenting, generated by both [Tab] and [Return].
- color and font highlighting based on syntax.
- interactive history mechanism
- transcript recording and editing

We plan to add
- The ability to request help from a process for variables and
  functions, and to have the results sent into a separate buffer.
- completion of object names and file names.

To start up iESS[SAS] mode, use:
   M-x SAS



Scenarios for use
=================

We present one scenario for using ESS to interact with SAS.
Contributions of examples of how you work with ESS are appreciated
(especially since it helps us determine priorities on future
enhancements)! (comments as to what should be happening are prefixed
by "##").

    ## Load the file you want to work with
    C-x C-f myfile.sas
    ## myfile.sas will be in ESS[SAS] mode

    ## Edit as appropriate, and then start up SAS with the cursor in
    ## the myfile.sas buffer
    M-x SAS

    ## Four buffers will appear on screen:
    ## myfile.sas  in  ESS[SAS]        mode # your source file
    ## *SAS:1*     in  iESS [SAS:1]    mode # ESS communication buffer
    ## *SAS:1.log* in  Shell [] ESStr  mode # SAS log information
    ## *SAS:1.lst* in  Shell [] ESSlst mode # SAS listing information

    ## If you would prefer each of the four buffers to appear in its
    ## own individual frame, you can arrange for that.  Place the
    ## cursor in the buffer displaying myfile.sas.  Enter the
    ## sequence:
    C-c C-w

    ## The cursor will normally be in buffer myfile.sas.
    ## If not, put it there:
    C-x b myfile.sas

    ## Send regions, lines, or the entire file contents to SAS
    ## (regions are most useful).  A highlighted region will normally
    ## begin with the keywords 'DATA' or 'PROC' and end with the
    ## keyword 'RUN;'
    C-c C-r

    ## Information appears in the log buffer, analysis results in the
    ## listing buffer.  In case of errors, make the corrections in the
    ## myfile.sas buffer and resubmit with another C-c C-r

    ## PROC GPLOT graphs will normally be produced in a postscript
    ## file and be viewed later.  Include the lines
    /* required gsoptions for batch files */
    /* comment out these lines for interactive use on X-terminals*/
    filename grafout 'temp.ps';
    goptions device=ps gsfname=grafout gsfmode=append gaccess=sasgastd;
    ## in myfile.sas.

    ## PROC PLOT graphs can be viewed in the listing buffer.  You may
    ## wish to control the vertical spacing to allow the entire plot
    ## to be visible on screen, for example, by
    proc plot; plot a*b / vpos=25;

    ## At the end of the session you may save the log and listing
    ## buffers with the usual C-x C-s commands.  You will be prompted
    ## for a file name.  Typically, the names myfile.log and mfile.lst
    ## will be used.  You will almost certainly want to edit the saved
    ## files before including them in a report.  The files are
    ## read-only by default.  You can make them writable by the Emacs
    ## command C-x C-q.

    ## At the end of the session, the input file myfile.sas will
    ## typically have been revised.  You can save it.  It can be used
    ## later as the beginning of another iESS[SAS] session.  It can
    ## also be used as a batch input file to SAS.

    ## The *SAS:1* buffer is strictly for ESS use.  The user should
    ## never need to read it or write to it.  Refer to the .lst and
    ## .log buffers for monitoring output!


Here is a typical myfile.sas:

    title 'Analysis of Case 0502';

    data case0502;
    	infile '/home/public/stat/Data/case0502.asc'
    	       firstobs=2;
    	input percent code;
    run;

    proc glm;
      class code;
      model percent=code /ss1;
    run;



Recommended autoexec.sas
========================

The default settings of the inferior-SAS-args in essd-sas.el
are "-stdio -linesize 80 -noovp -nosyntaxcheck"
with the interpretations:
  -stdio          required to make the redirection of stdio work
  -linesize 80    keeps output lines from folding on standard terminals
  -noovp          prevents error messages from printing 3 times
  -nosyntaxcheck  permits recovery after syntax errors

In addition there are several parameters that can't be set in the
command line.  For these, we recommend the following line appear in
your autoexec.sas in your home directory:

  options noovp pagesize=60 linesize=80 formdlim=' ';

Interpretations

  noovp          prevents error messages from printing 3 time
  pagesize=60    standard printed page length instead of window length
  linesize=80    keeps output lines from folding on standard terminals
  formdlim=' '   blank replaces "C-l" formfeeds to prevent mostly
		 empty pages

The noovp and linesize=80 appear in both the inferior-SAS-args and in
the autoexec.sas.  The redundancy means that these options are in
effect for SAS batch usage and SAS window manager usage as well as for
ESS[SAS] usage.



Using Transcripts
=================

Not yet available.  The intent is that a marked section of a log file
from a previous SAS run can be resubmitted to SAS.  The user would
highlight a region from 'PROC' to 'RUN;' and then send it to the
inferior SAS process with the [RET] key.  ESS would automatically
clean the region (remove line numbers) and send the entire region over
as a single request to SAS.


Design Philosophy
=================

ESS[SAS] mode was designed to aid the user in writing and maintaining
input command files, such as myfile.sas, for SAS.  These are files
containing SAS statements.  In a batch environment such files would be
submitted to SAS by the operating system command:
    sas myfile.sas
In a SAS window environment, these files would be brought into the
"SAS: PROGRAM EDITOR" window and then submitted with the 'Local' 'Submit'
menu commands.

The *SAS:1.log* buffer in ESStr mode corresponds to the file
myfile.log in SAS batch usage and to the "SAS: LOG" window in the SAS
window environment.  All commands submitted to SAS, informative
messages, warnings, and errors appear here.

The *SAS:1.lst* buffer in ESSlst mode corresponds to the file
myfile.lst in SAS batch usage and to the "SAS: OUTPUT" window in the
SAS window environment.  All data related printed output from the
PROCs appear in this window.

The iESS [SAS:1] buffer exists solely as a communications buffer.
Files are edited in the myfile.sas buffer.  The C-c C-r key in
ESS[SAS] mode is the functional equivalent of bringing a file into the
"SAS: PROGRAM EDITOR" window followed by the 'Local' 'Submit' menu
commands.  The user should never use this buffer directly.


The ESS[SAS] mode was written with two primary goals.

1. Using Emacs, a window environment becomes available for dial-up
users who do not have access to the SAS window environment.

2. The authors prefer the Emacs environment for editing and managing
input and output files, even on computer systems which run the SAS
window environment.

A secondary goal was also realized.

3.  With an X-windows terminal connected by ppp at 14400 baud to a
Unix system running SAS, iESS[SAS] interaction with SAS was hundreds
of times faster than the SAS window system.  The savings come because
the ESS windows are subunits of a text-based xterm window, rather than
the remotely managed graphical windows provided by SAS.  (The timings
are SAS timings from the log files.  The SAS windows times include
window management and communications times as well as calculation
times.  The iESS times include only the calculations by the SAS
computing engine.)


Some Frequently Seen Problems
=============================

1. If M-x SAS gives weird errors upon startup, check the following:
   - ess-sas-sh-command (in the ESS source directory) needs to be
     executable (solution: "chmod ugo+rx ess-sas-sh-command").
   - sas isn't in your executable path (verify using "which sas" from
     a shell command-line)
   - you need a copy of SAS (we can't solve this)

2. M-x SAS starts up SAS in the window system (motif, for example),
   instead of starting it up in the emacs buffers.

   Probably the unix command "sas" on your system calls a local
   script which in turn calls the sas executable.  The fix is to
   call the sas executable directly.

   Change the line in ess-sas-sh command from:
      sas </dev/tty 1>$stdout 2>$stderr $@
   to a call to the complete path name of the sas executable on
   your system, for example:
      /usr/local/sas612/sas </dev/tty 1>$stdout 2>$stderr $@

   To find the complete path name on your system, you can
   execute the line (from the unix prompt):
      find / -name 'sas' -exec ls -ld {} \;
   and expect a response similar to the following
   -rwxr-xr-x   1 sas      sas  2441216 Sep  9  1997 /usr/local/sas612/sas

