/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * oned.c
 */

#include <stdio.h>
#include <tk.h>
#include <string.h>

#include "pm.h"
#include "utilities.h"
#include "defaults.h"
#include "math_utils.h"
#include "manifold.h"
#include "iterate.h"
#include "view.h"

void
oned_dismiss(int n)
{
#ifdef DEBUG
  fprintf(stdout,"Deregistering ONED %d\n",n);
#endif
  dismiss_view(ONED, n);
}

void
oned_range(int n, double hormin, double hormax, double vermin, double vermax,
	   int iterate)
{
  VIEW_ITEM *view;
  ONED_VIEW_ITEM *vi;

#ifdef DEBUG
  fprintf(stdout, "Setting range for ONED %d\n",n);
#endif

  if ( NULL == (view = get_view(ONED, n)) )
    {
      fprintf(stdout, " Attempt to set range for invalid ONED view %d\n",n);
      return;
    }
  vi = &(view->data.oned);
  vi->hormin = hormin;
  vi->hormax = hormax;
  vi->vermin = vermin;
  vi->vermax = vermax;
  vi->iterate = iterate;
}

void
oned_colormode( int n, int mode )
{
  VIEW_ITEM *view;
  ONED_VIEW_ITEM *vi;

  if( NULL == (view = get_view(ONED, n)) ) {
    fprintf(stdout, "Attempt to set pick color mode for invalid ONED view %d\n",n);
    return;
  }
  vi = &(view->data.oned);
  vi->colormode = mode;
}

void
oned_config(int n, int width, int height)
{
  VIEW_ITEM *view;
  ONED_VIEW_ITEM *vi;

#ifdef DEBUG
  fprintf(stdout, "Setting range for ONED %d\n",n);
#endif

  if ( NULL == (view = get_view(ONED, n)) )
    {
      fprintf(stdout, "Attempt to config for invalid ONED view %d\n",n);
      return;
    }
  vi = &(view->data.oned);
  vi->width = width;
  vi->height = height;

}

void
oned_activate(int n)
{
  VIEW_ITEM *v;
  char buf[20];

#ifdef DEBUG
  fprintf(stdout, "Activating ONED %d\n",n);
#endif
  v = add_view(ONED,n);

  /* get tk info about window */
  sprintf(buf, ".oneD%d.c", n);
  v->data.oned.clientData = get_ClientData(buf);
}

void
oned_size(int n)
{
#ifdef DEBUG
  fprintf(stdout, "Setting size for ONED %d\n",n);
#endif
}

/*
 * plots function in the oneD map window
 */
void
oned_function(void)
{
  int (*ds)();
  int nvars, nparams, nfuncs, pts, iters, first_point;
  double *vars, *params, *f, *temp, inc, oldx, oldy;
  Manifold manifold;
  char t[20];
  VIEW_ITEM *v;

  int n = *((int *) pm(GET, "View.Refresh_Num", NULL));
  pm(GET, "View.Refresh_Type", t, NULL);
  if (strcmp(t, "ONED") != 0) {
    fprintf(stdout, "oned_function: need to set view number and type.\n");
    return;
  }
  v = get_view(ONED, n);
  if (v == NULL) {
    fprintf(stdout, "oned_function: bad oned window number %d.\n", n);
    return;
  }

  /* allocate memory and load up values */
  get_n_all_types(&nvars, &nparams, &nfuncs);
  manifold.periodic_varb = ivector(0,nvars-1);
  manifold.period_start = dvector(0,nvars-1);
  manifold.period_end = dvector(0,nvars-1);
  manifold.type = *((int *) pm( GET, "Manifold.Type", NULL ));
  pm( GET_LIST, "Manifold.Periodic_Varb", 0, nvars-2, 
     manifold.periodic_varb, NULL);
  pm( GET_LIST, "Manifold.Period_Start", 0, nvars-2, 
     manifold.period_start, NULL);
  pm( GET_LIST, "Manifold.Period_End", 0, nvars-2, 
     manifold.period_end, NULL);
  vars = dvector(0, nvars-1);
  f = dvector(0, nvars-1);
  temp = dvector(0, nvars-1);
  params = dvector(0, nparams-1);
  pm(GET_LIST, "Selected.Varb_Ic", 0, nvars-1, vars, NULL);
  pm(GET_LIST, "Selected.Param_Ic", 0, nparams-1, params, NULL);
  iters = *((int *) pm(GET, "Flow.Skip_Size", NULL));
  ds = (int (*)()) pm(GET, "Model.DS_Def", NULL);

  vars[0] = v->data.oned.hormin;
  pts = v->data.oned.width;
  inc = (v->data.oned.hormax - vars[0]) / (pts-1);

  first_point = TRUE;
  while (pts >=0)
    {
      /* plot a point */
      iter_forw( ds, iters, f, vars, params, nvars, 1.0, 
		 temp, &manifold);
      if (!first_point) 
	oned_line(v, oldx, oldy, vars[0], f[0], SYS_GREEN);
      else first_point = FALSE;
      oldx = vars[0];
      oldy = f[0];
      pts--;
      vars[0] += inc;
    }

  /* free memory */
  free_dvector(vars, 0, nvars-1);
  free_dvector(f, 0, nvars-1);
  free_dvector(temp, 0, nvars-1);
  free_dvector(params, 0, nparams-1);
  free_dvector(manifold.period_end, 0, nvars-1);
  free_dvector(manifold.period_start, 0, nvars-1);
  free_ivector(manifold.periodic_varb, 0, nvars-1);
}

void
oned_line(VIEW_ITEM *v, double x1, double y1, double x2, double y2, int color)
{
  int px1, py1, px2, py2;

  px1 = (v->data.oned.width-1) * (x1 - v->data.oned.hormin) /
    (v->data.oned.hormax - v->data.oned.hormin);
  px2 = (v->data.oned.width-1) * (x2 - v->data.oned.hormin) /
    (v->data.oned.hormax - v->data.oned.hormin);
  py1 = (v->data.oned.height-1) * (v->data.oned.vermax - y1) /
    (v->data.oned.vermax - v->data.oned.vermin);
  py2 = (v->data.oned.height-1) * (v->data.oned.vermax - y2) /
    (v->data.oned.vermax - v->data.oned.vermin);

  /* add clipping here? */


  Tk_PlotLine((TkPlot *) (v->data.oned.clientData),
	      px1, py1, px2, py2, color);

}


/*
 * plots all the data in a specified memory object to the specified twod
 * window
 */
void
oned_mem(VIEW_ITEM *v, memory m)
{
  ONED_VIEW_ITEM *oned = &(v->data.oned);
  double new_y, old_x;
  int *color, color_id;
  double *points, *params;
  int pcolor, first, second;

  if (memory_reset_read(m)==0) {
    while (memory_read_next_flow(m, NULL, NULL, NULL, NULL, NULL) == 0) {
      while (memory_read_next_traj(m, NULL, NULL, NULL) == 0) {
	first = TRUE;
	while (memory_read_next_point(m, &points, NULL, &color,
				      NULL, NULL) == 0) {
	  new_y = points[0];
	  if (first == TRUE) {
	    /* color_id = get_color_index(oned->colormode, color[0], color[1]); */
	    color_id = 3;
	    old_x = new_y;
	    first = FALSE;
	    second = TRUE;
	  } else if (second == TRUE) {
	    oned_line(v, old_x, oned->vermin, old_x, new_y, color_id);
	    oned_line(v, old_x, new_y, new_y, new_y, color_id);
	    old_x = new_y;
	    second = FALSE;
	  } else {
	    oned_line(v, old_x, old_x, old_x, new_y, color_id);
	    oned_line(v, old_x, new_y, new_y, new_y, color_id);
	    old_x = new_y;
	  }
	}
      }
    }
  }
}



/*
 * plots all the data in all the memory objects to a specified oned window
 */
void
oned_all_mem(VIEW_ITEM *v)
{
  char *name;
  memory m;
  int i=0;

  while ( (name = (char *) pm(QUERY, "Memory", MEMRY, i, NULL)) )
    {
      i++;
      /* don't display the mult memory */
      if (strcmp(name, "Memory.Mult")) {
	m = (memory) pm(GET, name, NULL);
	oned_mem(v,m);
      }
    }
}




