/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * algorithms_local.h
 */

#ifndef _ALGORITHMS_LOCAL_h_
#define _ALGORITHMS_LOCAL_h_

#include <complib.h>

/* ab4.c */
int ab4( double* vx1, double* vx, double* param, double time_step,
         int dim, int (*f_p)(double*, double*, double*),
         double* workspace, History_Struct* history_list);


/* euler.c */
int euler_driver(double *out_state, double *in_state, double *dwork,
	     struct Prop_DataS *integ_cntl, int mode);
int euler(double *vx1, double *vx, double *param, double time_step,
      int dim,int (*f_p)(double *, double *, double *), double *workspace);
int euler_init(void);

/* rk4.c */
int rk4_driver(double *out_state, double *in_state, double *dwork, 
	   struct  Prop_DataS *integ_cntl, int mode);
int rk4(double *vx1, double *vx, double *param, double time_step,
    int dim, int (*f_p)(double *, double *, double *), double *workspace);
int rk4_init(void);


/* rk78.c */
int rk78_driver(double *out_state, double *in_state, double *dwork,
	    struct Prop_DataS *integ_cntl, int mode);
int rk78_init(void);

/* rkqc.c */
int rkqc_driver(double *out_state, double *in_state, double *dwork,
		struct Prop_DataS *integ_cntl, int mode);
int rkqc_init(void);

/* bs.c */
int bs_driver(double *out_state, double *in_state, double *dwork,
	      struct Prop_DataS *integ_cntl, int mode);
int bs_init(void);

#endif
/* !_ALGORITHMS_LOCAL_h_ */
