/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
                       
#include "globals.h"
#include "server.h"

/* static vars */
static gchar configfile[] = ".spruce/spruce.conf";

/* lets keep track of open windows... */
gboolean AboutOpen;
gboolean AccountsOpen;
gboolean AddrBookOpen;
gboolean ComposerOpen;
gboolean FiltersOpen;
gboolean OptionsOpen;

/* generic globals */
gchar *spruceconf;                       /* spruce config file */

gint NumMailboxes;                       /* number of mailboxes (Inbox, Outbox, etc) */
gint NumRemoteboxes;                     /* number of remote mailboxes */
gint NumSpoolboxes;                      /* number of local spools */

gchar *AddrSelected;                     /* addr selected by frmAddrBook */
gint first_time;
gint texticons;                          /* use text? icons? or both? */
GList *filters;                          /* Filter list */

/* Identity */
gchar *SenderAddr;                       /* user's email addr */
gchar *ReplyTo;                          /* user's Reply-To email addr */
gint use_rand_sig;                       /* use spruce's random signature? */
gint auto_attach_sig;                    /* auto-attach the signature? */
gchar *signaturefile;                    /* user's signature file */

/* Accounts */
gint NumAccounts;                        /* number of pop3 accounts we have */
accounts_t AccountsList[MAX_ACCOUNTS];
Server SmtpServer;                       /* smtp server */

gint use_rand_sig;                       /* attach a random signature? */
gint save_outgoing;                      /* save outgoing messages? */
gchar *signaturefile;                    /* user's signature file */
Server SmtpServer;                      /* smtp server */

gchar *AddrSelected;                     /* addr selected by frmAddrBook */
/* Appearance */
gchar *mesg_body_font;
gchar *unread_mesg_header_font;
gchar *read_mesg_header_font;

gint first_time;

gint texticons;                          /* use text? icons? or both? */

/* Misc */
gint save_outgoing;                      /* save outgoing messages? */
gint empty_on_exit;                      /* empty "Deleted items" on exit? */
gint cm_delay;                           /* check mail every XX minutes */
gint hdr_trim_level;                     /* 0 = none; 1 = partial; 2 = full */

GList *filters;

GList *mime_parts;
GList *mime_send_parts;

/*gint use_gnupg;
gint pgp_sign;
gchar *pgp_passphrase;*/
/* PGP */
gchar *pgp_identity;                     /* PGP Identity */
gint use_gnupg;                          /* do we use GNUpg or Pgp50i? */
gint pgp_sign;                           /* pgpv -s ? */
gint encrypt_to_self;                    /* always encrypt to self? */
gint store_passphrase;                   /* store our passphrase? */
gchar *pgp_passphrase;                   /* pgp passphrase */

gint save_sizes;

/* here are our window widgets... */
GtkWidget *frmAbout;
GtkWidget *frmAccounts;
GtkWidget *frmAddrBook;
GtkWidget *frmComposer;
GtkWidget *frmFilters;
GtkWidget *frmMain;
GtkWidget *frmOptions;
GtkWidget *frmStatus;


char *get_config_path()
{
   gchar *home_dir;
   gchar *buffer;

   home_dir = getenv("HOME");

   if (home_dir == NULL)
      return NULL;

   buffer = g_malloc0(strlen(home_dir) + 1 + strlen(configfile) + 1);
   sprintf(buffer, "%s/%s", home_dir, configfile);

   return buffer;	
}

void reset_globals()
{
   AboutOpen      = FALSE;
   AccountsOpen   = FALSE;
   AddrBookOpen   = FALSE;
   ComposerOpen   = FALSE;
   FiltersOpen    = FALSE;
   OptionsOpen    = FALSE;

   NumMailboxes = 0;
   NumRemoteboxes = 0;
   NumSpoolboxes = 0;
   NumAccounts = 0;

   use_rand_sig = TRUE;
   auto_attach_sig = TRUE;
   save_outgoing = TRUE;
   
   SmtpServer.port = 25;   

   spruceconf = get_config_path();

   first_time = 0;

   texticons = TB_ICONS;

   hdr_trim_level = 1;

   empty_on_exit = TRUE;

   cm_delay = 0;

   ReplyTo = NULL;

   filters = NULL;

   mailpos = NULL;

   use_gnupg = TRUE;
   pgp_sign = FALSE;
   encrypt_to_self = TRUE;
   store_passphrase = FALSE;
   pgp_passphrase = NULL;

   mime_parts = NULL;
   mime_send_parts = NULL;
   mesg_body_font = NULL;

   unread_mesg_header_font = NULL;
   read_mesg_header_font = NULL;
}

void first_run()
{
   gchar *path = NULL;
   gchar buffer[512];
   
   first_time = 1;

   NumMailboxes = 0;

   if((path = getenv("HOME")) == NULL)
   {
      if((path = getenv("USER")) == NULL)
      {
        fprintf(stderr, _("Sorry! Cannot determine where to create the spruce directory!\n"));
        return;	/* What else to do? */
      }
      else 
      {
        g_snprintf(buffer, 512, "/home/%s/.spruce", path);
      }
   }
   else
   {
      g_snprintf(buffer, 512, "%s/.spruce", path);
   }
   
   mkdir(buffer, 0700);	/* lets make this dir only readable my the owner! -Chuck */
   mailbox_create("Inbox");
   mailbox_create("Drafts");
   mailbox_create("Outbox");
   mailbox_create("Sent items");
   mailbox_create("Deleted items");
}

void global_free()
{
   g_free(spruceconf);
   g_free(SenderAddr);
   g_free(ReplyTo);
   g_free(signaturefile);
   g_free(AddrSelected);
   g_free(mailpos);
   g_free(pgp_identity);
   g_free(pgp_passphrase);
   g_free(mesg_body_font);
   g_free(unread_mesg_header_font);
   g_free(read_mesg_header_font);
}

