/*  Spruce
 *  Copyright (C) 1999 Susixware
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __ACCOUNTS_H__
#define __ACCOUNTS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#undef MIN
#undef MAX
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gtkmanip.h"
#include "globals.h"
#include "server.h"
#include "accounts_t.h"
#include "options.h"
#include "parse.h"
#include "rc.h"
#include "imap.h"

/* from main.h */
void refresh_mailboxes (gint hilight);

GtkWidget* create_frmAccounts (gint readAccounts);

void on_frmAccounts_destroy (GtkObject *object, gpointer user_data);

void on_frmAccounts_show (GtkWidget *widget, gpointer user_data);

void on_cmdAccountsAppend_clicked (GtkButton *button, gpointer user_data);

void on_cmdAccountsDelete_clicked (GtkButton *button, gpointer user_data);

void on_cmdAccountsOK_clicked (GtkButton *button, gpointer user_data);

void on_cmdAccountsCancel_clicked (GtkButton *button, gpointer user_data);

void on_cmdAccountsModify_clicked (GtkButton *button, gpointer user_data);

void on_clistAccounts_select_row (GtkCList *clist, gint row, gint column,
                                  GdkEvent *event, gpointer user_data);

void on_chkAccountsDeleMail_toggled (GtkToggleButton *togglebutton, gpointer user_data);

void on_servertype_activate (GtkWidget *entry, gpointer user_data);

void null_accounts(void);

gint read_accounts(void);

void refresh_clistAccounts(gboolean reread);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
