
/*  A Bison parser, made from unctime.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUM	257
#define	MONTH	258
#define	AM	259
#define	PM	260

#line 70 "unctime.y"

#include "deliver.h"
#include <ctype.h>

#ifdef HAS_TIMEZONE
# define USE_TIMEZONE
#else
# ifdef HAS_GETTOD
#  define USE_GETTOD
# else
#  define USE_FTIME
# endif
#endif

#ifdef USE_GETTOD
# include <sys/time.h>
#else
# include <time.h>
# ifdef USE_FTIME
#  include <sys/timeb.h>
# endif
#endif

/* Delta is correction, in minutes, to turn specified time into GMT. */
/* if (zoneflag), a timezone was explicitly specified. */
static year, month, day, hour, minute, second, delta;
static zoneflag, errorflag, iflag;
static long iresult;

#define YYSTYPE long
#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		34
#define	YYFLAG		-32768
#define	YYNTBASE	11

#define YYTRANSLATE(x) ((unsigned)(x) <= 260 ? yytranslate[x] : 16)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     7,     2,     2,     2,     2,     2,
     2,     2,     2,     9,     2,     2,     8,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    10,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     4,     8,    12,    15,    18,    21,    23,    25,    28,
    31,    34,    38,    41,    44,    46,    49,    52,    54,    60
};

static const short yyrhs[] = {    12,
    14,    13,     0,    12,    13,    14,     0,    14,    12,    13,
     0,    14,    12,     0,    12,    14,     0,    12,    13,     0,
    12,     0,    14,     0,     7,     3,     0,     3,     4,     0,
     4,     3,     0,     3,     8,     3,     0,     9,     3,     0,
     8,     3,     0,     3,     0,    15,     5,     0,    15,     6,
     0,    15,     0,     3,    10,     3,    10,     3,     0,     3,
    10,     3,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   106,   108,   109,   110,   111,   112,   113,   114,   115,   118,
   120,   121,   124,   126,   127,   130,   132,   133,   136,   138
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUM","MONTH",
"AM","PM","'#'","'/'","','","':'","date","day","year","time","clock", NULL
};
#endif

static const short yyr1[] = {     0,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    12,
    12,    12,    13,    13,    13,    14,    14,    14,    15,    15
};

static const short yyr2[] = {     0,
     3,     3,     3,     2,     2,     2,     1,     1,     2,     2,
     2,     3,     2,     2,     1,     2,     2,     1,     5,     3
};

static const short yydefact[] = {     0,
     0,     0,     0,     7,     8,    18,    10,     0,     0,    11,
     9,    15,     0,     0,     6,     5,     0,     4,    16,    17,
    12,    20,    14,    13,     0,     2,    15,     1,     3,     0,
    19,     0,     0,     0
};

static const short yydefgoto[] = {    32,
     4,    15,     5,     6
};

static const short yypact[] = {    10,
    -3,     1,     9,     0,    18,    19,-32768,    16,    20,-32768,
-32768,    17,    23,    25,    26,     7,    -2,     7,-32768,-32768,
-32768,    21,-32768,-32768,    17,-32768,-32768,-32768,-32768,    27,
-32768,    32,    33,-32768
};

static const short yypgoto[] = {-32768,
    29,     2,    -4,-32768
};


#define	YYLAST		34


static const short yytable[] = {    16,
     7,     7,    12,    10,     8,     8,     9,    13,    14,    27,
    26,    11,     1,     2,    13,    14,     3,    28,    21,    29,
    17,     2,    22,    19,    20,    23,     9,    24,    25,    31,
    30,    33,    34,    18
};

static const short yycheck[] = {     4,
     4,     4,     3,     3,     8,     8,    10,     8,     9,     3,
    15,     3,     3,     4,     8,     9,     7,    16,     3,    18,
     3,     4,     3,     5,     6,     3,    10,     3,     3,     3,
    10,     0,     0,     5
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 9:
#line 115 "unctime.y"
{ iflag = TRUE; iresult = yyvsp[0]; ;
    break;}
case 10:
#line 119 "unctime.y"
{ month = yyvsp[0]; day = yyvsp[-1]; ;
    break;}
case 11:
#line 120 "unctime.y"
{ month = yyvsp[-1]; day = yyvsp[0]; ;
    break;}
case 12:
#line 121 "unctime.y"
{ month = yyvsp[-2]; day = yyvsp[0]; ;
    break;}
case 13:
#line 125 "unctime.y"
{ year = yyvsp[0]; ;
    break;}
case 14:
#line 126 "unctime.y"
{ year = yyvsp[0]; ;
    break;}
case 15:
#line 127 "unctime.y"
{ year = yyvsp[0]; ;
    break;}
case 16:
#line 131 "unctime.y"
{ hour %= 12; ;
    break;}
case 17:
#line 132 "unctime.y"
{ hour = hour % 12 + 12; ;
    break;}
case 19:
#line 137 "unctime.y"
{ hour = yyvsp[-4]; minute = yyvsp[-2]; second = yyvsp[0]; ;
    break;}
case 20:
#line 138 "unctime.y"
{ hour = yyvsp[-2]; minute = yyvsp[0]; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 141 "unctime.y"


/* Return 0 if s is the same word as t.
   Return 1 if s is a prefix of t; e.g. prefix("mar", "march") returns 1.
   Return -1 if s is not a prefix of t.
   Note that comparison is case-insensitive. */

static int
wordeq(s, t)
char *s, *t;
{
    while (*s && *t)
    {
	int i, j;

	i = *s++ & 0xFF;
	j = *t++ & 0xFF;
	if (isupper(i))
	    i = tolower(i);
	if (isupper(j))
	    j = tolower(j);
	if (i != j)
	    return -1;
    }

    if (*s)
	return -1;
    return (*t == 0);
}

static char *lexptr;

static void
initlex(s)
char *s;
{
    lexptr = s;
}

static char *months[] =
{
    "jan", "feb", "mar", "apr", "may", "jun",
    "jul", "aug", "sep", "oct", "nov", "dec",
    0
};

struct zonename
{
    char *name;			/* Name of the time zone. */
    int delta;			/* Correction, in minutes, to add to GMT */
};

static struct zonename zones[] =
{
    { "gmt",       0 },
    { "ut",        0 },
    { "est", -5 * 60 },		/* North American time zones */
    { "edt", -6 * 60 },
    { "cst", -6 * 60 },
    { "cdt", -7 * 60 },
    { "mst", -7 * 60 },
    { "mdt", -8 * 60 },
    { "pst", -8 * 60 },
    { "pdt", -9 * 60 },
    { "z",         0 },			/* Military time zones */
    { "a",   -1 * 60 },
    { "b",   -2 * 60 },
    { "c",   -3 * 60 },
    { "d",   -4 * 60 },
    { "e",   -5 * 60 },
    { "f",   -6 * 60 },
    { "g",   -7 * 60 },
    { "h",   -8 * 60 },
    { "i",   -9 * 60 },
    { "k",  -10 * 60 },
    { "l",  -11 * 60 },
    { "m",  -12 * 60 },
    { "n",    1 * 60 },
    { "o",    2 * 60 },
    { "p",    3 * 60 },
    { "q",    4 * 60 },
    { "r",    5 * 60 },
    { "s",    6 * 60 },
    { "t",    7 * 60 },
    { "u",    8 * 60 },
    { "v",    9 * 60 },
    { "w",   10 * 60 },
    { "x",   11 * 60 },
    { "y",   12 * 60 },
    { NULL, 0 }
};

/* Lexical analyzer.  Gather alphabetics into tokens; if they are unknown
   strings ignore them, and if they are months return the appropriate value.
   If the token is the name of the time zone set delta = correction and
   zoneflag = TRUE, and skip ahead to the next token (the parser itself
   never sees time zones).
   If the token is a number, return its value.
   If it is a punctuation mark, return the character code.
   Ignore white space.  */

int
yylex()
{
    register i;
    char token[40];		/* Probably paranoid. */

    for (;;)
    {
	while (isspace(*lexptr & 0xFF))
	    lexptr++;
	if (*lexptr == 0)
	    return 0;
	else if (isalpha(*lexptr & 0xFF))
	{
	    i = 0;
	    for (; isalpha(*lexptr & 0xFF); lexptr++)
	    {
		if (i < sizeof(token) - 1)
		    token[i++] = *lexptr;
	    }
	    token[i] = '\0';
	    for (i = 0; months[i]; i++)
	    {
		if (wordeq(months[i], token) >= 0)
		{
		    yylval = i + 1;
		    return MONTH;
		}
	    }
	    for (i = 0; zones[i].name; i++)
	    {
		if (wordeq(zones[i].name, token) == 0)
		{
		    int oper, next;

		    zoneflag = TRUE;
		    delta = zones[i].delta;
		    oper = yylex();
		    /* Syntax: "4 CST + 23[:10]" adds 23 minutes and
		    optionally 10 seconds to delta (the correction). */
		    if (oper == '+' || oper == '-')
		    {
			(void) yylex();
			delta += (oper == '+' ? 60 : -60) * yylval;
			next = yylex();
			if (next == ':')
			{
			    (void) yylex();
			    delta += (oper == '+' ? 1 : -1) * yylval;
			}
			else
			    return next;
		    }
		    else
			return oper;
		}
	    }
	    if (wordeq("pm", token) == 0 || wordeq("p.m.", token) == 0)
		return PM;
	    if (wordeq("am", token) == 0 || wordeq("a.m.", token) == 0)
		return AM;
	    continue;
	}
	else if (isdigit(*lexptr & 0xFF))
	{
	    i = 0;
	    for (; isdigit(*lexptr & 0xFF); lexptr++)
	    {
		if (i < sizeof(token) - 1)
		    token[i++] = *lexptr;
	    }
	    token[i] = '\0';
	    yylval = atoi(token);
	    return NUM;
	}
	else
	    return *lexptr++;
    }
}

/* ARGSUSED */
int
yyerror(s)
char *s;
{
    errorflag = TRUE;
    return 0;
}

/* Is y a leap year? */
#define leap(y) (((y) % 4 == 0 && (y) % 100 != 0) || (y) % 400 == 0)

/* Number of leap years from 1970 to y (not including y itself) */
#define nleap(y) (((y) - 1969) / 4 - ((y) - 1901) / 100 + ((y) - 1601) / 400)

/* This macro returns the "day" number of the sunday immediately
   preceding or equal to the argument in the current year. */
#define FIRST_SUNDAY 3
#define dayofepoch(day) ((day) + (year - 1970) * 365 + nleap(year))
#define sunday(day)  ((day) - (dayofepoch(day) + 7 - FIRST_SUNDAY) % 7)

/* correction()
   returns the daylight savings correction, in seconds, to ADD to GMT
   to get correct local time.

   Since we are converting local back to GMT, we SUBTRACT this later on
   (local = gmt + correction(); gmt = local - correction()).

   While we're at it, we also add the longitude correction for minutes
   west of Greenwich.  To do this, we have all these fascinating tables
   here . . .  */

#ifdef USE_GETTOD

struct dstinfo
{
    int year;			/* This year, or default if zero. */
    int start;			/* DST begins sunday before this day. */
    int end;			/* DST ends sunday before this day. */
};

/* USA. */
static struct dstinfo usa_dst[] =
{
    1974, 5, 333,
    1975, 58, 303,
    0, 119, 303
};

/* Australia. */
static struct dstinfo aus_dst[] =
{
    1970, 999, 0,
    1971, 303, 0,
    1972, 303, 58,
    0, 303, 65
};

/* Western Europe. */
static struct dstinfo weur_dst[] =
{
    1983, 89, 296,
    0, 89, 303
};

/* Middle Europe (also used for Eastern Europe, for lack of better
   information). */
static struct dstinfo meur_dst[] =
{
    1983, 89, 296,
    0, 89, 272
};

/* Canada is same as US, except no early 70's insanity. */
#ifdef DST_CAN
static struct dstinfo can_dst[] =
{
    0, 119, 303
};
#endif

struct dst_rules
{
    int magic;			/* Gettimeofday magic number for rule type */
    struct dstinfo *entry;	/* Pointer to struct dstinfo array. */
    int correction;		/* Correction in minutes to GMT. */
};

static struct dst_rules dstrules[] =
{
    DST_USA, usa_dst, 60,
    DST_AUST, aus_dst, -60,	/* Southern hemisphere */
    DST_WET, weur_dst, 60,
    DST_MET, meur_dst, 60,
    DST_EET, meur_dst, 60,
#ifdef DST_CAN
    DST_CAN, can_dst, 60,
#endif
    -1, 0, 0
};

static long
correction(day, tz)
int day;			/* Day number in current year.  */
struct timezone *tz;
{
    int i, correc = 0;
    struct dstinfo *dst;

    /* Did the user specify in the input string a timezone correction? */
    if (zoneflag)
	return (long)delta * 60;

    /* Since no correction was explicitly specified, we use local time zone and
       DST, as returned by gettimeofday() earlier . . . */
    if (tz->tz_dsttime)
    {
	for (i = 0; dstrules[i].magic != -1; i++)
	{
	    if (dstrules[i].magic == tz->tz_dsttime)
	    {
		dst = dstrules[i].entry;
		while (dst->year != year && dst->year)
		    dst++;
		if (sunday(dst->start) <= day && day <= sunday(dst->end)
		/* For some reason, DST starts/ends at 2 am sunday mornings. */
		    && !(day == sunday(dst->start) && hour < 2)
		    && !(day == sunday(dst->end) && hour >= 2))
		    correc = dstrules[i].correction;
		break;
	    }
	}
    }
    correc -= tz->tz_minuteswest;
    return (long)correc * 60;
}

#else /* not USE_GETTOD */

static long
correction()
{
    /* Did the input string specify a timezone correction? */
    if (zoneflag)
	return (long)delta * 60;

    /* No.  Use local time zone. */

#ifdef USE_TIMEZONE
    {
	extern long timezone;
	return -timezone;
    }
#endif

#ifdef USE_FTIME
    {
	struct timeb tb;
	(void) ftime(&tb);
	return (long)tb.timezone * -60;
    }
#endif
}

#endif /* not USE_GETTOD */

static short monthlens[] =
{
    31,				/* January */
    28,				/* February */
    31,				/* March */
    30,				/* April */
    31,				/* May */
    30,				/* June */
    31,				/* July */
    31,				/* August */
    30,				/* September */
    31,				/* October */
    30,				/* November */
    31				/* December */
};

time_t
unctime(s)
char *s;
{
#ifdef USE_GETTOD
    struct timeval tv;
    struct timezone tz;
#else
    time_t now;
#endif
    struct tm *tm;
    int dayofyear;

#ifdef USE_GETTOD
    (void) gettimeofday(&tv, &tz);
    /* The cast is required to shut lint up.  Berkeley goes to all the effort
       to define time_t, why don't they use it? */
    tm = localtime((time_t *) & tv.tv_sec);
#else
    (void) time(&now);
    tm = localtime(&now);
#endif
    year = tm->tm_year;
    month = tm->tm_mon + 1;
    day = tm->tm_mday;
    hour = tm->tm_hour;
    minute = tm->tm_min;
    second = tm->tm_sec;
    zoneflag = FALSE;
    errorflag = FALSE;

    initlex(s);
    (void) yyparse();

    if (errorflag)
	return -1;

    /* If garbage beyond valid date, that's an error. */
    while (isspace(*lexptr & 0xFF))
	++lexptr;
    if (*lexptr)
	return -1;

    /* User forced the exact time in seconds GMT, no further work necessary. */
    if (iflag)
	return iresult;

    /* Try to keep the year reasonable (i.e., within the domain of ctime()). */
    if (year < 1970)
	year += 1900;
    if (year < 1970)
	year += 100;

    /* Check for preposterous months/days/times. */
    if (month < 1 || month > 12 || day < 1
	|| (day > monthlens[month - 1]
	    && !(month == 2 && day == 29 && leap(year)))
	|| hour > 23 || minute > 59 || second > 59)
    {
	return -1;
    }

    /* Mostly for convenience in sunday() macro, we use zero-origin days. */
    dayofyear = day - 1;
    if (month > 2 && leap(year))
	++dayofyear;
    while (--month > 0)
	dayofyear += monthlens[month - 1];

    /* Wow! */
    return 86400L * (long)(dayofyear + 365 * (long)(year - 1970) + nleap(year))
	+ 3600 * (long)hour
	+ 60 * (long)minute
	+ second
#ifdef USE_GETTOD
	- correction(dayofyear, &tz)
#else
	- correction()
#endif
	;
}
