/*
** Copyright 1998 - 1999 Double Precision, Inc.  See COPYING for
** distribution information.
*/

#if	HAVE_CONFIG_H
#include	"config.h"
#endif
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<errno.h>
#include	<pwd.h>
#if	HAVE_UNISTD_H
#include	<unistd.h>
#endif

#include	"auth.h"
#include	"authmod.h"
#include	"authmysql.h"


static const char rcsid[]="$Id: preauthmysql.c,v 1.4 2000/03/08 13:11:25 mrsam Exp $";


static auth_mysql_config *config_data=0;


int	auth_mysql_pre(const char *user, const char *service,
		int (*callback)(struct authinfo *, void *), void *arg)
{
auth_mysql_user *user_data;
struct authinfo auth;
int	rc;

        /* Init */
	if (!config_data)
	{
		if( (config_data = auth_mysql_init()) == NULL) {
			return (1);
		}

		if (auth_mysql_connect(config_data))
		{
			return (1);
		}
	    
		mysql_select_db(&auth_mysql_server, config_data->database);

		if(mysql_errno(&auth_mysql_server) != 0) {
#if AUTHMYSQL_DEBUG
                        syslog(LOG_ERR,"Error during MySQL selectdb(): %s",mysql_error(&auth_mysql_server));
#endif
			return (1);
		}
	}

	/* Get the user from mysql */
        if( (user_data = auth_mysql_getuser((char *)user, config_data)) == NULL)
	{
		if (mysql_errno(&auth_mysql_server) == CR_SERVER_GONE_ERROR
			|| mysql_errno(&auth_mysql_server) == CR_SERVER_LOST)
		{
#if AUTHMYSQL_DEBUG
			syslog(LOG_ERR,"MySQL server gone. reconnecting");
#endif
			(void)auth_mysql_connect(config_data);
			return (1);
		}
		return (-1);
	}
	
	memset(&auth, 0, sizeof(auth));
	auth.sysuserid= &user_data->uid;
	auth.sysgroupid= &user_data->gid;
	auth.homedir=user_data->mailbox;
	auth.address=user;
	auth.passwd=user_data->crypt;

	rc=(*callback)(&auth, arg);
	free(user_data);
	return (rc);
}


/*
 * Closes the pervious opened connection and clear config_data
*/
void auth_mysql_cleanup()
{
	if (config_data)
	{
		auth_mysql_disconnect(config_data);
		free(config_data);
		config_data=0;
	}
}
