/*
 * xgetopt.c v1.0 fifi@veeble.uucp
 */
 
#include	<stdio.h>
#include	<ctype.h>
#ifdef __GNUC__
# ifdef __STDC__
#  if defined(__NeXT__) || defined(__linux__) || defined(__svr4__)
#   include	<varargs.h>
#  else
#   include	<stdargs.h>
#  endif
#  if !defined(va_list) && !defined(__NeXT__)
#   define va_list _G_va_list
#  endif
# else
#  include	"/usr/local/lib/gcc-include/varargs.h"
# endif
#else
# include	<varargs.h>
#endif

char	*xoptarg = NULL;
int	xoptind = 0;
char	*xoptpnt = NULL;
char	xoptflag = '\0';
char	*xoptnull = "\0";

int
xgetopt(argc, argv, descr)
register int	argc;
register char	**argv;
register char	*descr;
{
	/*
	 * verarbeitung wie 'getopt', jedoch werden auch angaben
	 * like '+abc' akzeptiert. werden flags mit + uebergeben,
	 * so erscheint das flag im return als capital letter,
	 * bei '-' als small letter.
	 */
	char	arg;

	while(xoptind < argc) {
		/* pruefen, ob evtl in einer argumentkette */
		if (!xoptpnt || !*xoptpnt) xoptflag = '\0';
		if (xoptflag) {
			/* ok... wir durchsuchen die +/- - liste */
			arg = *xoptpnt++;
		} else {
			/* keine liste, naechsten index waehlen */
			xoptarg = xoptpnt = argv[++xoptind];
			if (xoptpnt && ((*xoptpnt == '+') || (*xoptpnt == '-'))) {
				xoptflag = *xoptpnt++;
				if (!(arg = *xoptpnt++)) {
					/* kein argument: +/- ist das argument */
					xoptpnt = NULL;
					arg = xoptflag;
					xoptflag = 0;
				}
			} else {
				/* kein argument mehr da oder NULL-pointer oder kein +/- */
				return(EOF);
			}
		}
		while (descr && *descr && (*descr != arg)) descr++;
		if (!descr || !*descr) {
			/* argument nicht in der arglist */
			return('?');
		} else {
			/* argument erwartet ? */
			if (*(descr+1) == ':') {
				/* direkt dahinter ? */
				if (xoptpnt && *xoptpnt) {
					xoptarg = xoptpnt;
				} else {
					/* ansonsten... weiteres argument vorhanden? */
					if ((xoptind+1) < argc) {
						xoptarg = argv[(xoptind+1)];
						if ((*xoptarg != '+') && (*xoptarg != '-')) {
							/* ok... */
							xoptind++;
						} else {
							xoptarg = xoptnull;
						}
					} else {
						xoptarg = xoptnull;
					}
				}
				xoptpnt = NULL;
			}
			/* kein argument erwartet...  oder argument in xoptarg */
			if (xoptflag == '+') {
				return(arg+256);
			} else {
				return(arg);
			}
		}
	}
	return(EOF);
}

#ifndef __svr4__ /* { */
int
/* VARARGS */
xgetoptstrg(argc, argv, va_alist)
register int	argc;
register char	**argv;
va_dcl
{
	/*
	 * aufruf: xgetoptstrg(argc, argv, "optstrg:idchar[:]" ..., null)
	 */
	va_list	va;
	static char descr[30];
	register char *xoptcp;
	register int i=0;

	while(xoptind < argc) {
		/* keine liste moeglich , naechsten index waehlen */
		xoptarg = xoptpnt = argv[++xoptind];
		if (xoptpnt && ((*xoptpnt == '+') || (*xoptpnt == '-'))) {
			xoptflag = *xoptpnt++;
			if (!(*xoptpnt)) {
				/* kein argument: +/- ist das argument */
				xoptpnt--;
				xoptflag = 0;
			}
		} else {
			/* kein argument mehr da oder NULL-pointer oder kein +/- */
			/* if (!xoptpnt) */
				return(EOF);
			/* xoptflag = 0; */
		}
		/* soll-argumente durchsuchen */
		va_start(va);
		while(xoptcp = va_arg(va, char *)) {
			xoptcp = (char *)strcpy(descr,xoptcp);
			while(*xoptcp && (*xoptcp != ':')) xoptcp++;
			if ((i = strlen(xoptcp)) < 2) {
				va_end(va);
				/* fehler */
				return(EOF);
			}
			*xoptcp++ = '\0';
			if (*xoptcp == ':') {
				xoptcp++;
				/* argument darf nicht folgen */
				if (!strcmp(descr,xoptpnt)) {
					xoptpnt = NULL;
					break;
				}
			} else {
				/* argument darf folgen */
				if (!strncmp(descr,xoptpnt,strlen(descr))) {
					xoptpnt += strlen(descr);
					break;
				}
			}
		}
		va_end(va);
		if (!xoptcp) {
			/* argument nicht in der arglist */
			return('?');
		} else {
			/* argument erwartet ? */
			if (i > 2) {
				/* direkt dahinter ? */
				if (xoptpnt && *xoptpnt) {
					xoptarg = xoptpnt;
				} else {
					/* ansonsten... weiteres argument vorhanden? */
					if ((xoptind+1) < argc) {
						xoptarg = argv[(xoptind+1)];
						if ((*xoptarg != '+') && (*xoptarg != '-')) {
							/* ok... */
							xoptind++;
						} else {
							xoptarg = xoptnull;
						}
					} else {
						xoptarg = xoptnull;
					}
				}
				xoptpnt = NULL;
			}
			/* kein argument erwartet...  oder argument in xoptarg */
			if (xoptflag == '+') {
				return(*xoptcp+256);
			} else {
				return(*xoptcp);
			}
		}
	}
	return(EOF);
}
#endif /* } __svr4__ */
