/* (c) 1994 by Axel Zinser (fifi@hiss.han.de) */
#include	<stdio.h>
#include	"depress.h"

FILE *
depress(fp)
FILE	*fp;
{
#ifndef TEMP
# define TEMP	"/tmp"
#endif

	FILE	*pp;
	int	c;
	char	*uncomp;
	static char fname[256];
#define	DPBFLEN	1024
	static char dpbbuf[DPBFLEN];

	switch(c = fgetc(fp)) {
	case 0x1f:
		/* freeze, compress, gzip */
		c = fgetc(fp);
		switch(c) {
# ifdef GUNZIP
		case 0x8b:
			/* gzip */
			uncomp = GUNZIP;
			break;
# endif
# ifdef MELT
		case 0x9f:
			/* freeze */
			uncomp = MELT;
			break;
# endif
# ifdef UNCOMP
		case 0x9d:
			/* compress */
			uncomp = UNCOMP;
			break;
# endif
		default:
			return(0);
			break;
		}
		sprintf(fname,"%s/%%%d",TEMP,getpid());
		sprintf(dpbbuf,"%s > %s",uncomp,fname);
		if (!(pp = popen(dpbbuf,"w"))) {
			return(0);
		}
		/* fprintf(stderr,"popen(%s,r)\n",dpbbuf); */
		fputc(0x1f,pp);
		fputc(c,pp);
		while(c = fread(dpbbuf,1,DPBFLEN,fp)) fwrite(dpbbuf,1,c,pp);
		pclose(pp);
		fclose(fp);
		if (fp = fopen(fname,"r")) unlink(fname);
		return(fp);
		break;
	case 0x1a:
		/* arc */
		return(0);
		break;
	default:
		ungetc(c,fp);
		return(fp);
	}
}
