/*
                     Restart Configuration File

	Functions:

	int RCLoadFromFile(char *filename)
	int RCSaveToFile(char *filename)

	---

 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>

#include "../include/cfgfmt.h"
#include "../include/string.h"
#include "../include/strexp.h"
#include "../include/fio.h"

#include "yiffconfig.h"



#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define MAX(a,b)	(((a) > (b)) ? (a) : (b))



/*
 *	Anti shift routine:
 */
int antishift(int in)
{
        int s;
        int i = in;

        for(s = 0; i; i >>= 1)
            s++;

        return(s);
}


int RCLoadFromFile(char *filename)
{
	gint status;
        gchar *strptr, *strptr2;

        FILE *fp;
        off_t filesize;
        struct stat stat_buf;

        gchar parm[CFG_PARAMETER_MAX];
        gchar val[CFG_VALUE_MAX];
        gint lines_read = 0;

	gint mode_num;
	audio_mode_struct *mode_ptr;
	yc_win_struct *ycw;
	GtkWidget *w;
	GtkCList *clist;
	gchar *list_item_text[1];
	gchar text[256];


	ycw = &yc_win;


	/* Check if filename exists. */
	if(filename == NULL)
	    return(-1);
	if(stat(filename, &stat_buf))
	    return(-1);

	/* Get size of file. */
        filesize = stat_buf.st_size;

        /* Open filename. */
        fp = fopen(filename, "r");
        if(fp == NULL)
            return(-1);


	/* ******************************************************** */
	/* Free any allocated resources as needed. */

	YCDeleteAllAudioModes(ycw);
	YCDeleteAllSoundPaths(ycw);


	/* ******************************************************** */

	strptr = NULL;

        while(1)
        {
	    /* Free previous line and allocate/read next line. */
            free(strptr); strptr = NULL;
            strptr = FReadNextLineAlloc(fp, UNIXCFG_COMMENT_CHAR);
            if(strptr == NULL) break;
            lines_read++;

            /* Fetch parameter. */
            strptr2 = StringCfgParseParm(strptr);
            if(strptr2 == NULL) continue;
            strncpy(parm, strptr2, CFG_PARAMETER_MAX);
            parm[CFG_PARAMETER_MAX - 1] = '\0';

            /* Fetch value. */
            strptr2 = StringCfgParseValue(strptr);
            if(strptr2 == NULL) strptr2 = "0";  /* Set it to "0" if NULL. */
            strncpy(val, strptr2, CFG_VALUE_MAX);
            val[CFG_VALUE_MAX - 1] = '\0';


	    /* VersionMajor */
            if(!strcasecmp(parm, "VersionMajor"))
            {

	    }
            /* VersionMinor */
            else if(!strcasecmp(parm, "VersionMinor"))
            {

            }

	    /* Port */
            else if(!strcasecmp(parm, "Port"))
            {
		option.port = atoi(val);

                w = ycw->port_num_text;
                sprintf(text, "%i", option.port);
                gtk_entry_set_text(GTK_ENTRY(w), text);
	    }
	    /* RefreshInterval */
            else if(!strcasecmp(parm, "RefreshInterval"))
            {
		option.refresh_int_us = atol(val);
		if(option.refresh_int_us < 100)
		    option.refresh_int_us = 100;

                w = ycw->refresh_interval_text;
                sprintf(text, "%ld", option.refresh_int_us);
                gtk_entry_set_text(GTK_ENTRY(w), text);
            }
	    /* DSPDevice */
	    else if(!strcasecmp(parm, "DSPDevice") ||
                    !strcasecmp(parm, "Device")
	    )
	    {
		strncpy(
		    option.device,
		    val,
		    PATH_MAX + NAME_MAX
		);
		option.device[PATH_MAX + NAME_MAX - 1] = '\0';

                w = ycw->device_name_text;
                gtk_entry_set_text(GTK_ENTRY(w), option.device);
	    }
            /* MixerDevice */
            else if(!strcasecmp(parm, "MixerDevice") ||
                    !strcasecmp(parm, "Mixer")
	    )
            {
                strncpy(
                    option.mixer,
                    val,
                    PATH_MAX + NAME_MAX
                );
		option.mixer[PATH_MAX + NAME_MAX - 1] = '\0';

                w = ycw->mixer_name_text;
                gtk_entry_set_text(GTK_ENTRY(w), option.mixer);
            }
	    /* MIDIPlayCommand */
            else if(!strcasecmp(parm, "MIDIPlayCommand"))
	    {
		strncpy(
		    option.midi_play_cmd,
		    val,
		    PATH_MAX + NAME_MAX
		);
		option.midi_play_cmd[PATH_MAX + NAME_MAX - 1] = '\0';

                w = ycw->midi_play_cmd_text;
                gtk_entry_set_text(GTK_ENTRY(w), option.midi_play_cmd);
	    }

            /* **************************************************** */
	    /* BeginAudioMode */
            else if(!strcasecmp(parm, "BeginAudioMode") ||
                    !strcasecmp(parm, "BeginYMode") ||
                    !strcasecmp(parm, "BeginMode")
	    )
            {
		/* Allocate a new Audio mode. */
		if(ycw->total_audio_modes < 0)
		    ycw->total_audio_modes = 0;

		mode_num = ycw->total_audio_modes;

		ycw->total_audio_modes++;
		ycw->audio_mode = (audio_mode_struct **)realloc(
		    ycw->audio_mode,
		    ycw->total_audio_modes * sizeof(audio_mode_struct *)
		);
		if(ycw->audio_mode == NULL)
		{
		    ycw->total_audio_modes = 0;
	            continue;
		}

		ycw->audio_mode[mode_num] = (audio_mode_struct *)calloc(
                    1,
		    sizeof(audio_mode_struct)    
		);
		mode_ptr = ycw->audio_mode[mode_num];
		if(mode_ptr == NULL)
		    continue;


                while(1)
                {
                    /* Free previous line and allocate/read next line. */
                    free(strptr); strptr = NULL;
                    strptr = FReadNextLineAlloc(fp, UNIXCFG_COMMENT_CHAR);
                    if(strptr == NULL) break;
                    lines_read++;
                    
                    /* Fetch parameter. */
                    strptr2 = StringCfgParseParm(strptr);
                    if(strptr2 == NULL) continue;
                    strncpy(parm, strptr2, CFG_PARAMETER_MAX);
                    parm[CFG_PARAMETER_MAX - 1] = '\0';
                        
                    /* Fetch value. */
                    strptr2 = StringCfgParseValue(strptr);  
                    if(strptr2 == NULL) strptr2 = "0";
                    strncpy(val, strptr2, CFG_VALUE_MAX);
                    val[CFG_VALUE_MAX - 1] = '\0';


                    /* Name */
                    if(!strcasecmp(parm, "Name"))
                    {
			clist = GTK_CLIST(ycw->audio_modes_list);
			if(clist != NULL)
			{
			    list_item_text[0] = val;
			    gtk_clist_append(clist, list_item_text);
			}
		    }
                    /* Cycle */
                    else if(!strcasecmp(parm, "Cycle"))
                    {
                        mode_ptr->cycle_us = atol(val);
                    }
                    /* WriteAhead */
                    else if(!strcasecmp(parm, "WriteAhead"))
                    {
                        mode_ptr->write_ahead_us = atol(val);
                    }
                    /* SampleSize */
                    else if(!strcasecmp(parm, "SampleSize"))
                    {
                        mode_ptr->sample_size = atoi(val);

			if(mode_ptr->sample_size == 16)
			    mode_ptr->sample_size = 16;
			else
			    mode_ptr->sample_size = 8;
                    }
                    /* Channels */
                    else if(!strcasecmp(parm, "Channels"))
                    {
                        mode_ptr->channels = atoi(val);

                        if(mode_ptr->channels == 2)
                            mode_ptr->channels = 2;
                        else
                            mode_ptr->channels = 1;
                    }
                    /* SampleRate */
                    else if(!strcasecmp(parm, "SampleRate"))
                    {
                        mode_ptr->sample_rate = atoi(val);
                    }
                    /* AllowFragmenting */
                    else if(!strcasecmp(parm, "AllowFragmenting"))
                    {
                        mode_ptr->allow_fragmenting = StringIsYes(val);
                    }
                    /* Fragments */
                    else if(!strcasecmp(parm, "Fragments"))
                    {
                        mode_ptr->num_fragments = atoi(val);
                    }
                    /* FragmentSize */
                    else if(!strcasecmp(parm, "FragmentSize"))
                    {
			/* On file it's in bytes. */
                        mode_ptr->fragment_size = atoi(val);
                    }
                    /* FlipStereo */
                    else if(!strcasecmp(parm, "FlipStereo"))
                    {
                        mode_ptr->flip_stereo = StringIsYes(val);
                    }
                    /* Direction */
                    else if(!strcasecmp(parm, "Direction"))
                    {
			if(!strcasecmp(val, "Record"))
			    mode_ptr->direction = 1;
			else
                            mode_ptr->direction = 0;
                    }

                    /* EndAudioMode */
                    else if(!strcasecmp(parm, "EndAudioMode") ||
			    !strcasecmp(parm, "EndYMode") ||
                            !strcasecmp(parm, "EndMode")
		    )
                    {
                        break;
                    }
                    /* Unknown parameter. */
                    else
                    { 
                        fprintf(stderr,
                            "%s: Line %i: Unknown parameter: %s\n",
                            filename,
                            lines_read,
                            parm
                        );
                        continue;
                    }

                }
            }

            /* **************************************************** */
            /* BeginSoundPath */
            else if(!strcasecmp(parm, "BeginSoundPath"))
            {
		/* Do not allocate a path just yet. */

                while(1)
                {
                    /* Free previous line and allocate/read next line. */
                    free(strptr); strptr = NULL;
                    strptr = FReadNextLineAlloc(fp, UNIXCFG_COMMENT_CHAR);
                    if(strptr == NULL) break;
                    lines_read++;

                    /* Fetch parameter. */
                    strptr2 = StringCfgParseParm(strptr);
                    if(strptr2 == NULL) continue;
                    strncpy(parm, strptr2, CFG_PARAMETER_MAX);
                    parm[CFG_PARAMETER_MAX - 1] = '\0';

                    /* Fetch value. */
                    strptr2 = StringCfgParseValue(strptr);
                    if(strptr2 == NULL) strptr2 = "0";
                    strncpy(val, strptr2, CFG_VALUE_MAX);
                    val[CFG_VALUE_MAX - 1] = '\0';  


                    /* Path */   
                    if(!strcasecmp(parm, "Path"))
                    {
                        clist = GTK_CLIST(ycw->sound_paths_list);
                        if(clist != NULL)
			{
                            list_item_text[0] = val;
                            gtk_clist_append(clist, list_item_text);

			    /* Increment total. */
                            ycw->total_sound_paths++;
			}
                    }
                    /* EndSoundPath */
                    else if(!strcasecmp(parm, "EndSoundPath"))
                    {
                        break;
                    }
                    /* Unknown parameter. */  
                    else
                    {
                        fprintf(stderr,
                            "%s: Line %i: Unknown parameter: %s\n",
                            filename,
                            lines_read,
                            parm
                        );
                        continue;
                    } 
                }
            }

            /* Unknown parameter. */
            else
            {
                fprintf(stderr, "%s: Line %i: Unknown parameter: %s\n",
                    filename,
                    lines_read,
                    parm
                );
            }
	}


	/* Close the file. */
	fclose(fp);


	return(0);
}


/*
 *	Prints a bunch of '#' characters in a row.
 */
void RCWriteCharHR(FILE *fp)
{
	int i;


	if(fp == NULL)
	    return;

        fprintf(fp, "# ");
        for(i = 0; i < 78; i++)
            fputc('#', fp);
        fputc('\n', fp);

	return;
}

/*
 *      Saves configuration to filename.  Returns 0 on success
 *      and -1 on error.
 */
int RCSaveToFile(char *filename)
{
        int i;
	char *strptr;
        FILE *fp;

	int bytes_written = 0;

	audio_mode_struct *mode_ptr;
	GtkCList *clist;
        yc_win_struct *ycw;

  
        ycw = &yc_win;



	if(filename == NULL)
	    return(-1);

        fp = fopen(filename, "w");
        if(fp == NULL)
            return(-1);


        /* Header. */
	RCWriteCharHR(fp);
        fprintf(fp,
"#\n\
# YIFF Sound Server Configuration File\n\
#\n\
# Generated by %s %s\n\
#\n\
\n\n",
	    PROG_NAME,
	    PROG_VERSION
	);
	fprintf(fp,
"# Configuration file version:\n\
#\n\
VersionMajor = %i\n\
VersionMinor = %i\n\
\n\n",
	    PROG_VERSION_MAJOR,
	    PROG_VERSION_MINOR
	);

        /* Listening port number. */
        fprintf(fp,
"# Listening port number:\n\
#\n\
Port = %s\n\
\n\n",
            gtk_entry_get_text(
                GTK_ENTRY(ycw->port_num_text)
            )
        );

        /* Refresh interval (in microseconds). */
        fprintf(fp,
"# Refresh interval (in microseconds):\n\
#\n\
RefreshInterval = %s\n\
\n\n",
            gtk_entry_get_text(
                GTK_ENTRY(ycw->refresh_interval_text)
            )
        );

        /* Audio device. */
        fprintf(fp,
"# Audio device:\n\
#\n\
Device = %s\n\
\n\n",
            gtk_entry_get_text(
                GTK_ENTRY(ycw->device_name_text)
            )
        );

	/* Mixer device. */
        fprintf(fp,
"# Mixer device:\n\
#\n\
Mixer = %s\n\
\n\n",
            gtk_entry_get_text(
                GTK_ENTRY(ycw->mixer_name_text)
            )
        );

        /* Play MIDI command. */
        fprintf(fp,
"# Command to execute to play an MIDI Sound Object (a .mid file). Since\n\
# MIDI implmentation is still under development on most platforms, you\n\
# will need to consult your sound driver documentation on the proper\n\
# procedure to play .mid files.\n\
#\n\
# Known MIDI playing implmentations are:\n\
#\n\
#    ALSA drivers uses the `pmidi' driver program.\n\
#    OSS drivers uses the `drvmidi' driver program.\n\
#    Other possible programs include `playmidi'.\n\
#\n\
# The following substitutions will be made to the command:\n\
#\n\
#    %%f         Full path to the MIDI Sound Object on file.\n\
#\n\
MIDIPlayCommand = %s\n\
\n\n",
	    gtk_entry_get_text(
                GTK_ENTRY(ycw->midi_play_cmd_text)
            )
	);


	/* ******************************************************** */
	/* Audio modes list. */
        RCWriteCharHR(fp);
	fprintf(fp,
"#\n\
# Preset Audio modes:\n\
#\n\
# All timming values are in microseconds unless noted otherwise. Values for\n\
# FragmentSize are in values of 2^n, where n is a value from 8 to 14 (some\n\
# Sound drivers may have greater restrictions on the value of n, please read\n\
# the documentation that pertains to your Sound driver).\n\
#\n\
\n"
	);

	clist = GTK_CLIST(ycw->audio_modes_list);
	if(clist != NULL)
	{
	    for(i = 0; i < ycw->total_audio_modes; i++)
	    {
		mode_ptr = ycw->audio_mode[i];
		if(mode_ptr == NULL)
		    continue;

		if(i == 0)
		{
		    /* First Audio mode, the default one. */
                    fprintf(fp,
"# Default mode, this must be defined and should be the first entry.\n"
	            );
                    fprintf(fp,
"# YIFF will start up running in this mode.\n"
	            );
                    fprintf(fp,
"#\n"
	            );
		}

                fprintf(fp, "BeginAudioMode\n");

		gtk_clist_get_text(clist, i, 0, &strptr);
		if(strptr != NULL)
                    fprintf(fp, "    Name = %s\n", strptr);
                else
		    fprintf(fp, "    Name = Untitled\n");

                fprintf(fp, "    Cycle = %ld\n",
		    mode_ptr->cycle_us
		);

                fprintf(fp, "    WriteAhead = %ld\n",
                    mode_ptr->write_ahead_us
                );

                fprintf(fp, "    SampleSize = %i\n",
                    mode_ptr->sample_size
		);

                fprintf(fp, "    Channels = %i\n",
                    mode_ptr->channels
                );

                fprintf(fp, "    SampleRate = %i\n",
                    mode_ptr->sample_rate
                );

                fprintf(fp, "    AllowFragmenting = %s\n",
		    (mode_ptr->allow_fragmenting) ? "yes" : "no"
		);

		fprintf(fp, "    Fragments = %i\n",
		    mode_ptr->num_fragments
		);

		/* In bytes. */
		fprintf(fp, "    FragmentSize = %i\n",
		    mode_ptr->fragment_size
		);

                fprintf(fp, "    FlipStereo = %s\n", 
                    ((mode_ptr->flip_stereo) ? "yes" : "no")
                );

                fprintf(fp, "    Direction = %s\n",
                    (mode_ptr->direction == 1) ? "Record" : "Play"
                );

                fprintf(fp, "EndAudioMode\n\n");
	    }
	}
        fprintf(fp, "\n");


        /* ******************************************************** */
        /* Sound paths. */
        RCWriteCharHR(fp);
        fprintf(fp,
"#\n\
# Sound Paths:\n\
#\n\
# Sound Objects who's paths are not absolute are searched through these\n\
# Sound Paths (directories).\n\
#\n\
# You may specify as many Sound Paths as you wish, keep in mind that the\n\
# Sound Paths are searched through in the order from first to last.\n\
#\n\
\n"
	);

        clist = GTK_CLIST(ycw->sound_paths_list);
        if(clist != NULL)
        {
	    for(i = 0; TRUE; i++)
	    {
		strptr = NULL;
                gtk_clist_get_text(clist, i, 0, &strptr);
                if(strptr == NULL)
		    break;

		fprintf(fp, "BeginSoundPath\n");
		fprintf(fp, "    Path = %s\n",
                    strptr
                );
                fprintf(fp, "EndSoundPath\n\n");
	    }
	}
        fprintf(fp, "\n");




	/* Footer. */
	fprintf(fp,
"#\n\
# End of file.\n"
	);
        RCWriteCharHR(fp);



	/* Close the file. */
	fclose(fp);


	return(0);
}
