/*								-*- C++ -*-
 * $Id: WIN_toolbar.cpp,v 1.3 1997-01-15 14:59:25+01 mho Exp $
 *
 * Purpose: wxWindows Tool Bar
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_toolbar.h"
#endif

#define  Uses_wxButton
#define  Uses_wxCheckBox
#define  Uses_wxToolBar
#include "wx.h"

//-----------------------------------------------------------------------------
// wxToolBarClientData
//-----------------------------------------------------------------------------

class wxToolBarClientData : public wxObject {
DECLARE_DYNAMIC_CLASS(wxToolBarClientData)
public:
    wxToolBarClientData(wxToolBar *toolbar, int tool_index, wxBitmap *b1,
			wxBitmap *b2, Bool toggle, wxObject *data);
public:
    wxToolBar* tbar;
    Bool       toggle_down;
    Bool       is_toggle;
    Bool       enabled;
    Bool       left_window;
    int        index;
    int        tab;
    int        new_line;
    wxBitmap   bmp1;
    wxBitmap   bmp2;
    wxObject*  client_data;
};

IMPLEMENT_ABSTRACT_CLASS(wxToolBarClientData, wxObject)

wxToolBarClientData::wxToolBarClientData(wxToolBar *toolbar, int tool_index,
					 wxBitmap *b1, wxBitmap *b2,
					 Bool toggle, wxObject *data)
{
    tbar        = toolbar;
    index       = tool_index;
    bmp1        = b1;
    bmp2        = b2;
    enabled	= TRUE;
    left_window = FALSE;
    is_toggle   = toggle;
    toggle_down = FALSE;
    client_data = data;
    tab         = 0;
    new_line    = FALSE;
}

// access toolbardata from children list node
#define GET_DATA(node) \
    ((wxToolBarClientData*) \
     ((wxWindow*)node->Data())->GetEventHandler()->GetClientData())

//-----------------------------------------------------------------------------
// wxToolBarItemEvtHandler
//-----------------------------------------------------------------------------

class wxToolBarEvtHandler : public wxEvtHandler {
DECLARE_DYNAMIC_CLASS(wxToolBarEvtHandler)
public:
    wxToolBarEvtHandler(wxEvtHandler *oldEvtHandler);

//     virtual void OnChar(wxKeyEvent& event);
    virtual void OnEvent(wxMouseEvent& event);
    virtual void OnPaint(void);
};

IMPLEMENT_ABSTRACT_CLASS(wxToolBarEvtHandler, wxEvtHandler)

wxToolBarEvtHandler::wxToolBarEvtHandler(wxEvtHandler *oldEvtHandler)
{
    SetNextHandler(oldEvtHandler);
}

// void wxToolBarEvtHandler::OnChar(wxKeyEvent& event)
// {
//     GetNextHandler()->OnChar(event);
// }

void wxToolBarEvtHandler::OnEvent(wxMouseEvent& event)
{
    // get index of tool
    wxToolBarClientData *cdata = (wxToolBarClientData*)GetClientData();
//     printf("wxToolBarEvtHandler::OnEvent() cdata = %p\n", cdata);
//     printf("cdata->tbar  = %p\n", cdata->tbar);
//     printf("cdata->tbar  = %s\n", cdata->tbar->GetName());
//     printf("cdata->index = %d\n", cdata->index);
    // handle event
    switch (event.eventType) {
    case wxEVENT_TYPE_ENTER_WINDOW:
 	GetNextHandler()->OnEvent(event);
	cdata->tbar->OnMouseEnter(cdata->index);
	break;
    case wxEVENT_TYPE_LEAVE_WINDOW:
 	GetNextHandler()->OnEvent(event);
	cdata->tbar->OnMouseEnter(-1);
	cdata->left_window = TRUE;
	break;
    case wxEVENT_TYPE_LEFT_UP:
	if (cdata->enabled && !cdata->left_window) {
	    if (cdata->is_toggle) {
		// tool is a toggle
		GetNextHandler()->OnEvent(event); // do visible feedback
		Bool new_toggle_state = !cdata->toggle_down;
		if (cdata->tbar->OnLeftClick(cdata->index, new_toggle_state)) {
		    // toggling allowed
		    if ((cdata->toggle_down = new_toggle_state)) {
			if (cdata->bmp2.Ok())
			    ((wxCheckBox*)event.eventObject)
				->SetLabel(cdata->bmp2);
		    } else {
			if (cdata->bmp1.Ok())
			    ((wxCheckBox*)event.eventObject)
				->SetLabel(cdata->bmp1);
		    }
		} else {
		    // toggling forbidden
		    ((wxCheckBox*)event.eventObject)
			->SetValue(cdata->toggle_down);
		    return;
		}
	    } else {
		// tool is a button
		GetNextHandler()->OnEvent(event); // release button
		cdata->tbar->OnLeftClick(cdata->index, FALSE);
	    }
	}
	break;
    case wxEVENT_TYPE_RIGHT_DOWN: { //UP: {
	cdata->left_window = FALSE;
	if (cdata->enabled && !cdata->left_window) {
	    // get x,y position relatively to toolbar
	    int x = int(event.x);
	    int y = int(event.y);
	    ((wxWindow*)event.eventObject)->ClientToScreen(&x, &y);
	    cdata->tbar->ScreenToClient(&x, &y);
	    GetNextHandler()->OnEvent(event); // release button
	    cdata->tbar->OnRightClick(cdata->index, float(x), float(y));
	}}
    case wxEVENT_TYPE_RIGHT_UP:
	cdata->left_window = FALSE;
	break;
    case wxEVENT_TYPE_LEFT_DOWN: //case wxEVENT_TYPE_RIGHT_DOWN:
	cdata->left_window = FALSE;
    default:
	// call old eventhandler to care for visible feedback
 	GetNextHandler()->OnEvent(event);
    }
}

void wxToolBarEvtHandler::OnPaint(void)
{
    GetNextHandler()->OnPaint();
}

//-----------------------------------------------------------------------------
// create toolbar
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxToolBar, wxPanel)

wxToolBar::wxToolBar(wxWindow *parent, int x, int y, int w, int h, long style,
		     int orientation, int RowsOrColumns, Constdata char *name)
    : wxPanel(parent, x, y, w, h,
	      style | orientation | wxNO_KEYB_TRAVERSAL, name)
{
    rows_or_columns = wxMax(1, RowsOrColumns);
    current_pos     = 0;
    // panel variables
    h_margin = v_margin = h_space = v_space = 0;
}

wxToolBar::~wxToolBar(void)
{
    ClearTools();
}

wxToolBarTool* wxToolBar::AddTool(int tool_index,
				  wxBitmap *bmp1, wxBitmap *bmp2,
				  Bool toggle, float x, float y, wxObject *data,
				  char *WXUNUSED(helpString1),
				  char *WXUNUSED(helpString2))

{
    wxItem *item;

    // create toggle or button
    char toolname[80]; sprintf(toolname, "tool%d", tool_index);
    if (toggle)
	item = wxNEW wxCheckBox(this, NULL, bmp1, int(x), int(y),
				-1, -1, wxNO_INDICATOR|wxNO_BORDER, toolname);
    else
	item = wxNEW wxButton(this, NULL, bmp1, int(x), int(y),
			      -1, -1, wxNO_BORDER, toolname);
    // set special eventhandler
    wxToolBarEvtHandler *eh = wxNEW wxToolBarEvtHandler(item);
    item->SetEventHandler(eh);
    // set client data
    wxToolBarClientData *cdata = wxNEW wxToolBarClientData(this, tool_index,
							   bmp1, bmp2,
							   toggle, data);
    eh->SetClientData((char*)cdata);
    // break row or column
    if (++current_pos % rows_or_columns == 0)
	NewLine();
    return (wxToolBarTool*)item;
}

//-----------------------------------------------------------------------------
// utility functions
//-----------------------------------------------------------------------------

wxToolBarTool* wxToolBar::FindToolForPosition(float WXUNUSED(x),
					      float WXUNUSED(y))
{
    // not needed
    return NULL;
}

//TOMT added this. have to implement ....
void wxToolBar::AddSeparator ()
{
/*
  wxToolBarTool *tool = new wxToolBarTool;
  tool->toolStyle = wxTOOL_STYLE_SEPARATOR;
  tools.Append(tool);
 */
}
//ENDT

void wxToolBar::ClearTools(void)
{
    wxNode *node;
    while ( (node=GetChildren()->First()) != (wxNode*)NULL ) {
	wxWindow *child = (wxWindow*)(node->Data());
	if (child) {
	    wxEvtHandler *eh = child->GetEventHandler();
	    child->SetEventHandler(child);
	    if (eh) {
		wxObject *data = (wxObject*)eh->GetClientData();
		if (data) delete data;
		if (eh != child) delete eh;
	    }
	    delete child;
	}
    }
}

void wxToolBar::EnableTool(int toolIndex, Bool enable)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == toolIndex) {
	    ((wxWindow*)node->Data())->Enable(enable);
	    data->enabled = enable;
	}
    }
}

void wxToolBar::GetMaxSize(float *w, float *h)
{
    int ww, hh;

    Fit(); GetSize(&ww, &hh);
    *w = float(ww); *h = float(hh);
}

wxObject* wxToolBar::GetToolClientData(int index)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == index)
	    return data->client_data;
    }
    return NULL;
}

Bool wxToolBar::GetToolEnabled(int toolIndex)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == toolIndex)
	    return (data->enabled);
    }
    return FALSE;
}

Bool wxToolBar::GetToolState(int toolIndex)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == toolIndex) {
	    return (data->is_toggle && data->toggle_down);
	}
    }
    return FALSE;
}

void wxToolBar::Layout(void)
{
    int last_x = 0;
    int last_y = 0;
    int max_tool_width = 0;
    int max_tool_height = 0;
    int tool_number_this_line = 0;

    wxNode *node;

    // Find the maximum tool width and height
    for (node = GetChildren()->First(); node; node = node->Next()) {
	int ww, hh; ((wxWindow*)node->Data())->GetSize(&ww, &hh);
	max_tool_width  = wxMax(ww, max_tool_width);
	max_tool_height = wxMax(ww, max_tool_width);
    }
//     // resize tools
//     for (node = GetChildren()->First(); node; node = node->Next()) {
// 	((wxWindow*)node->Data())->SetSize(max_tool_width, max_tool_height);
//     }
    for (node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow            *tool = (wxWindow*)node->Data();
	wxToolBarClientData *data = GET_DATA(node);
	if (orientation == wxHORIZONTAL) {
	    if (tool_number_this_line >= rows_or_columns) {
		tool_number_this_line = 0;
		last_x  = 0;
		last_y += v_space + max_tool_height;
	    }
	    tool->Move(last_x, last_y);
	    last_x += h_space + max_tool_width + data->tab;
	    if (data->new_line) {
		last_y += data->tab;
		tool_number_this_line = rows_or_columns;
	    }
	    ++tool_number_this_line;
	} else { // orientation == wxVERTICAL
	    if (tool_number_this_line >= rows_or_columns) {
		tool_number_this_line = 0;
		last_y  = 0;
		last_x += h_space + max_tool_width;
	    }
	    tool->Move(last_x, last_y);
	    last_y += v_space + max_tool_height + data->tab;
	    if (data->new_line) {
		last_x += data->tab;
		tool_number_this_line = rows_or_columns;
	    }
	    ++tool_number_this_line;
	}
    }
    wxPanel::Fit();
}

void wxToolBar::NewLine(void)
{
    NewLine((orientation == wxHORIZONTAL) ? v_space : h_space);
}

void wxToolBar::NewLine(int pixels)
{
    wxNode *node;

    if ( (node = GetChildren()->Last()) ) {
	wxToolBarClientData *last_data = GET_DATA(node);
	last_data->tab      = pixels;
	last_data->new_line = TRUE;
    }
    wxPanel::NewLine(pixels);
}

void wxToolBar::SetMargins(float x, float y)
{
    SetHorizontalMargin(int(x));
    SetHorizontalSpacing(int(x));
    SetVerticalMargin(int(y));
    SetVerticalSpacing(int(y));
}

void wxToolBar::SetOrientation(int orient)
{
    orientation = orient;
    Layout();
}

void wxToolBar::SetToggle(int toolIndex, Bool toggle)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxWindow            *old_tool  = (wxWindow*)node->Data();
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == toolIndex) {
	    if (data->is_toggle == toggle) // not changed
		return;
	    // change type of tool
	    // 1.) get old position and size
	    int x, y, w, h;
	    old_tool->GetPosition(&x, &y); old_tool->GetSize(&w, &h);
	    wxItem *new_tool;
	    // 2. create new tool
	    char toolname[80]; sprintf(toolname, "tool%d", toolIndex);
	    if (toggle)
		new_tool = wxNEW wxCheckBox(this, NULL, data->bmp1, x, y, w, h,
					    wxNO_INDICATOR | wxNO_BORDER,
					    toolname);
	    else
		new_tool = wxNEW wxButton(this, NULL, data->bmp1, x, y, w, h,
					  wxNO_BORDER, toolname);
	    // move eventhandler and clientdata to new tool
	    new_tool->SetEventHandler(old_tool->GetEventHandler());
	    // delete old tool and replace item by new tool (not RemoveChild!)
	    old_tool->SetParent(NULL);
	    delete old_tool;
	    node->SetData(new_tool);
	}
    }
}

void wxToolBar::Tab(void)
{
    Tab((orientation == wxHORIZONTAL) ? h_space : v_space);
}

void wxToolBar::Tab(int pixels)
{
    wxNode *node;

    if ( (node = GetChildren()->Last()) ) {
	wxToolBarClientData *last_data = GET_DATA(node);
	last_data->tab = pixels;
    }
    wxPanel::Tab();
}

void wxToolBar::ToggleTool(int toolIndex, Bool toggle)
{
    for (wxNode *node = GetChildren()->First(); node; node = node->Next()) {
	wxToolBarClientData *data = GET_DATA(node);
	if (data->index == toolIndex && data->is_toggle) {
	    ((wxCheckBox*)node->Data())->SetValue( (data->toggle_down=toggle) );
	}
    }
}

//-----------------------------------------------------------------------------
// wxToolBar events
//-----------------------------------------------------------------------------

Bool wxToolBar::OnLeftClick(int WXUNUSED(toolIndex), Bool WXUNUSED(toggleDown))
{
    return FALSE;
}

void wxToolBar::OnMouseEnter(int WXUNUSED(toolIndex))
{
}

void wxToolBar::OnRightClick(int WXUNUSED(toolIndex),
			     float WXUNUSED(x), float WXUNUSED(y))
{
}
