/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#include "vdk/vdkctree.h"

typedef struct { VDKTreeNodeList* list; char* key; } FindInfo;

static void IterateOnTree(GtkCTree     *ctree,
			  GtkCTreeNode *node,
			  gpointer      i);
/*
answer to selection on 
single selection mode
 */
void VDKCustomTree::NodeSelection(GtkWidget* wid,
		  GtkCTreeNode* node,
		  int column,
		  gpointer s)
{ 
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal =  
    reinterpret_cast<VDKObjectSignal*>(s);
  VDKCustomTree* obj = reinterpret_cast<VDKCustomTree*>(signal->obj);
  obj->SelectedNode(node);
  obj->SelectedColumn(column);
  if(obj->mode != GTK_SELECTION_EXTENDED
     &&
     obj->mode != GTK_SELECTION_MULTIPLE
     )
    obj->SignalEmit(signal->signal);
#ifdef USE_SIGCPLUSPLUS
  obj->OnNodeSelect(obj, node, column);
#endif /* USE_SIGCPLUSPLUS */
}
/*
answer to unselection on 
single selection mode
 */
void VDKCustomTree::NodeUnselection(GtkWidget* wid,
		  GtkCTreeNode* node,
		  int column,
		  gpointer s)
{
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal = 
    reinterpret_cast<VDKObjectSignal*>(s);
  VDKCustomTree* obj = reinterpret_cast<VDKCustomTree*>(signal->obj);
  obj->UnselectedNode(node);
  obj->UnselectedColumn(column);
  obj->SelectedNode(NULL);
  obj->SelectedColumn(-1);
  if(obj->mode != GTK_SELECTION_EXTENDED
     &&
     obj->mode != GTK_SELECTION_MULTIPLE
     )
    obj->SignalEmit(signal->signal);
#ifdef USE_SIGCPLUSPLUS
  obj->OnNodeUnselect(obj, node, column);
#endif /* USE_SIGCPLUSPLUS */
}
/*
answer to dbl click on extended mode,
emits select_node signal
 */
int VDKCustomTree::ButtonPress (GtkWidget* wid, 
				GdkEventButton *ev, 
				gpointer s)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  g_return_val_if_fail(ev != NULL,FALSE);
  g_return_val_if_fail(s != NULL,FALSE);
  VDKCustomTree* obj = reinterpret_cast<VDKCustomTree*>(s);
  if(obj->mode != GTK_SELECTION_EXTENDED)
    return FALSE;
  int row;
  int column; 
  VDKTreeNode node;
  int res;
  res = gtk_clist_get_selection_info (GTK_CLIST (wid), 
				      int(ev->x), int(ev->y), 
				      &row, &column);
  if( (!res) || (ev->type != GDK_2BUTTON_PRESS))
      return FALSE;
  node = GTK_CTREE_NODE (g_list_nth (GTK_CLIST (wid)->row_list, row));
  if(node)
    {
      obj->SelectedNode(node);
      obj->SelectedColumn(column);
      obj->SignalEmit(select_node_signal);
    }
  return TRUE;
}

//////////////////////////////////
/*
constructor
 */
VDKCustomTree::VDKCustomTree(VDKForm* owner,
			     int columns,
			     char **titles,
			     GtkSelectionMode mode,
			     int tree_column):
  VDKCustom(owner,columns,titles,mode),
  tree_column(tree_column),
  Spacing("Spacing",this,5,&VDKCustomTree::SetSpacing),
  SelectedNode("SelectedNode",this,NULL,&VDKCustomTree::SetSelectedNode),
  SelectedColumn("SelectedColumn",this,-1),
  UnselectedNode("UnselectedNode",this,NULL,&VDKCustomTree::SetUnselectedNode),
  UnselectedColumn("UnselectedColumn",this,-1),
  LineStyle("LineStyle",this,GTK_CTREE_LINES_SOLID,
	    &VDKCustomTree::SetLineStyle),
  ExpanderStyle("ExpanderStyle",this,GTK_CTREE_EXPANDER_SQUARE,
		&VDKCustomTree::SetExpanderStyle)
  
{
if(!titles) 
    custom_widget = gtk_ctree_new(columns,tree_column);
else
    custom_widget = gtk_ctree_new_with_titles (columns, tree_column, titles);
 int rh = custom_widget->style->font->ascent + 
   custom_widget->style->font->descent+1;
 RowHeight(rh);
 gtk_clist_set_row_height(GTK_CLIST(custom_widget),rh);
 gtk_clist_set_selection_mode(GTK_CLIST(custom_widget),mode);
 gtk_clist_set_shadow_type(GTK_CLIST(custom_widget), GTK_SHADOW_ETCHED_OUT);

if(titles)
  {
    int t;
    for (t = 0; t < columns; t++)
      {
	Titles[t] = new VDKObject(owner,
				  GTK_CLIST(custom_widget)->column[t].button);
	AddItem(Titles[t]);
      }
  } 
 gtk_container_add (GTK_CONTAINER (widget), custom_widget);
 gtk_widget_show(GTK_WIDGET(custom_widget));
 ConnectSignals();
#ifdef USE_SIGCPLUSPLUS
 make_gtksigc_connection(this);
#endif
}
/*
 */
void
VDKCustomTree::ConnectSignals()
{
  // call ancestor
  VDKCustom::ConnectSignals();

  s_list_select.obj = this;
  s_list_select.signal = select_node_signal;
  s_list_unselect.obj = this;
  s_list_unselect.signal = unselect_node_signal;
  
  select_connect = 
    gtk_signal_connect( GTK_OBJECT(custom_widget),
			"tree_select_row",
			GTK_SIGNAL_FUNC(VDKCustomTree::NodeSelection),  
			(gpointer) &s_list_select);
    unselect_connect = 
      gtk_signal_connect(GTK_OBJECT(custom_widget),
			 "tree_unselect_row",
			 GTK_SIGNAL_FUNC(VDKCustomTree::NodeUnselection),
			 (gpointer) &s_list_unselect);
    gtk_signal_connect (GTK_OBJECT (custom_widget), 
			"button_press_event",
			GTK_SIGNAL_FUNC (VDKCustomTree::ButtonPress), 
			this);
  // specialized connect to realize signal
  s_realize.obj = this;
  s_realize.signal = realize_signal;
  gtk_signal_connect(GTK_OBJECT(CustomWidget()),"realize",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_realize);
}

/*
 */
void 
VDKCustomTree::SetStyle(VDKTreeNode node)
{
  
  GtkStyle *style = 
    gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(custom_widget)));
  g_return_if_fail(style != NULL);
  gtk_style_ref(style);
  if(UnselectedBackground)
    {
      GdkColor c = *(*UnselectedBackground);
      style->base[GTK_STATE_NORMAL] = c;
    }
  if(SelectedBackground)
    style->bg[GTK_STATE_SELECTED] = *(*SelectedBackground);
  if(UnselectedForeground)
    {
      GdkColor c = *(*UnselectedForeground);
      style->fg[GTK_STATE_NORMAL] = c;
    }
  if(SelectedForeground)
    style->fg[GTK_STATE_SELECTED] = *(*SelectedForeground);
  gtk_ctree_node_set_row_style (GTK_CTREE (custom_widget), node, style);

}

/*
 */
VDKCustomTree::~VDKCustomTree()
{
}
/*
add a node to tree,
if parent == NULL add a root,
otherwise a child
 */
VDKTreeNode
VDKCustomTree::AddNode(
		       char  *text[],
		       VDKTreeNode parent,
		       bool expanded,
		       bool isLeaf,
		       char **pixmap_closed,
		       char **pixmap_opened)
{
 VDKTreeNode node;
 GdkBitmap *mask = NULL,*mask1 = NULL;
 GdkPixmap *pixmap = NULL,*pixmap1 = NULL;
 GtkStyle* style = gtk_widget_get_style(owner->Window());
 if(pixmap_closed)
   pixmap = 
     gdk_pixmap_create_from_xpm_d(owner->Window()->window,
				  &mask,
				  &style->bg[GTK_STATE_NORMAL],
				  pixmap_closed);
  if(pixmap_opened)
    pixmap1 =  
      gdk_pixmap_create_from_xpm_d(owner->Window()->window,
				 &mask,
				 &style->bg[GTK_STATE_NORMAL],
				 pixmap_opened);

  node = gtk_ctree_insert_node (GTK_CTREE(custom_widget),
				parent, NULL, 
				text, Spacing,
				pixmap,	mask,  
				pixmap1, mask1,
				isLeaf, expanded);
  // sets row height
  // unuseful
  /*
    if(pixmap || pixmap1)
    {
    int w = 0, h = 0;
    sscanf (pixmap_closed ? pixmap_closed[0] : pixmap_opened[0],
    "%d %d", &w, &h);
    printf("\nh:%d",h);
    fflush(stdout);
    gtk_clist_set_row_height (GTK_CLIST(custom_widget),h);
    }
  */
  if(node) 
    SetStyle(node);
  return node; 
}
////////////////////////////////////////////////////
Tuple
VDKCustomTree::operator[](VDKTreeNode node)
{
int t;
Tuple temp(columns,tree_column);
char *text;
if(node == NULL)
  return temp;
for(t=0; t < columns;t++)
  {
    if (
	(GTK_CTREE_ROW (node)->row.cell[t].type == GTK_CELL_TEXT)
	&&
	(gtk_ctree_node_get_text(GTK_CTREE(custom_widget), node, t, &text))
	)
      temp[t] = text;
    else if (
	(GTK_CTREE_ROW (node)->row.cell[t].type == GTK_CELL_PIXTEXT)
	&&
	(gtk_ctree_node_get_pixtext (GTK_CTREE(custom_widget),
			    node, t,&text,NULL,NULL,NULL))
	)
      temp[t] = text;
  }
return temp;
}

/*
return an array filled with selected nodes,
empty on single selection mode.
Tip:  
array sequence is in a recursive form,
 */
VDKTreeNodeArray& 
VDKCustomTree::Selections()
{
  GList* list,*head;
  int listSize = 0, t;
  WideSelection = VDKTreeNodeArray(0);
  if(Size() == 0)
    return WideSelection;
  else if( 
	  (mode == GTK_SELECTION_EXTENDED)
	  ||
	  (mode == GTK_SELECTION_MULTIPLE)
	  )
    
    {
      list = head = GTK_CLIST(custom_widget)->selection;
      // count list size and goes to tail as well
      if(head)
	for(t=0; head; head = head->next,listSize++)
	  ;
      // load array;
      WideSelection = VDKTreeNodeArray(listSize);
      for(t = 0; t < WideSelection.size();t++,list = list->next)
	WideSelection[t] = (VDKTreeNode) list->data;
    }
  return WideSelection;
}
/*
some useful node functions
 */
bool 
VDKCustomTree::IsLeaf(VDKTreeNode node)
{
  int is_leaf;
  if(node == NULL)
    return false;
  else if(gtk_ctree_get_node_info(GTK_CTREE(custom_widget),
				  node,NULL,NULL,NULL,NULL,
				  NULL,NULL,&is_leaf,NULL))
    return is_leaf == 1;
  else
    return false;
}
/*
return node key
 */
char* 
VDKCustomTree::Key(VDKTreeNode node)
{
  char* text;
  if(Size() == 0)
  return NULL;
  else if(node == NULL)
    node = GTK_CTREE_NODE (GTK_CLIST(custom_widget)->row_list);
  if(gtk_ctree_get_node_info(GTK_CTREE(custom_widget),
			     node,&text,NULL,NULL,NULL, NULL,
			     NULL,NULL,NULL))
    return text;
  else
    return NULL;
}
/*
 */
bool 
VDKCustomTree::IsExpanded(VDKTreeNode node)
{
  int expanded = 0;
  if(node == NULL)
    return false;
  gtk_ctree_get_node_info(GTK_CTREE(custom_widget),
			  node,NULL,NULL,NULL,NULL, NULL,
			  NULL,NULL,&expanded);
    return expanded;
}
/*
prunes entire tree
 */
void
VDKCustomTree::Clear()
{
  VDKCustom::Clear();
  SelectedNode(NULL);
  UnselectedNode(NULL);
}
/*

 */
bool
VDKCustomTree::RemoveNode(VDKTreeNode node)
{
if(gtk_ctree_find(GTK_CTREE(custom_widget),NULL,node) )
   gtk_ctree_remove_node (GTK_CTREE(custom_widget),node);
else
  return false;
if(Size() == 0)
  {
    SelectedNode(NULL);
    UnselectedNode(NULL);
  }
return true;
}
/*
 */
void 
VDKCustomTree::SetSelectedNode(VDKTreeNode node)
{
  if(Size() == 0)
    return;
  else if(node == NULL)
    node = GTK_CTREE_NODE (GTK_CLIST(custom_widget)->row_list);
  gtk_ctree_select (GTK_CTREE(custom_widget),node);
}
/*
 */
void 
VDKCustomTree::SetUnselectedNode(VDKTreeNode node)
{
  if(Size() == 0)
    return;
  else if(node == NULL)
    node = GTK_CTREE_NODE (GTK_CLIST(custom_widget)->row_list);
  gtk_ctree_unselect (GTK_CTREE(custom_widget),node);
}
/*
called by Find(char* key)->gtk_ctree_post_recursive(),
if node key matches with key
add that node to list
 */
void
IterateOnTree(GtkCTree     *ctree,
	      GtkCTreeNode *node,
	      gpointer      i)
{
FindInfo* info = (FindInfo*) i;
char *text;
int res = gtk_ctree_get_node_info (ctree, node, &text, 
			 NULL, NULL, NULL, NULL,NULL,NULL,NULL);
if(res && !strcmp(text,info->key))
   info->list->add(node);
}
/*
return a list of nodes that match
<key>, user should delete list after use
 */
VDKTreeNodeList* 
VDKCustomTree::Find(char* key)
{

  VDKTreeNodeList* nodelist = new VDKTreeNodeList;
  FindInfo info = { nodelist, key };
  gtk_ctree_post_recursive(GTK_CTREE(custom_widget), 
			   NULL, IterateOnTree, (gpointer) &info);
  return nodelist;
}

/*
remove all nodes that match <key>,
answer how many nodes has been removed
 */
int
VDKCustomTree::RemoveKey(char* key)
{
VDKTreeNodeList* list = Find(key);
int size = 0;
if( (size = list->size()) > 0)
  {
    VDKTreeNodeListIterator li(*list);
    for(;li;li++)
      RemoveNode(li.current());
  }
delete list;
return size;
}

#ifdef USE_SIGCPLUSPLUS
void
VDKCustomTree::make_gtksigc_connection(VDKCustomTree* obj)
{
     VDKCustom::make_gtksigc_connection(obj);
     gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()),
			"tree_move",
			GTK_SIGNAL_FUNC(&VDKCustomTree::_handle_tree_move),
			reinterpret_cast<gpointer>(obj));
     gtk_signal_connect(GTK_OBJECT(obj->CustomWidget()),
			"tree_expand",
			GTK_SIGNAL_FUNC(&VDKCustomTree::_handle_tree_expand),
			reinterpret_cast<gpointer>(obj));
}

void
VDKCustomTree::_handle_tree_move(GtkWidget*, GtkCTreeNode* node, 
				 GtkCTreeNode* new_parent,
				 GtkCTreeNode* new_sibling, 
				 gpointer gp)
{
     VDKCustomTree* obj=reinterpret_cast<VDKCustomTree*>(gp);
     obj->OnTreeMove(obj, node, new_parent, new_sibling);
}

void
VDKCustomTree::_handle_tree_expand(GtkWidget*, GtkCTreeNode* node,
				    gpointer gp)
{
     VDKCustomTree* obj=reinterpret_cast<VDKCustomTree*>(gp);
     obj->OnTreeExpand(obj, node);
}
#endif
