/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/entry.h"
#include "vdk/forms.h"
#include "vdk/colors.h"
#include <string>

int
VDKEntry::FocusOutEvent(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_out_signal);
  return TRUE;
}
/*
 */
int
VDKEntry::FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_in_signal);
  return TRUE;
}
/*
 */
VDKEntry::VDKEntry(VDKForm* owner, int maxLen, char* def):
  VDKObject(owner),
  Text("Text", this, NULL, &VDKEntry::SetText, &VDKEntry::GetText),
  Editable("Editable", this, true, &VDKEntry::SetEditable),
  Hidden("Hidden", this, false, &VDKEntry::SetHidden)
{
  if(maxLen)
    widget = gtk_entry_new_with_max_length(maxLen);
  else
    widget = gtk_entry_new();
  if(def)
    gtk_entry_set_text(GTK_ENTRY(widget),def);
  s_activated.obj = this;
  s_activated.signal = activate_signal;
  s_changed.obj = this;
  s_changed.signal = changed_signal;
  gtk_signal_connect(GTK_OBJECT(widget),"activate",
		   GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		   (gpointer) &s_activated);
  changeConnect = gtk_signal_connect(GTK_OBJECT(widget),"changed",
		     GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		     (gpointer) &s_changed);
  gtk_signal_connect(GTK_OBJECT(widget),
		       "focus_out_event",
		       GTK_SIGNAL_FUNC(VDKEntry::FocusOutEvent),
		       (gpointer) this);
  gtk_signal_connect(GTK_OBJECT(widget),
		       "focus_in_event",
		       GTK_SIGNAL_FUNC(VDKEntry::FocusInEvent),
		       (gpointer) this);
  ConnectDefaultSignals();
}
/*
 */
VDKEntry::~VDKEntry()
{
}
/*
 */
void VDKEntry::SetText(string s)
{
  gtk_entry_set_text(GTK_ENTRY(widget),s.c_str());
}

/*
 */
void VDKEntry::SetText(char* s)
{
gtk_entry_set_text(GTK_ENTRY(widget),s);
}
/*
 */
char* VDKEntry::GetText()
{
return gtk_entry_get_text(GTK_ENTRY(widget));
}

/*
 */
void VDKEntry::SetBackground(VDKRgb rgb, 
			     GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  GtkStyle* style = gtk_style_copy(gtk_widget_get_style(widget));
  g_return_if_fail(style != NULL); 
  gtk_style_ref(style); 
  style->base[state] = *(color->Color()); 
  gtk_widget_set_style(widget,style); 

}
