/* 
file: nbookwin.cc
*/
// yet another address program !
 
#include "nbookwin.h"
#define MAX_ADDR 6 
#define MAX_COL 5

extern char *book_open_xpm[];
extern char *book_closed_xpm[];
extern char *mini_bball_xpm[]; 
 
typedef struct {  
  char *items[MAX_COL];  
} ynad;

ynad friends[MAX_ADDR]=
{
  {{"Motta","Mario","via delle fonti 1","Montecolombo","98564"}},
  {{"Guerra","Tonino","via Arcangelo 6","Morciano","34567"}},
  {{"Plum","Adam","Strawberry street 678","Los Angeles","CA4567"}},
  {{"Jim","Uncle","Sky boulevard 34", "Paris", "FR5676"}},
  {{"Adelante", "Speedo","fast plaza", "Madrid","SP98767"}},
  {{"Streisand","Barbara","Star hill 567","Hollywood", "XX5676"}}
};

/*
 */
DEFINE_SIGNAL_MAP(NoteBookWin,VDKForm)
  ON_SIGNAL(quit,clicked_signal,Quit),
  ON_SIGNAL(next,clicked_signal,NextTab),
  ON_SIGNAL(prev,clicked_signal,PrevTab),
  ON_SIGNAL(rotate,clicked_signal,RotateTab),
  ON_SIGNAL(enable,clicked_signal,EnableTab),
  ON_SIGNAL(list,select_row_signal,ListSelection),
  ON_SIGNAL(list,unselect_row_signal,ListUnselection)
END_SIGNAL_MAP
/*
 */
void NoteBookWin::Setup()
{ 
  VDKBox *box = new VDKBox(this,v_box);
  book = new VDKNotebook(this);
  box->Add(book);
  box->Add(new VDKSeparator(this));
  VDKBox* buttonbox = new VDKBox(this,h_box);
  quit = new VDKLabelButton(this,"quit");
  next = new VDKLabelButton(this,"next page");
  prev = new VDKLabelButton(this,"prev page");
  rotate = new VDKLabelButton(this,"rotate tabs");
  enable  = new VDKLabelButton(this,"enable 2nd page");
  buttonbox->Add(quit);
  buttonbox->Add(next); 
  buttonbox->Add(prev);
  buttonbox->Add(rotate);
  buttonbox->Add(enable); 
  box->Add(buttonbox);
  Add(box);
  // since we plan to add pixmaps better make pages after realizing 
  // all stuff 
  MakePage1();
  MakePage2();
  // disables last page
  book->Pages[1]->TabLabel->Enabled = false;
} 
/*
 */
void NoteBookWin::MakePage1() 
{ 
  char* prompts[] =
  {
    "First name",  
    "Address",
    "City", 
    "Phone number",
    0 
  };     
  char* title = "Last name";
  VDKBox *box = new VDKBox(this,h_box);
  // a panel for the list
  VDKBox *panel = new VDKBox(this,v_box);
  list = new VDKCustomList(this,1,&title);
  list->ActiveTitle(0,false);
  list->Titles[0]->NormalBackground = clLightBlue;
   // load address
  int t = 0;   
  for(;t < MAX_ADDR;t++) 
     list->AddRow(friends[t].items);
  list->SetSize(100,130); 
  panel->Add(list);
  box->Add(panel);  
  box->Add(new VDKSeparator(this,v_separator));
  // a table 
  VDKTable *table = new VDKTable(this,4,2,true); 
  for(t=0; t < 4; t++)
    {
      VDKLabel* label = (new VDKLabel(this,prompts[t]));
      table->Add(label,0,1,t,t+1);
    } 
  table->Add(firstname   = new VDKEntry(this,0),1,2,0,1);
  table->Add(address     = new VDKEntry(this,0),1,2,1,2);
  table->Add(city        = new VDKEntry(this,0),1,2,2,3);
  table->Add(phonenumber = new VDKNumericEntry(this,0),1,2,3,4);
  box->Add(table);
  book->AddPage(box,"yet another..",book_closed_xpm,book_open_xpm); 
  list->SelectRow(0,0);
}  
/*
 */
void NoteBookWin::MakePage2() 
{ 
  VDKBox *box = new VDKBox(this,h_box);
  box->Add(new VDKPixmap(this,"./pixmap/linuxGirl.xpm",
			 "By courtesy of B.Bellamy"));
  box->Add(new VDKPixmap(this,"./pixmap/monet.xpm","Claude Monet"));
  book->AddPage(box,"Nice pictures",book_closed_xpm,book_open_xpm);
}
/*
 */
bool NoteBookWin::ListSelection(VDKObject*)
{
int ndx = list->Selected.Row();
if(ndx >= 0)
  {
    list->UpdateRow(ndx,list->Tuples[ndx],mini_bball_xpm,0);
    firstname->Text = friends[ndx].items[1];
    address->Text = friends[ndx].items[2];
    city->Text = friends[ndx].items[3];
    phonenumber->Text = friends[ndx].items[4];
  }
return true;
}
/*
 */
bool NoteBookWin::ListUnselection(VDKObject*)
{
  int ndx = list->Unselected.Row();
  if(ndx >= 0)
    list->UpdateRow(ndx,list->Tuples[ndx]);
  return true;
}
/*
 */
bool NoteBookWin::NextTab(VDKObject* ) 
{ 
  book->ActivePage++; 
  return true;
}
/*
 */
bool NoteBookWin::PrevTab(VDKObject* ) 
{ 
  book->ActivePage--; 
  return true;
}
/*
 */
bool NoteBookWin::EnableTab(VDKObject*) 
{  
  book->Pages[1]->TabLabel->Enabled = true;
  book->ActivePage++;
  return true;
}
/*
 */
bool NoteBookWin::RotateTab(VDKObject*) 
{  
  static int pos = 0;
  book->TabPosition = ++pos;
  return true;
}
 
