/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKSTRING_H
#define VDKSTRING_H
#include <string.h>

struct STRING {          // struttura di smartString
  char* s;              //puntatore a vettore di caratteri
  unsigned int ref ;    // contatore di riferimenti
};

class VDKString {          // classe VDKString
 protected:
  STRING* p;         //puntatore a struttura di tipo string
 public:

  //costruttore VDKString p vuota
  VDKString() 
    {
      p = new STRING; p->s = new char;
      *(p->s) = (char) 0; p->ref = 1;
    }

  //costruttore VDKString p inizializzata a char*
  VDKString (char*s) 
    {
      p = new STRING;
      if(s)
	{
	  p->s = new char[strlen(s)+1];
	  strcpy(p->s,s);
	}
      else
	{
	p->s = new char;
	*(p->s) = (char) 0;
	}
      p->ref = 1; 
    }

  //copy inizializer VDKString p1=p
  VDKString(const VDKString& s)
    {
      s.p-> ref++;         //aumento contat.riferimenti
      p = s.p;             //copia indirizzo del buffer
    }

  //assegnazione p1=p
  VDKString& operator= (const VDKString& s) 
    {
      if (this == &s) return *this;
      else s.p->ref++;
      if (--p->ref == 0) 
	{      //se non ho riferimenti
	  delete p->s;delete p; 
	} //cancello
      p= s.p; //assegnamento
      return *this;
    }

  //assegnazione p1="pippo"
  VDKString& operator= (char* s){
    if (p->ref > 1) {
      p->ref--;
      p = new STRING;}
    else if (p->ref == 1) delete p->s;
    if(s)
	{
	  p->s = new char[strlen(s)+1];
	  strcpy(p->s,s);
	}
      else
	{
	p->s = new char;
	*(p->s) = (char) 0;
	}
    p->ref = 1;
    return *this;
  }

  //distruttore
  ~VDKString() {
    if(--p->ref == 0)    //non ci sono puntatori alla VDKString
      {
	delete[] p->s;
	delete p;  
      }
  }

  //cast di ogg. VDKString a char*
  //warning !! can violate internal buffer.
  operator char*() {return p->s; }

  //operatori relazionali
  //==,<,>,<=,>=,!=
    
  int operator == (VDKString& s) { return !strcmp(p->s,s.p->s); }
  int operator <(VDKString& s) {return strcmp(p->s,s.p->s) < 0; }
  int operator>(VDKString& s) { return strcmp(p->s,s.p->s) > 0; }
  int operator <=(VDKString& s) { return (*this < s || *this == s); }
  int operator >=(VDKString& s) { return (*this > s || *this == s); }
  int operator !=(VDKString& s) { return !(*this == s);	 }
  VDKString& operator +=(char* s) {
    char* local = new char[strlen(p->s)+strlen (s)+1];
    //alloca spazio per una nuova VDKString di char
    strcat(strcpy(local,p->s),s);  //concatena in local le due stringhe
    //riutilizzo operatore di assegnamento
    *this = local;
    return *this;
  }
  /*
   */
  VDKString& operator +=(VDKString& s){
    // riutilizzo +=
    *this += (char*) s;		return *this;		}
  /*
   */
  VDKString  operator + (char* s);
  /*
   */
  VDKString  operator +(VDKString& s){ return *this + (char*) s;	}

  bool isNull() { return !(*p->s); }
  int size() { return strlen(p->s); }
};
#endif




