/* $Id: error.c,v 1.5 1998/07/05 16:57:03 sverrehu Exp $ */
/**************************************************************************
 *
 *  FILE            error.c
 *  MODULE OF       shhmsg - library for displaying messages.
 *
 *  DESCRIPTION     Function for displaying a simple error message.
 *
 *  WRITTEN BY      Sverre H. Huseby <sverrehu@online.no>
 *
 **************************************************************************/

#include <stdio.h>
#include <stdarg.h>

#include "internal.h"
#include "shhmsg.h"

/**************************************************************************
 *                                                                        *
 *                    P U B L I C    F U N C T I O N S                    *
 *                                                                        *
 **************************************************************************/

/*-------------------------------------------------------------------------
 *
 *  NAME          msgError
 *
 *  FUNCTION      Show given message on the _msgErrorStream.
 *
 *  SYNOPSIS      #include "shhmsg.h"
 *                void msgError(const char *format, ...);
 *
 *  INPUT         format, ...
 *                        Arguments used as with printf().
 *
 *  DESCRIPTION   Prints the name of this program followed by ": " and the
 *                given message on the _msgErrorStream.
 */
void
msgError(const char *format, ...)
{
    va_list ap;

    fflush(stdout);
    fprintf(_msgErrorStream, "%s: ", msgGetName());
    va_start(ap, format);
    vfprintf(_msgErrorStream, format, ap);
    va_end(ap);
}
