# ******************************* File: MakeFile.Mak *******************************************
#
# This generic makefile builds .objs and a target .exe or .lib.  It is called using defaults by M.Bat.
# By default, the objects are created in the current directory, and the source exists in the .. parent.
# If not specified, the default target file is ..\%Model%.exe in the parent directory.
#
# The objects may be listed as a macro or in a $(Target).Mif file located in the source directory with
# the same root name as the target .exe or .lib.  The objects are listed in the format "TargetName_Objs ="
# followed by .obj names separated by spaces, using & for line continuation.
# For example: Bitpack_Objs = addlist.obj poplist.obj &
#
# The environment is assumed to be set up with %Watcom% and %TargetType% (Dos, Nt_V, Nt_Console, Nt_WinConsole).
# The default target is %Model%.Exe.  The compiler debug option is used if %debug%=1.
#
# This generic make file can also be included in a customized make file.
# This is useful when not building a standard %Model%.Exe or when you want several targets at once.
#
# A typical custom make file looks like the following, using Bitpack as an example.
# Note everything has defaults.
#
#  # Important Settings:                         
#  Target       = BitPack            # .exe or .lib base target name, default is %Model%.Exe (no path or extension)
#  TargetDir    = \smart\c\winlibs   # if omitted, default is the .. parent directory for a .exe, or $(LibDir) for a .lib
#  Bitpack_Objs = get.obj put.obj &  # the name MUST MATCH the target name, plus "Objs" as a suffix
#                 poplist.obj        # if omitted, you must have a Bitpack.Mif with: Bitpack_Objs = get.obj put.obj &
#                                    # bug warning - put at least one item after the = and before the & symbol
#                                    # also you must have at least one .mif,.h,.cpp,.hpp,.c,.inc file with name matching the target
#  # Optional Settings:
#  SourceDir    = ..                 # if omitted, default is the .. parent directory
#  LibDir       = d:\Smart\C\Winlibs # if omitted, looks first for %SmartDir% and %TargetType%, then %Lib% in the environment
#  TargetExt    = Lib                # if omitted, default is Exe, or Lib if TargetDir is a lower-case match to LibDir
#  TargetType   = Nt_V               # options are Dos, Nt_V, Nt_Console, Nt_WinConsole, default is environment setting
#                                    # warning - the m.bat utility always uses the %targettype% environment, so it may start in the wrong Obj subdirectory.
#  CPPFlags     = /oi+ /xst          # flags for C++, such as /xst for fast exceptions, default is nothing
#
#  # For additional targets, you need to explicitly list objects in a macro, but no commands are needed (blank line after).
#  Preproc_Objs = Preproc.obj Prepsubs.obj # for implicit rules, the Preproc_Objs name must match the target name plus "_Objs" as a suffix   
#
#  # You also need to list the .Exe or .Lib targets and dependencies, again no commands are needed (put blank line after)
#  \Smart\Smartrun Preproc.Exe : $(Preproc_Objs)
#
#  # The final step is to include the generic make:
#  !include $(%SmartDir)\battool\makefile.mak  # generic processing handles the rest!
#
# Note the implicit rules do assume there is at least one .mak,.mif,.h,.cpp,.hpp,.c,.inc name match,
# such as Preproc.Cpp for Preproc.Exe.
#

# ********************************* Standard Macro Setup **********************************************

# set debug version
!ifndef DEBUG                 # to compile for debug, pass "DEBUG=1" in quotes as an argument, or set it in environment
!  define DEBUG $(%debug)     # null string if no %debug%, can set %debug%=1 or %debug%=True in the environment
!endif

# set the target environment used as a compiler/link flag suffix and as the compiler /bt argument
!ifndef TargetType
TargetType = $(%TargetType)                 # Dos, Nt_V, Nt_Console, Nt_WinConsole
!endif

# set the library directory
!ifndef LibDir                              # the calling make file can set the library path
!  define LibDir $(%smartdir)               # if %smartdir% is not set, LibDir is defined as a zero-length string (Warning - cannot use !ifdef $(%smartdir))
!  ifneq LibDir                             # check for a zero-length string, making sure %smartdir% is set
!     ifeq TargetType Dos                   # set Smart library path from %smartdir% and TargetType
!        define LibDir $(%smartdir)\c\libs
!     else
!        define LibDir $(%smartdir)\c\winlibs
!     endif  
!  else                                     # %smartdir% is not set 
!     define LibDir $(%Lib)
!     ifeq LibDir                           # check for a zero-length string, i.e. %Lib% not set
!        ifeq TargetType Dos
!          define LibDir c:\smart\c\libs    # last resort
!        else
!          define LibDir c:\smart\c\winlibs   
!        endif
!     endif  
!  endif
!endif

# set the target, defaulting to the makefile name or the %Model%, can be preset
!ifndef Target
!  define Target $(%Model)           # file name of the target, without extension
!endif

# define the target directory
!ifndef TargetDir
!  ifdef TargetExt
!     ifeq TargetExt Lib
!        define TargetDir $(LibDir)
!     else
!        define TargetDir ..
!     endif
!  else
!     define TargetDir ..
!  endif
!endif

# define a target extension (warning - with !ifeq or !ifned, CANNOT use $(TargetDir) versus TargetDir on the left, it fails! Can use it on the right. It is case sensitive.)
!ifndef TargetExt
!ifeq TargetDir $(LibDir)
!  define TargetExt Lib              # default target extension is .lib for TargetDir = LibDir
!else                     
!  define TargetExt Exe              # otherwise default target extension is .exe
!endif
!endif

# set the SourceDir to the immediate parent directory unless otherwise specified
!ifndef SourceDir
!  define SourceDir ..
!endif

# set the standard include path to the lib path by default
!ifndef IncDir
IncDir = $(LibDir)
!endif

# read in object list with no (or relative) path in the $(Target).Mif file (e.g., Bitpack.Mif)
# The format is "Bitpack_Objs = get.obj put.obj &" etc., using & for line continuation
# ($(Target)_Objs) = &   # <- would like to directly assign $(Target)_Objs like this, but it does not work
!ifndef $(Target)_Objs
!  include $(SourceDir)\$(Target).mif   # read $(Target)_Objs from a file
!endif

# set the version suffix to indicate debug for CFlags_Deb and LFlags_Deb
Version = Rel          # default is no debug
!ifndef NDebug
!  ifeq Debug True
!     define Version Deb
!  else ifeq Debug 1
!     define Version Deb
!  endif
!endif

# set compiler options
!ifndef CFlags
Compiler     = $(%Watcom)\BinNt\wpp386
!endif
CompilerDll  = $(%Watcom)\BinNt\wppd386  # dll used to reduce load time on repeated calls, must have identical path

!ifndef CFlags
CFlags       = /mf /6r /fp6 /wx /zq /ei
!endif
!ifndef CPPFlags
CPPFlags     = /oi+   # add /xst for exceptions
!endif

CFlags_Dos           = /bt=Dos /zp4
CFlags_Nt_V          = /bg /bt=nt /zp8  # Microsoft says /zp8 for Win32, Watcom says /zp4 for NT, VGUI says /zp2
CFlags_Nt_Console    = /bc /bt=nt /zp8  # standard i/o to console
CFlags_Nt_WinConsole = /bw /bt=nt /zp8  # each stream is its own window

CFlags_Rel    = /oneatx /oh /wcd=726 /ol+   # /ox implies /obiklmr /s, suppress warning 726 for unused variables
CFlags_Deb    = /d2                         # /d2 defaults to /od

!ifeq TargetType Dos
CInclude  = $(%Watcom)\h;$(%Watcom)\h\dos;$(IncDir)
!else
CInclude = $(%Watcom)\h;$(IncDir)\Odbc3;$(%Watcom)\h\nt;$(IncDir)
!ifeq TargetType Nt_V
CInclude+=;$(incDir)\V
!endif
!endif

# set linker options
Linker        = $(%Watcom)\BinNt\wlink

!ifndef LFlags
LFlags        = option stack=512K,CaseExact,MaxErrors=50           # could add: OPTION SYMFILE,MAP
!endif

LFlags_Rel    = # none for now
LFlags_Deb    = Debug All

LSys_Dos  = System dos4g &
               LibPath $(LibDir);$(%Watcom)\lib386;$(%Watcom)\lib386\dos &
               Library Bitpack,WatWind,WatTbl,Copia
LSys_Nt_V = System nt_win &
               LibPath $(LibDir);$(LibDir)\Odbc3;$(%Watcom)\lib386\nt;$(%Watcom)\lib386 &
               Library Smart,Bitpack,SmartWin,VLib,OdbcTbl,Odbc32,ComCtl32
LSys_Nt_Console  = System nt &
               LibPath $(LibDir);$(LibDir)\Odbc3;$(%Watcom)\lib386\nt;$(%Watcom)\lib386 &
               Library Smart,Bitpack,OdbcTbl,Odbc32
LSys_Nt_WinConsole = $(LSys_Nt_Console)

# define library dependencies
LibDep_Dos   = $(LibDir)\Bitpack.lib $(LibDir)\WatWind.lib $(LibDir)\WatTbl.lib
LibDep_Nt_V  = $(LibDir)\Bitpack.lib $(LibDir)\Smart.lib $(LibDir)\SmartWin.lib $(LibDir)\VLib.lib $(LibDir)\OdbcTbl.lib
LibDep_Nt_Console = $(LibDir)\Bitpack.lib $(LibDir)\Smart.lib $(LibDir)\OdbcTbl.lib
LibDep_Nt_WinConsole = $(LibDep_Nt_Console)

# set Library options
LibProg       = $(%Watcom)\BinNt\wlib
LibFlags     = -b -n -c -p=512 

# extensions for implicit rules: (.cpp,.h,.c,.inc) -> (.obj) -> (.Lst) -> (.Lib) -> (.Exe)
.extensions: # clear the Watcom defaults
.extensions: .exe .lib .mak .mif .obj .cpp .c .h .inc .hpp # set up priority of source extensions for implicit rules such as .c.obj
.optimize                 # permit wmake to re-try same directory first
.hold                     # eliminate annoying prompts about whether to delete failed targets

# ********************** dependencies for the final Target Library or Executable **********************************

# These generic dependencies are pre-defined for a single primary target name
# Any other targets and dependencies must be set by the calling make file.
# Note that .h, .hpp, .inc dependencies need not be added, they are tracked in the .obj

# define a shorthand using the base file name as a symbolic target (default make target)
# I no longer use this.  Note -- it causes .Before and .After to always be executed, but I have removed .Before and .After
#$(Target) : $(TargetDir)\$(Target).$(TargetExt) .SYMBOLIC   #.SYMBOLIC indicates that $(Target) is not a physical target file
#    %null

# The .Exe or .Lib target depends on the objects, listed first so as to be the default.
# A .Exe also depends on its own library containing objects
# The .h files are not needed here, they are tracked in the .obj via .AutoDepend
# Note .Exe depends on $(LibDep.., so need to have libraries updated compared with their .h files or implicit rules may try to rebuild the libs

!ifeq TargetExt Exe

$(TargetDir)\$(Target).$(TargetExt) : $(Target).Lib $($(Target)_Objs) $(LibDep_$(TargetType))

$(Target).Lib : $($(Target)_Objs)   # note this .Lib is local with objects, not in TargetDir

!else

$(TargetDir)\$(Target).Lib : $($(Target)_Objs) 

!endif

# ************************ implicit rules to build executables ***********************************

# Implicit rules are defined so a calling make file can define multiple .Exe/.Lib targets.
# The calling program must declare the target .Exe/.Lib dependencies, but no commands are needed.
# For the single input $(Target) file, even the dependencies are pre-defined automatically above.

# The basic flow is:  (.cpp,.h,.c,.inc) -> (.obj) -> (.Lst) -> (.Lib) -> (.Exe)

# By first creating a lib then an exe, we do not need a special object link file.
# This problem would go away if we could just use spaces to separate file names for the linker.
# Or, we could convert spaces to commas using %append, but using the library is more elegant and faster.
.lib.exe
   $(Linker) $(LFlags) $(LFlags_$(Version)) Name $^@ File $[@ $(LSys_$(TargetType)) >>link.err
   type link.err
   @echo.
   @echo Build target for $(TargetType): $^@
   @echo.

# ************************ implicit rules to build libraries ***********************************

# This assumes at least one matching file name among .mak,.mif,.h,.cpp,.c,.inc,.hpp files

.mak: $(SourceDir)\;..\    # parent directory is included in case SourceDir is somewhere else
.mak.lib :   # .AutoDepend is not enough, I need explicit dependencies for .lib to add new .objs (does AutoDepend even work for libs?)
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.mif: $(SourceDir)\;..\    # parent directory is included in case SourceDir is somewhere else
.mif.lib :   # .AutoDepend is not enough, I need explicit dependencies for .lib to add new .objs (does AutoDepend even work for libs?)
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.h: $(SourceDir)\;$(IncDir)\
.h.lib
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.cpp: $(SourceDir)\
.cpp.lib             
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.c: $(SourceDir)\
.c.lib             
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.inc: $(SourceDir)\;$(IncDir)\
.inc.lib
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

.hpp: $(SourceDir)\;$(IncDir)\
.hpp.lib
   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)

#.Default        # default operation if the implicit rules fail, does not work?
#   $(LibProg) $(LibFlags)  $^@  $($^&_Objs)
   
# ************* implicit rules to build .obj files using .AutoDepend to track include files ***************

!ifdef __LOADDLL__         # Watcom compiler speedup to load a Dll for repeated compiles
!  loaddll $(Compiler) $(CompilerDll)
!endif

# Implicit rule that each .obj file depends on a matching .cpp or .c file
# This applies when a target .obj has explicit rules with no commands, or no explicit rules at all
# Note an implicit rule is ignored if no matching source file is found
# The .AutoDepend stores the .h file and .inc dependencies in the .obj file itself

.cpp: $(SourceDir)\
.cpp.obj :  #.AutoDepend
   $(Compiler) $[@ $(CFLAGS_$(Version)) $(Cflags) $(Cflags_$(TargetType)) $(CPPFlags) /i=$(CInclude) # recompile the .cpp to create the .obj

.c: $(SourceDir)\
.c.obj   :  #.AutoDepend
   $(Compiler) $[@ $(CFlags_$(Version)) $(Cflags) $(Cflags_$(TargetType)) /i=$(CInclude) # recompile the .c to create the .obj
