//	vdbcmdw.h:	Header for vdbCmdw class
//=======================================================================

#ifndef vdbCmdW_H
#define vdbCmdW_H

#include <v/vcmdwin.h>	// So we can use vCmdWindow
#include <v/vmenu.h>	// For the menu pane
#include <v/vutil.h>	// For V Utilities
#include <v/vcmdpane.h> // command pane
#include <v/vstatusp.h>	// For the status pane
#include <v/vfont.h>
#include <v/vtimer.h>	// timer

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

//#include "vdbcnv.h"	// vdbTextEditor
#include <v/vtexted.h>	// standard text editor window

    class vdbCmdWindow;

    class dbAuxTimer : public vTimer
      {
      public:		//---------------------------------------- public
	dbAuxTimer(vdbCmdWindow* cw) { cmdw = cw; }
	~dbAuxTimer() {}
	virtual void TimerTick();
      private:		//--------------------------------------- private
	vdbCmdWindow* cmdw;
      };

    class vdbCmdWindow : public vCmdWindow
      {
	friend int AppMain(int, char**);	// allow AppMain access

      public:		//---------------------------------------- public
	vdbCmdWindow(char*, int, int);
	virtual ~vdbCmdWindow();
	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);
	virtual void KeyIn(vKey keysym, unsigned int shift);
	void ChangeLoc(long line, int col);
	void StatusMessage(char* msg);

	dbAuxTimer* getDbAuxTimer() { return auxTimer; }
	bool OpenGDB(const char* exe);
	videCmdWindow* GotoDebugLine(char* info);

        void dbSendCmd(char* cmd, int echo = 1);
        bool dbShowOut(bool atBottom = false);
	void debugCmd(videCmdWindow* win, ItemVal id);

      protected:	//--------------------------------------- protected

        void breakCmd(videCmdWindow* win, char* bcmd);

      private:		//--------------------------------------- private

	// Standard elements
//	vdbTextEditor* vdbCanvas;		// For the canvas
	vTextEditor* vdbCanvas;		// For the canvas
//	vdbCI* vdbCmdI;

	vMenuPane* vdbMenu;		// For the menu bar
	vCommandPane* vdbCmdPane;	// for the command pane
	vStatusPane* vdbStatus;		// For the status bar
	vFont vdbFont;
	dbAuxTimer* auxTimer;		// aux timer

	// Dialogs associated with CmdWindow

	// Stuff to interface to gdb
        char dbCmd[256];
        char* dbCmdPtr;

#ifdef V_VersionWindows
	HANDLE dbProcessHandle;
	DWORD dbProcessId;
	HANDLE hChildStdinRd, hChildStdinWr, hChildStdinWrDup, 
	  hChildStdoutRd, hChildStdoutWr, 
	  hInputFile, hSaveStdin, hSaveStdout; 
#endif
#ifdef V_VersionX
	long dbProcessHandle;
	long dbProcessId;
	long hChildStdinRd, hChildStdinWr, hChildStdinWrDup, 
	  hChildStdoutRd, hChildStdoutWr, 
	  hInputFile, hSaveStdin, hSaveStdout; 
#endif

      };
#endif
