/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

/* This file sets things up for C dynamic library function definitions,
   static inlined functions, and structures aligned at 4-byte alignment.
   If you don't like ugly C preprocessor code, don't look at this file. :)
*/

/* This shouldn't be nested -- included it around code only. */
#ifdef _begin_code_h
#error Nested inclusion of begin_code.h
#endif
#define _begin_code_h

/* This header "does the right thing" when declaring SDL functions */
#ifndef SDL_DEFUN

/* There are four different cases:
	1.  Building the dynamic version of the library
		define functions with underscore
	2.  Building an application with dynamic library
		define functions as pointers to variables
	3.  Building the static version of the library
		define functions normally
	4.  Building an application with static library
		define functions normally
*/

/* Default to building a dynamic library */
# ifndef _SDL_STATIC_LIB
#  define _SDL_DYNAMIC_LIB
# endif

/* Some compilers use a special export keyword */
# ifdef __BEOS__
#  if defined(__GNUC__)
#   define DECLSPEC	__declspec(dllexport)
#  else
#   define DECLSPEC	__declspec(export)
#  endif
# else
#  define DECLSPEC
# endif

# ifdef _SDL_DYNAMIC_LIB

#  ifdef _BUILDING_SDL	/* -- Building dynamic library */
#   define SDL_DEFUN(type, name, args)    extern DECLSPEC type _##name args;
#  else			/* -- Building application with dynamic library */
#   define SDL_DEFUN(type, name, args)    extern          type (*name) args;
#  endif /* _BUILDING_SDL */

# else

#  ifdef _BUILDING_SDL	/* -- Building static library */
#   define SDL_DEFUN(type, name, args)    extern          type name args;
#  else 		/* -- Building application with static library */
#   define SDL_DEFUN(type, name, args)    extern          type name args;
#  endif /* _BUILDING_SDL */

# endif /* _SDL_DYNAMIC_LIB */

#endif /* ! _SDL_DEFUN */


/* Force structure packing at 4 byte alignment on VC++
   This is necessary if the header is included in code which has structure
   packing set to an alternate value, say for loading structures from disk.
   The packing is reset to the previous value in close_code.h
 */
#ifdef _MSC_VER
#pragma warning(disable: 4103)
#pragma pack(push,4)
#endif

/* Set up compiler-specific options for inlining functions */
#ifndef SDL_INLINE_OKAY
#ifdef __GNUC__
#define SDL_INLINE_OKAY
#else
/* Add any special compiler-specific cases here */
#if !defined(_MSC_VER) && !defined(__MRC__) && !defined(_SGI_SOURCE)
#define __inline__ inline
#define SDL_INLINE_OKAY
#endif /* Not a funky compiler */
#endif /* GNU C */
#endif /* SDL_INLINE_OKAY */

/* If inlining isn't supported, remove "__inline__", turning static
   inlined functions into static functions (resulting in code bloat
   in all files which include the offending header files)
*/
#ifndef SDL_INLINE_OKAY
#define __inline__
#endif

/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif
