/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_thread.h,v 1.6 1999/03/29 09:49:31 slouken Exp $";
#endif

#ifndef _SDL_thread_h
#define _SDL_thread_h

/* Header for the SDL thread management routines 

	These are independent of the other SDL routines.
*/

#include "SDL_mangle.h"
#include "SDL_types.h"

#include "begin_code.h"

/* The SDL thread structure, defined in SDL_thread.c */
struct SDL_Thread;
typedef struct SDL_Thread SDL_Thread;

/* Create a thread */
SDL_DEFUN(SDL_Thread *, SDL_CreateThread, (int (*fn)(void *), void *data))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_CreateThread _SDL_CreateThread
#endif
/**/

/* Get the 32-bit thread identifier for the current thread */
SDL_DEFUN(Uint32, SDL_ThreadID, (void))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_ThreadID _SDL_ThreadID
#endif
/**/

/* Wait for a thread to finish.
   The return code for the thread function is placed in the area
   pointed to by 'status', if 'status' is not NULL.
 */
SDL_DEFUN(void, SDL_WaitThread, (SDL_Thread *thread, int *status))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_WaitThread _SDL_WaitThread
#endif
/**/

/* Forcefully kill a thread without worrying about its state */
SDL_DEFUN(void, SDL_KillThread, (SDL_Thread *thread))
/**/
#if defined(_SDL_DYNAMIC_LIB) && defined(_BUILDING_SDL)
# define SDL_KillThread _SDL_KillThread
#endif
/**/

#include "close_code.h"

#endif /* _SDL_thread_h */
