#!/bin/sh
#
# A script to convert a series of icons into a linkable object file for
# your application.

AbortUsage()
{
	echo "Usage: $0 [-transparent] appname icon.bmp [icon.bmp] ..."
	exit 1
}

if [ "$1" = "-transparent" ]; then
	transparent=$1
	shift
fi
if [ $# -lt 2 ]; then
	AbortUsage
fi
case $1 in
	*.bmp)	AbortUsage
		;;
	*.BMP)	AbortUsage
		;;
esac
app=$1
shift
bmp=$*
bmp2ico $transparent $app.ico $bmp
if [ $? -ne 0 ]; then
	echo "Couldn't run bmp2ico -- aborting"
	exit 2
fi
echo "$app ICON $app.ico" | windres -o ico.o
if [ $? -eq 0 ]; then
	echo "You should link your app with \"ico.o\""
	status=0
else
	echo "Couldn't run windres -- aborting"
	status=2
fi
rm -f $app.ico
exit $status
