/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * preload.h --- types, codes and macros for initial symbol table load
 * (duz 09Jul93)
 */

#ifndef __CONFIG_H
#include "config.h"
#endif

#ifndef __MACROS_H
#include "macros.h"
#endif

typedef struct			/* describe a word for registration */
{				/* in the dictionary */
  const char *name;		/* name of word */
  pCode ptr;			/* code it executes or something */
}				/* according to spc@pineal.math.fau.edu: */
Word;				/* 'void *' doesn't work here on SGI */

typedef struct			/* describes the set of words */
{				/* a module loads into the dictionary */
  int n;			/* how many words? */
  const Word *w;		/* pointer to vector of words */
#if defined DEBUG
  const char *name;		/* name of word set */
#endif
}
Words;

typedef struct			/* list of word sets to load into */
{				/* a word list */
  int n;			/* how many word lists? */
  const Words *const *ws;	/* pointer to vector of word sets */
  Wordl *wid;			/* pointer to word list */
}
preloadList;

extern preloadList only_list;
extern preloadList forth_list;
extern preloadList extensions_list;
extern const preloadList *preload_list [];
extern const int preload_lists;


#define LISTWORDS(SET)	static const Word APPEND (SET,_word) []

#if defined DEBUG

#define COUNTWORDS(SET,NAME)			\
const Words APPEND (SET,_words) =		\
{						\
  DIM (APPEND (SET,_word)),			\
  APPEND (SET,_word),				\
  NAME						\
}

#else

#define COUNTWORDS(SET,NAME)			\
const Words APPEND (SET,_words) =		\
{						\
  DIM (APPEND (SET,_word)),			\
  APPEND (SET,_word)				\
}

#endif

/* Encoding the kind of definition i.e. which runtime to fill into the cfa. */
/* Octal 1XY, where X&1 means "immediate" */

#define _CO 0100	/* code definition */
#define _CI 0110	/* immediate code definition */
#define _CS 0130	/* immediate state smart words */

#define _SV 0101	/* system variable */
#define _SC 0102	/* system constant */

#define _DV 0103	/* dictionary related system variable */
#define _DC 0104	/* dictionary related system constant */

#define _OV 0105	/* ordinary variable */
#define _OC 0106	/* ordinary constant */
#define _OL 0107	/* ordinary value */

#define _IV 0115	/* immediate variable */
#define _IC 0116	/* immediate constant */
#define _IL 0117	/* immediate value */

#define _VO 0120	/* vocabulary */
#define _OY 0121	/* the special only vocabulary */

/* macros to build entries in the wordlists: */

#define	CO(NM,PCODE)	{ "\100"NM, APPEND (PCODE,_) }
#define	CI(NM,PCODE)	{ "\110"NM, APPEND (PCODE,_) }
#define CS(NM,SEM)	{ "\130"NM, (pCode)&APPEND(SEM,_semantics) }

#define	SV(NM,VAR)	{ "\101"NM, (pCode)&(VAR) }
#define	SC(NM,VAR)	{ "\102"NM, (pCode)&(VAR) }

#if __IBMC__ && __OS2__	/* IBM C Set/2 thinks OFFSET_OF is no constant expr */
#define	DV(NM,MEMBER)	{ "\103"NM, (pCode)do_##MEMBER }
#define	DC(NM,MEMBER)	{ "\104"NM, (pCode)do_##MEMBER }
#else
#define	DV(NM,MEMBER)	{ "\103"NM, (pCode)OFFSET_OF(Dict, MEMBER) }
#define	DC(NM,MEMBER)	{ "\104"NM, (pCode)OFFSET_OF(Dict, MEMBER) }
#endif

#define OV(NM)		{ "\105"NM, (pCode)0) }
#define	OC(NM,VAL)	{ "\106"NM, (pCode)(VAL) }
#define OL(NM,VAL)	{ "\107"NM, (pCode)(VAL) }

#define IV(NM)		{ "\115"NM, (pCode)0) }
#define	IC(NM,VAL)	{ "\116"NM, (pCode)(VAL) }
#define IL(NM,VAL)	{ "\117"NM, (pCode)(VAL) }

#define	VO(NM,LIST)	{ "\120"NM, (pCode)(LIST) }
#define	OY(NM,LIST)	{ "\121"NM, (pCode)(LIST) }
