#
# default/depend.mk ---	Part of Makefile for PFE: dependencies.
#

DEFINES =	$(d)PREFIX=$(PREFIX) $(d)PFELIB=$(PFELIB) $(d)PFEHLP=$(PFEHLP)

# if you want a final optimized version uncomment these lines:
CFLAGS =	$(OPTIONS) $(OPTIM) $(DEFINES)
LDFLAGS =	$(STRIP) $(LFLAGS)

# if you want a version for C-level debugging uncomment these lines:
#CFLAGS =	$(OPTIONS) $(DEBUG) $(DEFINES)
#LDFLAGS =	$(DEBUG) $(LFLAGS)


# object files that should be clean ANSI-C:
ANSOBJ =	core$o block$o double$o xception$o facility$o file$o \
		floating$o locals$o memory$o toolkit$o search$o string$o \
		forth-83$o lpf83$o misc$o showhelp$o debug$o dblsub$o \
		filesub$o support$o dictnry$o vocs$o lined$o term$o

# object files containing environmental dependencies:
ENVOBJ =	main$o $(TERM_O) 4ed$o signals$o sysdep$o $(SYS_O) shell$o \
		yours$o

OBJECTS =	$(ANSOBJ) $(ENVOBJ)

HEADERS =	forth.h config.h virtual.h options.h const.h types.h macros.h \
		support.h preload.h compiler.h dblsub.h term.h help.h lined.h


all:		pfe$e helpidx$e showhelp$e


pfe$e:		$(OBJECTS) version$o
		$(CL) $(LDFLAGS) $(eo)pfe$e $(OBJECTS) version$o $(LIBS)

$(OBJECTS):	$(HEADERS)
$(ENVOBJ):	$(HEADERS) nonansi.h

version$o:	$(OBJECTS)

clean:
		$(RM) pfe$e helpidx$e showhelp$e *$o $(TRASH)

new:		clean all

veryclean:	clean
		$(RM) config.h Makefile

testit:		pfe$e
		( cd ..$(x)test; .$(x)do-tests )


# Rules for the standalone help programs:

helpidx$e:	helpidx$o helpsub$o
		$(CL) $(LDFLAGS) $(eo)helpidx$e helpidx$o helpsub$o

showhelp$e:	showhlps$o helpsub$o
		$(CL) $(LDFLAGS) $(eo)showhelp$e showhlps$o helpsub$o

showhlps$o:	showhelp.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c showhelp.c $(oo)showhlps$o

helpidx$o:	helpidx.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c helpidx.c $(oo)helpidx$o

helpsub$o:	helpsub.c $(HEADERS)
		$(CC) $(CFLAGS) $(d)STANDALONE -c helpsub.c $(oo)helpsub$o

install:	all
		if [ ! -d $(PFELIB) ]; then $(MD) $(PFELIB); fi		;\
		if [ ! -d $(PFEHLP) ]; then $(MD) $(PFEHLP); fi		;\
		$(CP) helpidx$e showhelp$e ..$(x)help$(x)*.hlp $(PFEHLP);\
		cd $(PFEHLP)						;\
		.$(x)helpidx$e -o $(PFEHLP)$(x)index *.hlp
