// areafile.cpp
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "areafile.h"

#include <stdlib.h>
#include <ctype.h>

#include <string.h>
#include <stdio.h>

#define BUFFER_SIZE    300

RAreaFile::RAreaFile(char *name)
{
    areaList = NULL;
    areaCount = 0;
    if (!name)
        name = "stsec.dat";
    RAreaFile::open(name);
        
}

RAreaFile::~RAreaFile()
{
    // Deallocate all areas from the area list.
    while (areaList != NULL)
    {
        areaInfo *nextArea = areaList->next;
        delete areaList->smallArea;
        delete areaList->bigArea;
        delete areaList;
        areaList = nextArea;
    }
}        

boolean RAreaFile::open(char *name, int mode)
{
#ifdef LINUX
    if (!RFile::open(name, mode))
        return FALSE;
#else
    // State ios::binary again just in case user does not.
    if (!RFile::open(name, mode | ios::binary))
        return FALSE;
#endif

    if (!RAreaFile::ProcessAreaFile())
    {
        RFile::close();
        return FALSE;
    }
    return TRUE;
}

boolean RAreaFile::ProcessAreaFile()
{
    char buffer[BUFFER_SIZE];
    char bigArea[BUFFER_SIZE];
    char *smallArea;
    
    char *tempPtr;
    char *semicolonPtr;
    
    RFile::getString(buffer, BUFFER_SIZE);
    while (!RFile::eof())
    {
        if ((tempPtr = strstr(buffer, "\r")) != NULL)
            *tempPtr = (char)NULL;
        semicolonPtr = strstr(buffer, ";");

        strcpy(bigArea, strtok(buffer, ":"));      // Get state name (or big area)
            
        while ((smallArea = strtok(NULL, " ,;")) != NULL)
            if ((semicolonPtr == NULL ) || (smallArea < semicolonPtr))
                AddAreaToList(smallArea, bigArea);
            
        RFile::getString(buffer, BUFFER_SIZE);
    }

    return TRUE;
}

boolean RAreaFile::AddAreaToList(char *smallArea, char *bigArea)
{
    areaInfo *listPtr = areaList;
    
    if (areaList == NULL)
    {
        areaList = new areaInfo;
        areaList->smallArea = new char[strlen(smallArea) + 1];
        strcpy(areaList->smallArea, smallArea);
        areaList->bigArea = new char[strlen(bigArea) + 1];
        strcpy(areaList->bigArea, bigArea);
        areaList->next = NULL;
    }
    else
    {
        areaInfo *newPtr;
        
        while (listPtr->next != NULL)
            listPtr = listPtr->next;

        newPtr = new areaInfo;
        newPtr->smallArea = new char[strlen(smallArea) + 1];
        strcpy(newPtr->smallArea, smallArea);
        newPtr->bigArea = new char[strlen(bigArea) + 1];
        strcpy(newPtr->bigArea, bigArea);
        newPtr->next = NULL;

        listPtr->next = newPtr;
    }
            
    return TRUE;
}

boolean RAreaFile::GetInfo(const char *smallArea, char *bigArea)
{
    areaInfo *areaListPtr;

    areaListPtr = areaList;
    while ((areaListPtr != NULL) && (stricmp(smallArea, areaListPtr->smallArea) != 0))
        areaListPtr = areaListPtr->next;
    if (areaListPtr == NULL)
        return FALSE;
    else
        strcpy(bigArea, areaListPtr->bigArea);
            
    return TRUE;

}
    
