// adiffile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _ADIFFILE_H_
#define _ADIFFILE_H_

#include "qsofile.h"
#include "ctyfile.h"
#include "areafile.h"

#define ADIF_CALL      1
#define ADIF_QSO_DATE  2
#define ADIF_TIME_ON   3
#define ADIF_TIME_OFF  4
#define ADIF_FREQ      5
#define ADIF_BAND      6
#define ADIF_MODE      7
#define ADIF_TX_PWR    8
#define ADIF_RST_SENT  9
#define ADIF_RST_RCVD  10
#define ADIF_QSL_SENT  11
#define ADIF_QSL_RCVD  12
#define ADIF_NAME      13
#define ADIF_QTH       14
#define ADIF_STATE     15
#define ADIF_COMMENT   16
#define ADIF_CONTEST_ID 17
#define ADIF_SERIAL_SENT 18
#define ADIF_SERIAL_RCVD 19
#define ADIF_PRECEDENCE  20
#define ADIF_CHECK       21
#define ADIF_SECTION     22
#define ADIF_RCVD_PWR    23
#define ADIF_CQ_ZONE     24
#define ADIF_ITU_ZONE    25
#define ADIF_GRID        26
#define ADIF_IOTA        27
#define ADIF_TX_COUNT    28
#define ADIF_CATEGORY    29
#define ADIF_AGE         30
#define ADIF_10_10_NUM   31
#define ADIF_ARCI_NUMBER 32
#define ADIF_PREFECTURE  33
#define ADIF_RCV         34          // Non-standard WriteLog extension

#define BUFFER_SIZE    4096

class RAdifFile : public RQsoFile {

    boolean endOfRecord;
    char buffer[BUFFER_SIZE];
    
    boolean getFieldName(char *, int *, int *);
    int numOfDigits(long);

    void writeGeneralInfo(qso_data *, char *);
    void appendField(char *, char *);

    RCtyFile ctyfile;
    RAreaFile *areaFile;
    
public:
    static char *fieldName[];

    RAdifFile()                   {ctyfile.open("cqww.cty"); location = 0;};
    RAdifFile(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
//    virtual qso_data nextQso();                  /* Return next generic QSO record */
    virtual boolean nextQso(qso_data *);
//    virtual boolean writeQso(qso_data);          /* Write a generic QSO record */
    virtual boolean writeQso(qso_data *);
    virtual boolean writeHeader(header_data);

};

#endif
