/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// this file adapted from an -lgtkglmm demo by 
// Karl Nelson <kenelson@ece.ucdavis.edu>


#include "TFWindowOpenGL.h" 
#include <iostream.h>



/*
 * TFWindowOpenGL::TFWindowOpenGL
 *  Creates the main window and all of its widgets in a 
 *  bottom approach.  (I just find the style more readable
 *  than top down.)  View the file layout.ps for a description
 *  of the widget relations.
 */
TFWindowOpenGL::TFWindowOpenGL(HeightField *HF) 
	       : Gtk_Window(GTK_WINDOW_TOPLEVEL)
	{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFWindowOpenGL::TFWindowOpenGL");

	char	buf[80];
	sprintf (buf, "OpenGL preview: %s", HF->getName());
	set_title(buf);

	if (HF->getWidth() > 100)
		this->set_usize(HF->getWidth()+10, HF->getHeight()+10);
	else
		this->set_usize(120, 120);
 
	// Create the OpenGL object (the whole point of this exercise) 
	display = new TFOpenGLArea(HF);
	if (HF->getWidth () > 100)
		display->set_usize(HF->getWidth(), HF->getHeight());
	else
		display->set_usize(120, 120);
	display->show();

	// Gtk_GLArea can't have a border, so we will stick it in a frame
	frame = new Gtk_Frame();
	frame->set_shadow_type (GTK_SHADOW_IN);
	frame->set_border_width(5);  
	frame->add(display);   
	frame->show();

	// Create a Quit button
	//button_cube = new Gtk_ToggleButton("Cube");
	//button_cube->set_usize(100,50);
	//button_cube->set_border_width(5);
	//button_cube->show();

	//button_sphere = new Gtk_ToggleButton("Sphere");
	//button_sphere->set_usize(100,50);
	//button_sphere->set_border_width(5);
	//button_sphere->show();

	//button_cylinder = new Gtk_ToggleButton("Cylinder");
	//button_cylinder->set_usize(100,50);
	//button_cylinder->set_border_width(5);
	//button_cylinder->show();

	// Create a Quit button
	//button = new Gtk_Button("Quit");
	//button->set_usize(100,50);
	//button->set_border_width(10);
	//button->show();

	// Place the Scrollbars and Button in a Table
	// I was using attach_defaults, but it is better if just the scrollbars 
	// grow, to fill the space.
	table = new Gtk_Table(2,4,FALSE);
	table->attach(*frame,0,1,0,4,GTK_EXPAND|GTK_FILL);
	//table->attach(*button_cube,1,2,0,1,GTK_SHRINK);
	//table->attach(*button_sphere,1,2,1,2,GTK_SHRINK);
	//table->attach(*button_cylinder,1,2,2,3,GTK_SHRINK);
	//table->attach(*button,1,2,3,4,GTK_SHRINK,GTK_SHRINK,0,0);
	//table->set_col_spacing(0,10);
	//table->set_row_spacing(2,10);
	//table->set_border_width(10);
	table->show();

	// Add the box to the mainwindow
	add(table);

	// Connect the Quit button to the application quit
	//connect_to_method(button->clicked,app,&Gtk_Main::quit);

	// Connect buttons to the OpenGL object
	//connect_to_method(button_cube->toggled,display,
        //             &TFOpenGLArea::toggle_cube,button_cube);
	//connect_to_method(button_sphere->toggled,display,
        //             &TFOpenGLArea::toggle_sphere,button_sphere);
	//connect_to_method(button_cylinder->toggled,display,
        //             &TFOpenGLArea::toggle_cylinder,button_cylinder);
 
	// Connect the OpenGL object back to the buttons 
	//connect_to_method(display->set_cube,button_cube,
        //             &Gtk_ToggleButton::set_active);
	//connect_to_method(display->set_sphere,button_sphere,
        //             &Gtk_ToggleButton::set_active);
	//connect_to_method(display->set_cylinder,button_cylinder,
        //             &Gtk_ToggleButton::set_active);
}


TFWindowOpenGL::~TFWindowOpenGL(void)
{
	delete button;
	delete button_cube;
	delete button_sphere;
	delete button_cylinder;
	delete frame;
	delete table;
	delete display;
};


/*
 * Main
 */ 

/*
gint main(gint argc, gchar **argv)
{
	TFWindowOpenGL *main_window;
  
	app = new Gtk_Main(&argc,&argv);

	main_window = new TFWindowOpenGL;
	main_window->show();
  
	app->run();

	return(0);
}

*/
