/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdlib.h>
#include "TFDialogRoughSmooth.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogRoughSmooth::TFDialogRoughSmooth (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Roughen/Smooth Dialog", 
					"Roughen/Smooth Parameters", 6, 4),
		  d_vbList (TRUE, 5),
		  d_hbMode (TRUE, 5),
		  d_hbRSFactor (TRUE, 5),
		  d_hbBigGrid (TRUE, 5),
		  d_adjRSFactor (0.5, 0, 1, 0.01),
		  d_hsRSFactor (d_adjRSFactor),
		  d_lblMode (_("Mode")),
		  d_lblRSFactor (_("Adjustment Factor")),
		  d_lblBigGrid (_("Big Sampling Grid")),
		  d_frmOptions (_("Roughen/Smooth Options"))
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogRoughSmooth\n");

	p_rbModeR = p_rbModeS = NULL;
	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Roughen/Smooth: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (p_rbModeR->clicked, this, &TFDialogRoughSmooth::updatePreviewCallback);
	connect_to_method (p_rbModeS->clicked, this, &TFDialogRoughSmooth::updatePreviewCallback);
	connect_to_method (d_adjRSFactor.value_changed, this, &TFDialogRoughSmooth::updatePreviewCallback);
	connect_to_method (d_btnBigGrid.clicked, this, &TFDialogRoughSmooth::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogRoughSmooth::~TFDialogRoughSmooth ()
{
	if (p_rbModeR)
		delete p_rbModeR;
	if (p_rbModeS)
		delete p_rbModeS;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogRoughSmooth\n");
}


/*
 *  insertOptions: add the actual dialog options 
 */
void TFDialogRoughSmooth::insertOptions ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogRoughSmooth called without Frame label",
		"TFDialogRoughSmooth::insertOptions");

	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	p_rbModeR = new Gtk_RadioButton ((GSList *)NULL, "Roughen");
	p_rbModeR->set_active (FALSE);
	d_hbMode.pack_start (*p_rbModeR, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_rbModeR->show ();
	p_group = p_rbModeR->group ();
	p_rbModeS = new Gtk_RadioButton (p_group, "Smooth");
	p_rbModeS->set_active (TRUE);
	d_hbMode.pack_end (*p_rbModeS, TRUE, TRUE, 2);
	p_rbModeS->show ();
	d_vbList.pack_start (d_hbMode, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbMode.show ();

	d_hbRSFactor.pack_start (d_lblRSFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblRSFactor.show ();
	d_hsRSFactor.set_update_policy (GTK_UPDATE_CONTINUOUS);
	d_hsRSFactor.set_digits (2);
	d_hsRSFactor.set_draw_value (TRUE);
	d_hbRSFactor.pack_end (d_hsRSFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_hsRSFactor.show ();
	d_vbList.pack_start (d_hbRSFactor, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbRSFactor.show ();

	d_hbBigGrid.pack_start (d_lblBigGrid, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_lblBigGrid.show ();
	d_btnBigGrid.set_active (FALSE);
	d_hbBigGrid.pack_end (d_btnBigGrid, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnBigGrid.show ();
	d_vbList.pack_start (d_hbBigGrid, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbBigGrid.show ();

	d_frmOptions.add (d_vbList);	
	this->p_tblMain->attach (d_frmOptions, 3, 4, 1, 3);
	d_vbList.show ();
	d_frmOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}



void TFDialogRoughSmooth::buildDialogWindow ()
{
	this->set_usize (450, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();
	
	this->show ();
}


/*
 *  buttonCallbackApply: transform the height field
 */
void TFDialogRoughSmooth::buttonCallbackApply ()
{
	bool		roughen = p_rbModeR->get_active (),
			bigGrid = d_btnBigGrid.get_active (); 
	float		value = d_adjRSFactor.get_value (); 

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogRoughSmooth::buttonCallbackApply");

	p_HFO->roughSmooth (roughen, bigGrid, value);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a widget has been changed
 */
void TFDialogRoughSmooth::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	bool		roughen = p_rbModeR->get_active (),
			bigGrid = d_btnBigGrid.get_active (); 
	float		value = d_adjRSFactor.get_value (); 

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogRoughSmooth::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogRoughSmooth::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogRoughSmooth::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->roughSmooth (roughen, bigGrid, value);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}
