/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogRescale.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogRescale::TFDialogRescale (HeightField *HF, HeightFieldDraw *HFD)
	        : TFBaseDialog (HF, HFD, "Terraform Rescale Dialog", 
				"Operation"),
		  d_hbFLocal (TRUE, 5),
		  d_hbFGlobal (TRUE, 5),
		  d_adjFLocal (0, 0, 1, 0.01), 
		  d_adjFGlobal (1, 0, 1, 0.01), 
		  d_hsFLocal (d_adjFLocal),
		  d_hsFGlobal (d_adjFGlobal),
		  d_lblFLocal (_("Local fractal scaling")),
		  d_lblFGlobal (_("Glocal fractal scaling"))
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogRescale\n");

	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Rescale: %s"), p_HF->getName());
	p_RB1 = p_RB2 = NULL;
	p_group = NULL;
	buildDialogWindow ();
}


/*
 *  destructor: clean up 
 */
TFDialogRescale::~TFDialogRescale ()
{
	if (p_RB1) delete p_RB1;
	if (p_RB2) delete p_RB2;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogRescale\n");
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogRescale::fillVBox ()
{
	SanityCheck::bailout ((!this->p_frmBase), "TFDialogRescale called without Frame label", 
		"TFDialogRescale::setHFobjs");

	p_RB1 = new Gtk_RadioButton ((GSList *)NULL, "Half Size");
	connect_to_method (p_RB1->clicked, this, &TFDialogRescale::rbCallback);
	p_RB1->set_active (FALSE);
	this->d_vbOptions.pack_start (*p_RB1, TRUE, TRUE, s_VBOff);
	p_RB1->show ();

	p_group = p_RB1->group ();
	p_RB2 = new Gtk_RadioButton (p_group, "Double Size");
	p_RB2->set_active (TRUE);
	connect_to_method (p_RB2->clicked, this, &TFDialogRescale::rbCallback);
	this->d_vbOptions.pack_start (*p_RB2, TRUE, TRUE, s_VBOff);
	p_RB2->show ();

	d_hbFLocal.pack_start (d_lblFLocal, TRUE, TRUE, s_HBOff);
	d_lblFLocal.show ();
	d_hsFGlobal.set_digits (2);
	d_hsFGlobal.set_draw_value (TRUE);
	d_hbFLocal.pack_end (d_hsFLocal, TRUE, TRUE, s_HBOff);
	d_hsFLocal.show ();
	this->d_vbOptions.pack_start (d_hbFLocal, TRUE, TRUE, s_VBOff);
	d_hbFLocal.show ();

	d_hbFGlobal.pack_start (d_lblFGlobal, TRUE, TRUE, s_HBOff);
	d_lblFGlobal.show ();
	d_hsFLocal.set_digits (2);
	d_hsFLocal.set_draw_value (TRUE);
	d_hbFGlobal.pack_end (d_hsFGlobal, TRUE, TRUE, s_HBOff);
	d_hsFGlobal.show ();
	this->d_vbOptions.pack_start (d_hbFGlobal, TRUE, TRUE, s_VBOff);
	d_hbFGlobal.show ();

	this->p_frmBase->add (this->d_vbOptions);

	this->d_vbOptions.show ();
	this->p_frmBase->show ();
	this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogRescale::buildDialogWindow ()
{
	this->set_usize (300, 220);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	fillActionArea ();
	rbCallback ();

	this->show ();
}


/*
 *  buttonCallbackApply: rotate the Height Field
 */
void TFDialogRescale::buttonCallbackApply ()
{
	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogRescale::buttonCallbackApply");

	if (p_RB1->get_active())
		{
		p_HFO->hfHalf ();
		p_HFD->setScale (1);
		}
	else
	if (p_RB2->get_active())
		{
		float	v1, v2;

		v1 = d_adjFLocal.get_value ();
		v2 = d_adjFGlobal.get_value ();
		p_HFO->hfDouble ((double)v1, (double)v2);
		p_HFD->setScale (1);
		}

	p_HFD->draw ();
	this->b_applyHit = TRUE;
}


/*
 *  rbCallback: callback for the radio button HScale on/off toggle
 */
void TFDialogRescale::rbCallback ()
{
	if (p_RB1->get_active())
		{
		d_lblFLocal.set_sensitive (FALSE);
		d_lblFGlobal.set_sensitive (FALSE);
		d_hsFLocal.set_sensitive (FALSE);
		d_hsFGlobal.set_sensitive (FALSE);
		}
	else
		{
		d_lblFLocal.set_sensitive (TRUE);
		d_lblFGlobal.set_sensitive (TRUE);
		d_hsFLocal.set_sensitive (TRUE);
		d_hsFGlobal.set_sensitive (TRUE);
		}
}


