/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFBaseDialog.h"
#include "GuiColormap.h"
#include "GuiColormapBands.h"
#include "GuiDialogOAC.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize all data members 
 */
TFBaseDialog::TFBaseDialog (HeightField *HF, HeightFieldDraw *HFD, 
				  char *winTitle, char *paramTitle)
	        : GuiDialogOAC (winTitle, paramTitle),
		  d_vbOptions (TRUE, 5)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFBaseDialog::TFBaseDialog");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFBaseDialog::TFBaseDialog");

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFBaseDialog\n");

	p_HF = NULL;
	p_HFD = NULL;
	p_HFO = NULL;
}


/*
 *  destructor: clean up 
 */
TFBaseDialog::~TFBaseDialog ()
{
	if (p_HFO)
		delete p_HFO;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFBaseDialog\n");
}


/*
 *  setHFobjs: set the HF objects we operate on and generate a scaled 
 * 	down version for the preview 
 */
void TFBaseDialog::setHFobjs (HeightField *HF, HeightFieldDraw *HFD)
{
	SanityCheck::bailout ((!HF), "HF==NULL", "TFBaseDialog::setHFobjs");
	SanityCheck::bailout ((!HFD), "HFD==NULL", "TFBaseDialog::setHFobjs");

	if (HF!=p_HF || HFD!=p_HFD)
		{
		if (p_HFO)
			delete p_HFO;
		p_HF = HF;
		p_HFD = HFD;
		p_HFO = new HeightFieldOps (p_HF);
		}
}


