/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _MATH_TRIG_H
#define _MATH_TRIG_H


#ifndef M_PI
#define M_PI    3.14159265358979323846
#endif 

#ifndef M_PI_2
#define M_PI_2  1.57079632679489661923
#endif 



#define PT2	struct Point2
#define PTD2	struct Point2depth
#define PT3	struct Point3
#define COORD2	struct Coordinate2
#define COORD3	struct Coordinate3

// 2D point
typedef struct Point2 {
	double x, y;
	};

// 2D point with depth marker
typedef struct Point2depth {
	double x, y, depth;
	};

// 2D coordinate
typedef struct Coordinate2 {
	double x, y;
	};

// 3D point
typedef struct Point3 {
	double x, y, z;
	};

// 3D coordinate
typedef struct Coordinate3 {
	double x, y, z;
	};
	


#define TriVert		struct TriByVertices
#define TriMod2D	struct TriModel2D
#define TriMod3D	struct TriModel3D

// Triangle defined by three vertices
typedef struct TriByVertices {
	int 			v1, v2, v3;	// Indicies for triangle vertices
	unsigned int	cIndex;		// colormap index 
	PT3				normal;		// Surface normal vector
	bool 			visible;	// Should polygon be rendered?
	};

// 2d object arranged as triangles
typedef struct TriModel2D {
	int 			nTri;		// Number of triangles in the model
	PTD2			*data;		// List of model vertices
	TriVert  		*tri;		// Pointer to array of faces
	int 			xsize, ysize;
	};

// 3d object arranged as triangles
typedef struct TriModel3D {
	int 			nTri;		// Number of triangles in the model
	PT3				*data;		// elevation matrix
	TriVert 		*tri;		// Pointer to array of faces
	int 			xsize, ysize;
	};




/*
 *  MathTrig: general trig-related functions 
 */
class MathTrig
	{
	public: 
		static double		distance (int x1, int y1, int x2, int y2);
		static double		distance (PT2 p1, PT2 p2);
		static void			normalVector (TriMod3D model, TriVert *m);
		static void		normalVector (float* u, float* v, float* n);
		static void		normalVectorNormalized (float* u, float* v, float* n);
	};

#endif // _MATH_TRIG_H
