/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <time.h>
#include "GlobalSanityCheck.h"
#include "HeightFieldGenRandom.h"
#include "HeightFieldGenSubdiv.h"
#include "HeightFieldGenSSynth.h"
#include "MathRandom.h"



/*
 *  initHF: intialize the HF data object that we have to fill
 */
int HeightFieldGenRandom::generate (HeightField *HF, int size)
{
	int		rc=0;
	MathRandom 	mRand (time(NULL));

	if (!HF)
		return -1;

	if (size<10)
		{
		SanityCheck::warning((size<10), "size<10 ... overriding", "HeightFieldGenRandom::generate()");
		size = 400;
		}

	if (mRand.rnd() > 0.5)
		{
		HeightFieldGenSubdiv	*HFG = new HeightFieldGenSubdiv (HF);
		rc = HFG->generate ((int)(mRand.rnd(0,4)+1), size, 0.5, time(NULL));
		delete HFG;
		}
	else
		{
		HeightFieldGenSSynth	*HFG = new HeightFieldGenSSynth (HF);
		rc = HFG->generate (size, 0.5, time(NULL), FALSE);
		delete HFG;
		}

	return rc;
}
