/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _GUI_BUFFERED_DRAWING_AREA_H
#define _GUI_BUFFERED_DRAWING_AREA_H


#include <gtk--.h>
#include <gtk/gtk.h>
#include "GlobalDefs.h"


/*
 *  GuiBufferedDrawingArea: provide an offscreen drawing area which 
 *	is refreshes/repaints using an atomic copy operation from the 
 *      offscreen pixmap to the on screen window. Includes various 
 *	optimizations such as a variable sync rate to minimize actual
 *	redraws. 
 */
class GuiBufferedDrawingArea : public Gtk_DrawingArea
	{
	public:
				GuiBufferedDrawingArea ();
				~GuiBufferedDrawingArea ();
		void		clear (GdkColor *col=NULL);
		void		sync (GdkRectangle *update_rect=NULL);
		void		setSync (int syncInterval);
		void		setColors (GdkColor *fg, GdkColor *bg=NULL);
		void 		drawPoint (int x, int y);
		void 		drawLine (int x1, int y1, int x2, int y2);
		void 		drawRectangle (int x1, int y1, int width, int height, bool filled=TRUE);
		void 		drawPolygon (GdkPoint *points, gint npoints, bool filled=TRUE);
		void 		drawBorderedPolygon (GdkPoint *points, gint npoints, GdkColor *borderColor, GdkColor *polygonColor);
		void		drawText (int x1, int y1, char *textData, GdkFont *textFont);
		void		drawPixmap (GdkPixmap *pixmap, int xsrc, int ysrc, 
					int xdest, int ydest, int width, int height);
		void		drawRGB (int x, int y, int width, int height,
					guchar *buf, gint rowstride);

		void		setUsize (int x, int y);

	protected: 
		virtual int configure_event_impl (GdkEventConfigure *event);
		virtual int	expose_event_impl (GdkEventExpose *event);
		//virtual int button_press_event_impl (GdkEventButton *event);
		//virtual int motion_notify_event_impl (GdkEventMotion *event);

	private:
		unsigned int		d_syncInterval,		// interval at which we sync
					d_noSyncCount,		// how long we haven't sync'ed
					d_sMaxx, d_sMinx, 	// area which is 
					d_sMaxy, d_sMiny; 	// to be synced
		GdkPixmap 		*p_pixmap;		// pixmap buffer for drawing area 
		GdkGC			*p_GC;			// graphics content
	};



#endif // _GUI_BUFFERED_DRAWING_AREA_H
