// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   PointersHT.h

   Pointers HashTable

   Creation: SR, September 7th, 1995
   Revisions:
*/

#ifndef __PointersHT_h
#define __PointersHT_h

#include "tools/hashtab.h"


template<class T>
class PointersHashTable: public HashTable<T>
{
public:
  PointersHashTable()
    {}

  virtual ~PointersHashTable()
    {}

  HashCode getHashCode( const T* p ) const;

  boolean equal( const T* p1, const T* p2 ) const
    {
    return p1 == p2;
    }
};


template<class T>
inline
HashCode PointersHashTable<T>::getHashCode( const T* p ) const
{
  union U
    {
    unsigned char a[ sizeof(void*) ];
    const T* p;
    };

  static U s;

  s.p= p;

  HashCode hc= 0;
  for( size_t i= 0; i < sizeof(void*); ++i )
    hc+= HashCode( s.a[i] );

  return (hc*hc) % getSize();
}


#endif // ifndef __PointersHT_h

