// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoFRectZoom.C

  Stephane Rehel

  October 26 1997
*/

#include "PhotoFRectZoom.h"

#include "tools/IntegerArray.h"

#include "photo/PhotoModule.h"
#include "photo/PhotoModes.h"
#include "photo/PhotoCommand.h"
#include "photo/PhotoCommands.h"

#include "photo/modes/PhotoMRectZoom.h"

/////////////////////////////////////////////////////////////////////////////

PhotoFRectZoom::PhotoFRectZoom( MLModule* _module ):
  MLBaseFunction(_module)
{}

/////////////////////////////////////////////////////////////////////////////

PhotoFRectZoom::~PhotoFRectZoom()
{}

/////////////////////////////////////////////////////////////////////////////

boolean PhotoFRectZoom::_call()
{
  module->enterMode(PhotoModes::RECTZOOM);

  PhotoModule* photo= (PhotoModule*) module;

  photo->pushMessage( "RectZoom" );

  while( ! exitFunction )
    {
    if( ! interfaceYield() )
      break;

//    PhotoMDrag* d= (PhotoMDrag*) photo->getMode(PhotoModes::DRAG);
//    if( d == 0 )
//      break;
//
//    PhotoCommand* cmd= new PhotoCommand;
//    cmd->type= PhotoCommands::TRANSLATE;
//    cmd->x= d->dx;
//    cmd->y= d->dy;
//
//    photo->post(cmd);
    }

  photo->popMessage();

  module->leaveMode();

  return true;
}

/////////////////////////////////////////////////////////////////////////////
