// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  HRCModel.h

  Stephane Rehel
  June 18th, 1996
*/

#ifndef __HRCModel_h
#define __HRCModel_h

#include "tools/mathcls.h"

#include "tools/ilist.h"
#include "tools/MLString.h"

/////////////////////////////////////////////////////////////////////////////

struct HRCModel
{
  MLString name;
  Vector scaling, rotation, translation;
  double discontinuity;

  int nVertices;
  Point* vertices;

  struct Polygon
    {
    int nNodes;
    int* nodes;
    };
  int nPolygons;
  Polygon* polygons;

  IList<HRCModel> children;

  HRCModel();
  virtual ~HRCModel();

  void purge();

  int getNPolygons();
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __HRCModel_h
