////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1999 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "part_head.h"

#include "papi.h"

CPPEXTERN_NEW_WITH_ONE_ARG(part_head, t_floatarg, A_DEFFLOAT)

/////////////////////////////////////////////////////////
//
// part_head
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
part_head :: part_head(t_floatarg numParts)
{
	if (numParts <= 0)
		numParts = 1000.f;
	m_particleGroup = pGenParticleGroups(1, (int)numParts);
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
part_head :: ~part_head()
{
	if (m_particleGroup < 0)
		pDeleteParticleGroups(m_particleGroup, 1);
}

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void part_head :: render(GemState *state)
{
	if (m_particleGroup < 0)
		return;

	pCurrentGroup(m_particleGroup);
}

/////////////////////////////////////////////////////////
// static member functions
//
/////////////////////////////////////////////////////////
void part_head :: obj_setupCallback(t_class *)
{ }
