// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.awt.*;

public class TalkerFrame extends Frame
{
    // menu widgets
    private Menu		fileMenu = new Menu("File");
    private MenuItem		fileDisconnect = new MenuItem("Disconnect");
    private MenuItem		fileExit = new MenuItem("Exit");
    private Menu		optionsMenu = new Menu("Options");
    private MenuItem		optionsFont = new MenuItem("Font");
    private Menu		viewMenu = new Menu("View");

    private Font		font = new Font("bogus", 0, 15);
    private Label		statusBar = new Label();

    private Dispatcher		dispatcher;
    public TalkerPanel		panel;

    public TalkerFrame(Dispatcher dispatcher,
			String hostname, int port, String[] avatarNames,
			String[] avatarURLs) {

	MenuBar			menuBar = new MenuBar();

	setTitle("vnet client");
	setLayout(new BorderLayout());

	optionsMenu.add(optionsFont);
	fileMenu.add(fileDisconnect);
	fileMenu.add(fileExit);
	menuBar.add(fileMenu);
	menuBar.add(optionsMenu);
	menuBar.add(viewMenu);
	setMenuBar(menuBar);
	panel = new TalkerPanel(dispatcher, hostname, port, avatarNames,
				avatarURLs);
	add("Center", panel);
	add("South", statusBar);

	resize(600, 300);
    }

    public boolean handleEvent(Event evt)
    {
	if (evt.target == fileExit && evt.id == Event.ACTION_EVENT
	    || evt.target == this && evt.id == Event.WINDOW_DESTROY) {
	    dispose();
	    return true;
	} else if (evt.target == fileDisconnect && evt.id == Event.ACTION_EVENT) {
	    dispatcher.onQuit();
	    return true;
	} else if (evt.target == optionsFont && evt.id == Event.ACTION_EVENT) {
	    FontChooser	fc = new FontChooser(this, font);
	    if (fc.doModal()) {
		font = fc.font;
		setFont(font);
		show();
	    }
	    return true;
	} else {
//	    System.out.println("event " + evt.toString());
	    return super.handleEvent(evt);
	}
    }

    public void setStatus(String status)
    {
	statusBar.setText(status);
    }
}
