/*
 * Xtux global header
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* Just some things to play around with */
#define BLOOD_SPOTS_STAY 1
#define BUNNY_HEADS_STAY 0
#define BUNNY_BODIES_STAY 0
#define GIB_EXPIRE_TIME 10000000 /* 10 seconds */
#define GIB_DECEL_TIME 100000 /* Slows down 10 pixel/sec/sec */
#define FOCUSFOLLOWSNUKE 0
#define CHARS_RUN_IN_MENU 0
  /* When player is scared dist from critter, run away! */
#define SCARED_DIST 160 /* 2.5 tiles */


/* Debugging options */
#define INSANELY_VERBOSE 0
#define VERBOSE 0

#define XTUXVERSION "XTux v0.2"
#define DEFAULT_FPS 15
#define DEFAULT_FRAME_LEN 1000000 / DEFAULT_FPS
#define MAXMSGLEN 128 /* For text window, seems about right.. */

/* Scrolling View area dimensions */
#define VIEW_W 512
#define VIEW_H 384

#define STATUS_H 58

/* Window dimensions */
#define WIN_W VIEW_W
#define WIN_H VIEW_H + STATUS_H

#define REAL_TILESET 0 
#define TECH_TILESET 1
#define BASE 0
#define OBJECT 1

#define HERO 1
#define COWARD -1

enum GAME_STATES { INIT,
		   MENU,
		   PLAYING,
		   QUIT  };


enum WEAPONS { WEAP_NONE,
	       WEAP_CD,
	       WEAP_FIREBALL,
	       WEAP_NUKE,
	       WEAP_BAT,
	       WEAP_PITCHFORK };

struct map_t {
  char file_name[32];
  char name[32];
  unsigned char tileset; /* 'real' == 0, 'tech' == 1 */
  int width;
  int height;
  /* Map Data */
  unsigned char *base;
  unsigned char *object;
};

typedef struct weapons_struct {

  int has_cd;
  int has_fireball;
  int has_pitchfork;
  int has_bat;

  int num_nukes;

} weapon;






