/*
                    Restart Configuration File

	Functions:

	int RCLoadFromFile(char *filename)


 */

#include "swserv.h"
#include "siteban.h"


int RCLoadFromFile(char *filename)
{
	int i, n, status;
        char *strptr, *strptr2, *strptr3;
        FILE *fp;
        off_t filesize;
        struct stat stat_buf;

        char parm[CFG_PARAMETER_MAX];
        char val[CFG_VALUE_MAX];

	char temp_name[NAME_MAX];

	int lines_read = 0;

	int port_num;
	siteban_struct *sb_ptr;

	/* Recording newly created listening sockets. */
	int *lsocket_port = NULL;
	int total_lsocket_ports = 0;


        /* Check if exists. */
        if(stat(filename, &stat_buf))
        {
	    fprintf(stderr, "%s: No such file.\n", filename);
            return(-1);
        }

	/* Get size of file. */
        filesize = stat_buf.st_size;

        /* Open filename. */
        fp = fopen(filename, "r");
        if(fp == NULL)
        {
            fprintf(stderr, "%s: Cannot open file.\n",
                filename
            );
            return(-1);
        }

        /* *************************************************** */
        /* Deallocate resources that would be recreated by
	 * this function.
	 */

        /* Site ban list. */
        SiteBanDeleteAll();



	/* *********************************************************** */

        strptr = NULL;

        while(1)
        {
            /* Free previous line and allocate/read next line. */
            free(strptr); strptr = NULL;
            strptr = FReadNextLineAllocCount(
		fp, UNIXCFG_COMMENT_CHAR, &lines_read
	    );
            if(strptr == NULL) break;

            /* Fetch parameter. */
            strptr2 = StringCfgParseParm(strptr);
            if(strptr2 == NULL) continue;
            strncpy(parm, strptr2, CFG_PARAMETER_MAX);
            parm[CFG_PARAMETER_MAX - 1] = '\0';

            /* Fetch value. */
            strptr2 = StringCfgParseValue(strptr);
            if(strptr2 == NULL) strptr2 = "0";  /* Set it to "0" if NULL. */
            strncpy(val, strptr2, CFG_VALUE_MAX);
            val[CFG_VALUE_MAX - 1] = '\0';


	    /* ListeningPort */
	    if(!strcasecmp(parm, "ListeningPort"))
	    {
		port_num = atoi(val);

		status = IncomingSocketInit(
		    port_num,
		    INCOMING_SOCKET_TYPE_STANDARD
		);

		/* Record this listening socket's port number. */
		n = total_lsocket_ports;
		total_lsocket_ports++;
		lsocket_port = (int *)realloc(
		    lsocket_port,
		    total_lsocket_ports * sizeof(int)
		);
		if(lsocket_port == NULL)
		{
		    total_lsocket_ports = 0;
		}
		else
		{
		    lsocket_port[n] = port_num;
		}
            }
            /* AUXStatsListeningPort */
            else if(!strcasecmp(parm, "AUXStatsListeningPort"))
            {
                port_num = atoi(val);

                status = IncomingSocketInit(
                    port_num,
                    INCOMING_SOCKET_TYPE_AUXSTATS
                );

                /* Record this listening socket's port number. */
                n = total_lsocket_ports;
                total_lsocket_ports++;
                lsocket_port = (int *)realloc(   
                    lsocket_port,
                    total_lsocket_ports * sizeof(int)
                );
                if(lsocket_port == NULL)
                {
                    total_lsocket_ports = 0;
                }
                else
                {
                    lsocket_port[n] = port_num;
                }
            }
	    /* ServerToplevelDir */
	    else if(!strcasecmp(parm, "ServerToplevelDir"))
            {
#ifndef __WIN32__ /* Disable this for windows. */
		strncpy(dname.swserv_home_dir, val, PATH_MAX);
		dname.swserv_home_dir[PATH_MAX - 1] = '\0';

		/* Warn if not an absolute path. */
		if(!ISPATHABSOLUTE(dname.swserv_home_dir))
		{
                    fprintf(stderr,
                  "%s: Line %i: Warning: %s: Not absolute path statement.\n",
                        filename,  
                        lines_read,
                        dname.swserv_home_dir
                    );
		}

		/* Check if exists. */
		if(stat(dname.swserv_home_dir, &stat_buf))
		{
		    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
		        filename,
                        lines_read,
                        dname.swserv_home_dir
		    );
		}
#endif /* __WIN32__ */
            }
            /* ServerEtcDir */
            else if(!strcasecmp(parm, "ServerEtcDir"))
            {
                strncpy(dname.swserv_etc_dir, val, PATH_MAX);
                dname.swserv_etc_dir[PATH_MAX - 1] = '\0';
                        
                if(!ISPATHABSOLUTE(dname.swserv_etc_dir))
                {
                    strptr3 = PrefixPaths(
                        dname.swserv_home_dir,
                        dname.swserv_etc_dir
                    );
                    if(strptr3 != NULL)
                        strncpy(dname.swserv_etc_dir, strptr3, PATH_MAX);
                    dname.swserv_etc_dir[PATH_MAX - 1] = '\0';
                }

		/* Check if exists. */
                if(stat(dname.swserv_etc_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.swserv_etc_dir
                    );
                }
            }
            /* ServerLogsDir */
            else if(!strcasecmp(parm, "ServerLogsDir"))
            {
                strncpy(dname.swserv_logs_dir, val, PATH_MAX);
		dname.swserv_logs_dir[PATH_MAX - 1] = '\0';
                        
                if(!ISPATHABSOLUTE(dname.swserv_logs_dir))
                {
                    strptr3 = PrefixPaths(
                        dname.swserv_home_dir,
                        dname.swserv_logs_dir
                    );
                    if(strptr3 != NULL)
                        strncpy(dname.swserv_logs_dir, strptr3, PATH_MAX);
                    dname.swserv_logs_dir[PATH_MAX - 1] = '\0';
                }

		/* Check if exists. */
                if(stat(dname.swserv_logs_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.swserv_logs_dir
                    );   
                }
            }
            /* ServerBinDir */
            else if(!strcasecmp(parm, "ServerBinDir"))
            {
#ifndef __WIN32__ /* Disable item for windows. */
                strncpy(dname.swserv_bin_dir, val, PATH_MAX);
		dname.swserv_bin_dir[PATH_MAX - 1] = '\0';

                if(!ISPATHABSOLUTE(dname.swserv_bin_dir))
                {
                    strptr3 = PrefixPaths(
                        dname.swserv_home_dir,
                        dname.swserv_bin_dir
                    );
                    if(strptr3 != NULL)
                        strncpy(dname.swserv_bin_dir, strptr3, PATH_MAX);
                    dname.swserv_bin_dir[PATH_MAX - 1] = '\0';   
                }

		/* Check if exists. */
                if(stat(dname.swserv_bin_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.swserv_bin_dir
                    );
                }
#endif /* __WIN32__ */
            }
            /* ServerDBDir */
            else if(!strcasecmp(parm, "ServerDBDir"))
            {

                strncpy(dname.swserv_db_dir, val, PATH_MAX);
		dname.swserv_db_dir[PATH_MAX - 1] = '\0';

                if(!ISPATHABSOLUTE(dname.swserv_db_dir))
                {
                    strptr3 = PrefixPaths(
                        dname.swserv_home_dir,
                        dname.swserv_db_dir
                    );
                    if(strptr3 != NULL)
                        strncpy(dname.swserv_db_dir, strptr3, PATH_MAX);
                    dname.swserv_db_dir[PATH_MAX - 1] = '\0';
                }

		/* Check if exists. */
                if(stat(dname.swserv_db_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.swserv_db_dir
                    );
                }
            }
            /* ServerTmpDir */
            else if(!strcasecmp(parm, "ServerTmpDir"))
            {
		strncpy(dname.swserv_tmp_dir, val, PATH_MAX);
		dname.swserv_tmp_dir[PATH_MAX - 1] = '\0';

                if(!ISPATHABSOLUTE(dname.swserv_tmp_dir))
                {
		    strptr3 = PrefixPaths(
			dname.swserv_home_dir,
			dname.swserv_tmp_dir
		    );
		    if(strptr3 != NULL)
                        strncpy(dname.swserv_tmp_dir, strptr3, PATH_MAX);
		    dname.swserv_tmp_dir[PATH_MAX - 1] = '\0';
                }

		/* Check if exists. */
                if(stat(dname.swserv_tmp_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.swserv_tmp_dir
                    );
                }
            }
            /* PublicHTMLDir */
            else if(!strcasecmp(parm, "PublicHTMLDir"))
            {
		strncpy(dname.public_html_dir, val, PATH_MAX);
		dname.public_html_dir[PATH_MAX - 1] = '\0';

                if(!ISPATHABSOLUTE(dname.public_html_dir))
                {
		    strptr3 = PrefixPaths(
			dname.swserv_home_dir,
			dname.public_html_dir
		    );
		    if(strptr3 != NULL)
                        strncpy(dname.public_html_dir, strptr3, PATH_MAX);
		    dname.public_html_dir[PATH_MAX - 1] = '\0';
                }

		/* Check if exists. */
                if(stat(dname.public_html_dir, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such directory.\n",
                        filename,
                        lines_read,
                        dname.public_html_dir
                    );
                }
            }

	    /* ******************************************************** */
	    /* Monitor */
            else if(!strcasecmp(parm, "Monitor"))
            {
                if(fname.monitor_set == 0)
                {
                    strncpy(
                        fname.monitor,
                        val,
                        PATH_MAX + NAME_MAX
                    );
		    fname.monitor[PATH_MAX + NAME_MAX - 1] = '\0';
                    fname.monitor_set = 1;
                }

                if(!ISPATHABSOLUTE(fname.monitor))
                {
		    strptr3 = PrefixPaths(
                        dname.swserv_bin_dir,
                        fname.monitor
                    );
		    if(strptr3 != NULL)
                        strncpy(fname.monitor, strptr3, PATH_MAX + NAME_MAX);
		    fname.monitor[PATH_MAX + NAME_MAX - 1] = '\0';
                }

		/* Check if exists. */
		if(stat(fname.monitor, &stat_buf))
		{
		    fprintf(stderr,
			"%s: Line %i: Warning: %s: No such file.\n",
			filename, lines_read, fname.monitor
		    );
		}
            }
            /* UnvIn */
            else if(!strcasecmp(parm, "UnvIn") ||
                    !strcasecmp(parm, "DBIn")
	    )
            {
                if(fname.unv_in_set == 0)
                {
                    strncpy(
                        fname.unv_in,
                        val,
                        PATH_MAX + NAME_MAX
                    );
		    fname.unv_in[PATH_MAX + NAME_MAX - 1] = '\0';
		    fname.unv_in_set = 1;
		}
                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.unv_in))
                {
		    strptr3 = PrefixPaths(dname.swserv_db_dir, fname.unv_in);
		    if(strptr3 != NULL)
		        strncpy(fname.unv_in, strptr3, PATH_MAX + NAME_MAX);
                }
		fname.unv_in[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Check if exists. */
                if(stat(fname.unv_in, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such file.\n",
                        filename, lines_read, fname.unv_in
                    );
                }
            }
            /* UnvOut */ 
            else if(!strcasecmp(parm, "UnvOut") ||
                    !strcasecmp(parm, "DBOut")
	    )
            {
                if(fname.unv_out_set == 0)
                {
                    strncpy(
                        fname.unv_out,
                        val,
                        PATH_MAX + NAME_MAX
                    );
		    fname.unv_out[PATH_MAX + NAME_MAX - 1] = '\0';
                    fname.unv_out_set = 1;
                }
                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.unv_out))
                {
                    strptr3 = PrefixPaths(dname.swserv_db_dir, fname.unv_out);
                    if(strptr3 != NULL)
                        strncpy(fname.unv_out, strptr3, PATH_MAX + NAME_MAX);
                }
		fname.unv_out[PATH_MAX + NAME_MAX - 1] = '\0';

		/* Check if fname.unv_out exists, if so, warn that it will
		 * be overwritten.
		 */
		if(!stat(fname.unv_out, &stat_buf))
		{
/* Wait, how do we know this function was called at startup?
   Maybe it was called in the middle of execution?
		    fprintf(stderr,
"Warning: %s: Universe output file exists and will be overwritten in\n\
less than %ld seconds. Rename the file if you want to save it, do not\n\
shut down the server.\n",
			fname.unv_out,
			sysparm.int_unv_save
		    );
 */
		}
            }
	    /* OCSFile */
            else if(!strcasecmp(parm, "OCSFile"))
            {
                if(fname.ocs_set == 0)
                {
                    strncpy(
                        fname.ocs,
                        val,
                        PATH_MAX + NAME_MAX
                    );
		    fname.ocs[PATH_MAX + NAME_MAX - 1] = '\0';
                    fname.ocs_set = 1;
                }
                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.ocs))
                {
                    sprintf(temp_name, "%s/%s",
                        dname.swserv_db_dir,
                        fname.ocs
                    );   
                    strncpy(fname.ocs, temp_name, PATH_MAX + NAME_MAX);
                }
                fname.ocs[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Check if exists. */
                if(stat(fname.ocs, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: File not found.\n",
                        filename, lines_read, fname.ocs
                    );
                }
            }
            /* OPMFile */
            else if(!strcasecmp(parm, "OPMFile"))
            {
                if(fname.opm_set == 0)
                {
                    strncpy(
                        fname.opm,
                        val,
                        PATH_MAX + NAME_MAX
                    );
		    fname.opm[PATH_MAX + NAME_MAX - 1] = '\0';
                    fname.opm_set = 1;
                }
		/* Set full path as needed. */
		if(!ISPATHABSOLUTE(fname.opm))
		{
		    sprintf(temp_name, "%s/%s",
			dname.swserv_db_dir,
			fname.opm
		    );
		    strncpy(fname.opm, temp_name, PATH_MAX + NAME_MAX);
		}
                fname.opm[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Check if exists. */
                if(stat(fname.opm, &stat_buf))
                {
                    fprintf(stderr,
                        "%s: Line %i: Warning: %s: No such file.\n",
                        filename, lines_read, fname.opm
                    );
                }
            }
            /* PrimaryLogFile */
            else if(!strcasecmp(parm, "PrimaryLogFile"))
            {
                strncpy(
                    fname.primary_log,
                    val,
                    PATH_MAX + NAME_MAX
                );
		fname.primary_log[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.primary_log))
                {
                    sprintf(temp_name, "%s/%s",
                        dname.swserv_logs_dir,
                        fname.primary_log
                    );
                    strncpy(fname.primary_log, temp_name, PATH_MAX + NAME_MAX);
                }
                fname.primary_log[PATH_MAX + NAME_MAX - 1] = '\0';
                continue;
            }
            /* ConListExportFile */
            else if(!strcasecmp(parm, "ConListExportFile") ||
                    !strcasecmp(parm, "ConListHTML")
	    )
            {
                strncpy(
                    fname.conlist_export,
                    val,
                    PATH_MAX + NAME_MAX
                );
		fname.conlist_export[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.conlist_export))
                {
		    strncpy(
			fname.conlist_export,
			PrefixPaths(dname.public_html_dir, fname.conlist_export),
			PATH_MAX + NAME_MAX
		    );
                }
                fname.conlist_export[PATH_MAX + NAME_MAX - 1] = '\0';
            }
            /* ScoresExportFile */
            else if(!strcasecmp(parm, "ScoresExportFile") ||
                    !strcasecmp(parm, "ScoresHTML")
	    )
            {
                strncpy(
                    fname.scores_export,
                    val,
                    PATH_MAX + NAME_MAX
                );
		fname.scores_export[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.scores_export))
                {
                    strncpy(
                        fname.scores_export,
                        PrefixPaths(dname.public_html_dir, fname.scores_export),
                        PATH_MAX + NAME_MAX
                    );
                }
                fname.scores_export[PATH_MAX + NAME_MAX - 1] = '\0';
            }
            /* EventsExportFile */
            else if(!strcasecmp(parm, "EventsExportFile") ||
                    !strcasecmp(parm, "EventsHTML")
	    )
            {
                strncpy(
                    fname.events_export,
                    val,
                    PATH_MAX + NAME_MAX
                );
		fname.events_export[PATH_MAX + NAME_MAX - 1] = '\0';

                /* Set full path as needed. */
                if(!ISPATHABSOLUTE(fname.events_export))
                {
                    strncpy(
                        fname.events_export,
                        PrefixPaths(dname.public_html_dir, fname.events_export), 
                        PATH_MAX + NAME_MAX
                    );
                }
                fname.events_export[PATH_MAX + NAME_MAX - 1] = '\0';
            }


	    /* ********************************************************* */
	    /* System parameters. */

            /* IntervalObjectValues */
            else if(!strcasecmp(parm, "IntervalObjectValues"))
            {
		sysparm.int_object_values = atol(val);
		if(sysparm.int_object_values < MIN_OBJECT_UPDATE_INT)
		{
		    fprintf(stderr,
   "%s: Line %i: Warning: IntervalObjectValues too low, setting to minimum %i.\n",
			filename,
			lines_read,
			MIN_OBJECT_UPDATE_INT
		    );
		    sysparm.int_object_values = MIN_OBJECT_UPDATE_INT;
		}

		next.object_values = cur_millitime + sysparm.int_object_values;
            }
            /* IntervalWeaponValues */
            else if(!strcasecmp(parm, "IntervalWeaponValues"))
            {
		sysparm.int_weapon_values = atol(val);
                if(sysparm.int_weapon_values < MIN_OBJECT_UPDATE_INT)
                {
                    fprintf(stderr,
   "%s: Line %i: Warning: IntervalWeaponValues too low, setting to minimum %i.\n",
                        filename,
                        lines_read,
			MIN_OBJECT_UPDATE_INT
                    );
                    sysparm.int_weapon_values = MIN_OBJECT_UPDATE_INT;
                }
                next.weapon_values = cur_millitime + sysparm.int_weapon_values;
            }
            /* IntervalAUXStats */
            else if(!strcasecmp(parm, "IntervalAUXStats"))
            {
                sysparm.int_aux_con_stats = atol(val);
                if(sysparm.int_aux_con_stats < 1000)
                {
                    fprintf(stderr,
 "%s: Line %i: Warning: IntervalAUXStats too low, setting to minimum 1000.\n",
                        filename,
                        lines_read
                    );
                    sysparm.int_aux_con_stats = 1000;
                }
            }
            /* IntervalOSStats */
	    else if(!strcasecmp(parm, "IntervalOSStats"))
            {
                sysparm.int_os_stats = atol(val);	/* In seconds. */
                if(sysparm.int_os_stats < 1)
                {
                    fprintf(stderr,
   "%s: Line %i: Warning: IntervalOSStats too low, setting to minimum %i.\n",
                        filename,
                        lines_read,
			1
                    );
                    sysparm.int_os_stats = 1;
                }

		next.os_stats = cur_systime;	/* Next should be now. */
            }
            /* IntervalUnvSave */
            else if(!strcasecmp(parm, "IntervalUnvSave") ||
                    !strcasecmp(parm, "IntervalDBSave")
	    )
            {
                sysparm.int_unv_save = atol(val);	/* In seconds. */
                if(sysparm.int_unv_save < 1)
                {
                    fprintf(stderr,
   "%s: Line %i: Warning: IntervalDBSave too low, setting to minimum %i.\n",
                        filename,
                        lines_read,
			1
                    );
                    sysparm.int_unv_save = 1;
                }

                next.unv_save = cur_systime + sysparm.int_unv_save;
            }
            /* IntervalStatsExportFile */
            else if(!strcasecmp(parm, "IntervalStatsExportFile") ||
                    !strcasecmp(parm, "IntervalStatisticsExport")
	    )
            {
                sysparm.int_stats_export = atol(val);	/* In seconds. */
                if(sysparm.int_stats_export < 1)
                {
                    fprintf(stderr,
 "%s: Line %i: Warning: IntervalStatisticsExport too low, setting to minimum %i.\n",
                        filename,
                        lines_read,
			1
                    );
                    sysparm.int_stats_export = 1;
                }

                next.stats_export = cur_systime + sysparm.int_stats_export;
            }
            /* MaxConnections */
            else if(!strcasecmp(parm, "MaxConnections"))
            {
                sysparm.max_connections = atol(val);
                if(sysparm.max_connections < 1)
                {
                    fprintf(stderr,
           "%s: Line %i: Error: MaxConnections cannot be less than 1.\n",
                        filename,
                        lines_read
                    );
                    sysparm.max_connections = 1;
                }
            }
            /* MaxGuests */
            else if(!strcasecmp(parm, "MaxGuests"))
            {
                sysparm.max_guests = atol(val);
                if(sysparm.max_guests < 0)
                    sysparm.max_guests = 0;
            }
            /* MaxAUXStatsConnections */
            else if(!strcasecmp(parm, "MaxAUXStatsConnections"))
            {
                sysparm.max_aux_connections = atol(val);
		if(sysparm.max_aux_connections < 0)
		    sysparm.max_aux_connections = 0;
            }
	    /* LoginTimeout */
	    else if(!strcasecmp(parm, "LoginTimeout"))
	    {
		sysparm.login_timeout = atol(val);	/* Seconds. */
                if(sysparm.login_timeout < 1)
                    sysparm.login_timeout = 1;
	    }
	    /* MaxFailedLogins */
	    else if(!strcasecmp(parm, "MaxFailedLogins"))
            {
                sysparm.max_failed_logins = atoi(val);
                if(sysparm.max_failed_logins < 1)
                    sysparm.max_failed_logins = 1;
            }
	    /* GuestLoginName */
            else if(!strcasecmp(parm, "GuestLoginName"))
            {
                strncpy(sysparm.guest_login_name, val, XSW_OBJ_NAME_MAX);
		sysparm.guest_login_name[XSW_OBJ_NAME_MAX - 1] = '\0';
            }
	    /* AllowGuestLogins */
            else if(!strcasecmp(parm, "AllowGuestLogins"))
            {
		sysparm.allow_guest = StringIsYes(val);
            }
	    /* ConnectNotify */
	    else if(!strcasecmp(parm, "ConnectNotify"))
            {
                sysparm.con_notify = StringIsYes(val);
	    }
	    /* SingleConnection */
	    else if(!strcasecmp(parm, "SingleConnection"))
            {
                sysparm.single_connection = StringIsYes(val);
            }
            /* CeaseFire */
            else if(!strcasecmp(parm, "CeaseFire"))
            {
                sysparm.cease_fire = StringIsYes(val);
            }
            /* HidePlayers */
            else if(!strcasecmp(parm, "HidePlayers"))
            {
                sysparm.hide_players = StringIsYes(val);
            }
            /* HomesDestroyable */
            else if(!strcasecmp(parm, "HomesDestroyable"))
            {
                sysparm.homes_destroyable = StringIsYes(val);
            }
	    /* KillerGetsCredits */
            else if(!strcasecmp(parm, "KillerGetsCredits"))
            {
                sysparm.killer_gets_credits = StringIsYes(val);
            }
            /* HitPlayerBonus */
            else if(!strcasecmp(parm, "HitPlayerBonus"))
            {
                sysparm.hit_player_bonus = atof(val);
		if(sysparm.hit_player_bonus < 0)
		    sysparm.hit_player_bonus = 0;
            }
	    /* DmgCtlRate */
	    else if(!strcasecmp(parm, "DmgCtlRate") ||
                    !strcasecmp(parm, "DamageControlRate")
	    )
	    {
		sysparm.dmg_ctl_rate = atof(val);
                if(sysparm.dmg_ctl_rate < 0)
                    sysparm.dmg_ctl_rate = 0;
            }

	    /* lost_found_owner is set in the universe file. */

	    /* LogGeneral */
            else if(!strcasecmp(parm, "LogGeneral"))
            {
		sysparm.log_general = StringIsYes(val);
            }
            /* LogEvents */
            else if(!strcasecmp(parm, "LogEvents"))
            {
                sysparm.log_events = StringIsYes(val);
            }
            /* LogNet */
            else if(!strcasecmp(parm, "LogNet"))
            {
                sysparm.log_net = StringIsYes(val);
            }
            /* LogErrors */
            else if(!strcasecmp(parm, "LogErrors"))
            {
                sysparm.log_errors = StringIsYes(val);
            }

	    /* MessageWrongLogin */
	    else if(!strcasecmp(parm, "MessageWrongLogin"))
	    {
		strncpy(
		    sysparm.mesg_wrong_login,
		    val,
		    CS_MESG_MAX
		);
		sysparm.mesg_wrong_login[CS_MESG_MAX - 1] = '\0';
	    }
            /* MessageNoGuests */
            else if(!strcasecmp(parm, "MessageNoGuests"))
            {
                strncpy(
                    sysparm.mesg_no_guests,
                    val,
                    CS_MESG_MAX
                );
                sysparm.mesg_no_guests[CS_MESG_MAX - 1] = '\0';
            }
	    /* MessageWelcome */
            else if(!strcasecmp(parm, "MessageWelcome"))
            {
                strncpy(
                    sysparm.mesg_welcome,
                    val,
                    CS_MESG_MAX
                );
                sysparm.mesg_welcome[CS_MESG_MAX - 1] = '\0';
            }
            /* MessageLeave */
            else if(!strcasecmp(parm, "MessageLeave"))
            {
                strncpy(
                    sysparm.mesg_leave,
                    val,
                    CS_MESG_MAX
                );
                sysparm.mesg_leave[CS_MESG_MAX - 1] = '\0';
            }
            /* ******************************************************** */
            /* BeginSiteBan */
            else if(!strcasecmp(parm, "BeginSiteBan"))
            {
		/* Allocate new site ban entry. */
		if(total_sitebans < 0)
		    total_sitebans = 0;

		n = total_sitebans;
		total_sitebans++;

		siteban = (siteban_struct **)realloc(
		    siteban,
		    total_sitebans * sizeof(siteban_struct *)
		);
		if(siteban == NULL)
		{
		    total_sitebans = 0;
		    continue;
		}

		siteban[n] = (siteban_struct *)calloc(
		    1,
		    sizeof(siteban_struct)
		);
		if(siteban[n] == NULL)
		{
		    total_sitebans--;
		    continue;
		}

		/* Get pointer to structure. */
		sb_ptr = siteban[n];


		while(1)
		{
                    /* Free previous line and allocate/read next line. */
                    free(strptr); strptr = NULL;
                    strptr = FReadNextLineAllocCount(
			fp, UNIXCFG_COMMENT_CHAR, &lines_read
		    );
                    if(strptr == NULL) break;

                    /* Fetch parameter. */
                    strptr2 = StringCfgParseParm(strptr);
                    if(strptr2 == NULL) continue;
                    strncpy(parm, strptr2, CFG_PARAMETER_MAX);
                    parm[CFG_PARAMETER_MAX - 1] = '\0';

                    /* Fetch value. */
                    strptr2 = StringCfgParseValue(strptr);
                    if(strptr2 == NULL) strptr2 = "0";
                    strncpy(val, strptr2, CFG_VALUE_MAX);
                    val[CFG_VALUE_MAX - 1] = '\0';


		    /* Address */
                    if(!strcasecmp(parm, "Address"))
                    {
			StringParseIP(
			    val,
			    &(sb_ptr->ip.part_u8[0]),
                            &(sb_ptr->ip.part_u8[1]),
                            &(sb_ptr->ip.part_u8[2]),
                            &(sb_ptr->ip.part_u8[3])
			);
		    }
                    /* Restrict */
                    else if(!strcasecmp(parm, "Restrict"))
                    {
			sb_ptr->restrict = atoi(val);
                    }
                    /* EndSiteBan */
                    else if(!strcasecmp(parm, "EndSiteBan"))
                    {
			break;
		    }
		}
	    }

	    /* ******************************************************** */

 	    /* Unknown parameter. */
	    else
	    {
		fprintf(stderr, "%s: Line %i: Unknown parameter: `%s'\n",
		    filename,
		    lines_read,
		    parm
		);
	    }
	}


	/* Close file. */
	fclose(fp); fp = NULL;


	/* Close incoming connections listening sockets that don't
	 * match any port number in the newly created listening socket
	 * port numbers list.
	 */
	for(i = 0; i < total_incoming_sockets; i++)
	{
	    if(incoming_socket[i] == NULL)
		continue;

	    /* Get port number. */
	    port_num = incoming_socket[i]->port_num;

	    /* Go through newly created listening socket port numbers. */
	    for(n = 0; n < total_lsocket_ports; n++)
	    {
	        if(lsocket_port[n] == port_num)
		    break;
	    }
	    if(n >= total_lsocket_ports)
	    {
		/* Not in list newly created listening socket port numbers
		 * list, so close this incoming connections socket.
		 */
		IncomingSocketDelete(i);
	    }
	}


	/* Free recorded newly created listening socket port numbers. */
	free(lsocket_port); lsocket_port = NULL;
	total_lsocket_ports = 0;


	return(0);
}
