#include "swserv.h"

#define THIS_CMD_NAME	"save"  
 
 
/*
 *      Save the universe.
 */
int CmdSaveUniverse(int condescriptor, char *arg)
{
        long object_num;
	xsw_object_struct *obj_ptr;
        char sndbuf[CS_DATA_MAX_LEN];
        char text[512];


        /* Get object_num, assumed valid. */
        object_num = connection[condescriptor]->object_num;
	if(DBIsObjectGarbage(object_num))
	    return(-1);
	else
	    obj_ptr = xsw_object[object_num];

        /* Check if object's permission allows save. */
        if(obj_ptr->permission.uid > ACCESS_UID_SAVE)
        {
            sprintf(sndbuf,
                "%s: Requires access level %i: Permission denied.",
                THIS_CMD_NAME, ACCESS_UID_SAVE
            );
            NetSendLiveMessage(condescriptor, sndbuf);
            return(-1);
        }

        /* Log who requested save. */
        sprintf(text,
	    "%s: Requesting database save.",
	    DBGetFormalNameStr(object_num)
        );
        if(sysparm.log_general)
	    LogAppendLineFormatted(fname.primary_log, text);


	/* Do save procedure. */
	SWServDoSave();


        /* Mark next time DB save is to be performed. */
        next.unv_save = cur_systime + sysparm.int_unv_save;


        return(0);
}
