#include "swserv.h"
 
  
/*
 *      Kills a process.
 */
int CmdKill(int condescriptor, char *arg)
{
        char sndbuf[CS_DATA_MAX_LEN]; 
        register char can_kill_others;
        register int uid;
        long object_num; 
        int schedual_num;
        
        if(arg == NULL)
            return(-1);
        
        if(strlen(arg) < 1)
        {
            sprintf(sndbuf, "Usage: `kill <pid>'");   
            NetSendLiveMessage(condescriptor, sndbuf);
            
            return(-1);
        }
         
        
        /* Get object number. */
        object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(object_num))
            return(-1);
        
        /* Get object's uid. */
        uid = xsw_object[object_num]->permission.uid;

        /* Check if connection can kill processes of others. */
        can_kill_others = (uid > ACCESS_UID_PSKILLO) ? 0 : 1;
  
 
        /* Get schedual number as PID. */
        schedual_num = atoi(arg);
 
        
        /* Does PID exist? */
        if(!SchedualIsActive(schedual_num))
        {
            sprintf(sndbuf, "%i: No such pid.",
                schedual_num
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-2);
        }
        if((schedual[schedual_num]->run_owner != object_num) &&
           !can_kill_others
        )   
        {
            sprintf(sndbuf, "%i: You do not own that PID.",
                schedual_num
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(-2);
        }


        /* Recycle the schedual (effectively killing the PID). */
        SchedualRecycle(schedual_num);
        sprintf(sndbuf,
            "%i: Process killed.",
            schedual_num
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}

