#include "swserv.h"
  
  
/*
 *      Print estimated time of arrival for object of
 *      connection.
 */
int CmdETA(int condescriptor, char *arg)
{
        long object_num, dest_object_num;
        char sndbuf[CS_DATA_MAX_LEN];
        double distance;
        double velocity;
        double eta;
        
        xsw_object_struct *object_num_ptr; 
        xsw_object_struct *dest_object_ptr;
        
        
        /* Get object number. */
        object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(object_num))
            return(-1);
        else
            object_num_ptr = xsw_object[object_num];
        
        
        /* Get destination object. */
        dest_object_num = object_num_ptr->intercepting_object;
        if(DBIsObjectGarbage(dest_object_num))
            return(0);
        else
            dest_object_ptr = (xsw_object_struct
*)xsw_object[dest_object_num];

  
        /* Cannot calculate if velocity is 0. */
        velocity = object_num_ptr->velocity;
        if(velocity <= 0)
        {
            return(0);
        }
 
        /* Check if in same sector. */   
        if(!Mu3DInSameSector(object_num, dest_object_num))
        {
            sprintf(sndbuf,
                "ETA: Destination not in current sector."
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        
            return(0);
        }
        
        /* Get distance between objects (in XSW real units). */
        distance = Mu3DDistance(
            dest_object_ptr->x - object_num_ptr->x,
            dest_object_ptr->y - object_num_ptr->y,
            dest_object_ptr->z - object_num_ptr->z
        );
        
        /* Calculate eta. */
        eta = distance / velocity;
        /* ETA is in multiples of 16000, must convert into seconds. */
        eta = eta / 100;
        
        sprintf(sndbuf,
            "ETA to %s in %s",
            DBGetFormalNameStr(dest_object_num),
            StringFormatTimePeriod((long)eta)   
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}
