#include "swserv.h"
 
  
/*
 *      Front end to parse server command.
 */
int CmdHandleInput(int condescriptor, char *cmd)
{
	int i, status;
	char *strptr;
	long object_num;
        char sndbuf[CS_DATA_MAX_LEN + 256];

        char stringa[CS_DATA_MAX_LEN + 256];
        char stringb[CS_DATA_MAX_LEN + 256];
        char arg[CS_DATA_MAX_LEN + 256];
        char command[CS_DATA_MAX_LEN + 256];


        /* Command must be valid and contain data. */
	if((cmd == NULL) ? 1 : (cmd[0] == '\0'))
	    return(-1);
/*
fprintf(stderr, "Got command, literal binary:\n");
for(strptr = cmd, i = 0; *strptr != '\0'; strptr++, i++)
{
	fprintf(stderr, "0x%.2x ", (u_int8_t)*strptr);
}
fprintf(stderr, "\nPrinted %i chars.\n", i);
 */
        /* Must be connected. */
        if(!ConIsConnected(condescriptor))
	    return(-1);

        /* Must be logged in (have valid object). */
        object_num = connection[condescriptor]->object_num;
        if(DBIsObjectGarbage(object_num))
        {
            NetSendLiveMessage(condescriptor,
                "You must be logged in to execute a server command."
            );

            return(-1); 
        }

        /* Copy command into stringa. */
        strncpy(stringa, cmd, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';
        
        /* Sanitize stringa. */   
        strncpy(stringb, stringa, CS_DATA_MAX_LEN);
        stringb[CS_DATA_MAX_LEN - 1] = '\0';
        StringStripSpaces(stringb);
        
        strncpy(stringa, stringb, CS_DATA_MAX_LEN);
        stringa[CS_DATA_MAX_LEN - 1] = '\0';

	strptr = strchr(stringa, '\n');
        if(strptr != NULL) *strptr = '\0';
	strptr = strchr(stringa, '\r');
        if(strptr != NULL) *strptr = '\0';


        /* ******************************************************** */
        /* Begin parsing. */
	strptr = strchr(stringa, ' ');
        if(strptr != NULL)
        {
            strncpy(arg, (strptr + 1), CS_DATA_MAX_LEN);   
            arg[CS_DATA_MAX_LEN - 1] = '\0';
            *strptr = '\0';
            strncpy(command, stringa, CS_DATA_MAX_LEN);
            command[CS_DATA_MAX_LEN - 1] = '\0';
        }
        else
        {
            strncpy(arg, "", CS_DATA_MAX_LEN);
            strncpy(command, stringa, CS_DATA_MAX_LEN);
            command[CS_DATA_MAX_LEN - 1] = '\0';
        }


        /* Log this. */
        sprintf(stringa,
            "%s: Executed: Command: `%s'  Argument: `%s'",
            DBGetFormalNameStr(object_num),
            command,
            arg
        );
        if(sysparm.log_general == 1)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* ****************************************************** */
        /* Handle command. */

        /* Debug. */
        if(strcasepfx(command, "debug"))
        {
	    status = CmdDebug(condescriptor, arg);
        }
	/* Help. */
        else if(strcasepfx(command, "h") ||
                strcasepfx(command, "?")
	)
        {
            status = CmdHelp(condescriptor, arg);
        }
        /* Version. */ 
        else if(strcasepfx(command, "ver"))
        {
            status = CmdVersion(condescriptor, arg);
        } 
        /* Sysparm. */
        else if(strcasepfx(command, "sysp") ||
                strcasepfx(command, "tune")
        )
        {
            status = CmdSysparm(condescriptor, arg);
        }
        /* Memory. */
        else if(strcasepfx(command, "mem"))
        {
            status = CmdMemory(condescriptor, arg);
        }
        /* Disk. */
        else if(strcasepfx(command, "disk"))
        {
            status = CmdDisk(condescriptor, arg);
        }
        /* Processes. */
        else if(strcasepfx(command, "ps")) 
        {
            status = CmdPS(condescriptor, arg);
        }
        /* Kill process. */
        else if(strcasepfx(command, "kill"))
        {
            status = CmdKill(condescriptor, arg);
        }
        /* Set. */
        else if(strcasepfx(command, "set"))
        {
            status = CmdSet(condescriptor, arg);
        }
	/* Wall. */
        else if(strcasepfx(command, "wal"))
        {
            status = CmdWall(condescriptor, arg);
        }
        /* Who. */
        else if(strcasepfx(command, "who"))
        {
            status = CmdWho(condescriptor, arg);
        }
        /* Netstat. */
        else if(strcasepfx(command, "nets"))
        {
            status = CmdNetstat(condescriptor, arg);
        }
        /* Score. */
        else if(strcasepfx(command, "score"))
        {
            status = CmdScore(condescriptor, arg);
        }
        /* ETA. */
        else if(strcasepfx(command, "eta"))
        {
            status = CmdETA(condescriptor, arg);
        }
        /* Save. */
        else if(strcasepfx(command, "save")) 
        {
            status = CmdSaveUniverse(condescriptor, arg);
        }
        /* Shutdown. */
        else if(strcasepfx(command, "shutdown"))
        {
            status = CmdShutdown(condescriptor, arg);
        }
        /* Shutdown. */
        else if(strcasepfx(command, "siteb"))
        {
            status = CmdSiteBan(condescriptor, arg);
	}
        /* Boot. */
        else if(strcasepfx(command, "boot"))
        {
            status = CmdBoot(condescriptor, arg);
        }
        /* Sync time. */
        else if(strcasepfx(command, "sync"))
        {
            status = CmdSyncTime(condescriptor, arg);
        }
        /* ID. */
        else if(strcasepfx(command, "id"))
        {
            status = CmdID(condescriptor, arg);
        }
        /* Create player. */
        else if(strcasepfx(command, "createp"))
        {
            status = CmdCreatePlayer(condescriptor, arg);
        }
        /* Create object. */
        else if(strcasepfx(command, "create"))
        {
            status = CmdCreate(condescriptor, arg);
        }
        /* Chown object. */
        else if(strcasepfx(command, "cho"))
        {
            status = CmdChown(condescriptor, arg);
        }
        /* Recycle player. */
        else if(strcasepfx(command, "recyclep"))
        {
            status = CmdRecyclePlayer(condescriptor, arg);
        }
        /* Recycle object. */
        else if(strcasepfx(command, "rec"))
        {
            status = CmdRecycle(condescriptor, arg);
        }
        /* Unrecycle object. */
        else if(strcasepfx(command, "unrec"))
        {
           status = CmdUnrecycle(condescriptor, arg);
        }
        /* Examine object. */
        else if(strcasepfx(command, "ex"))
        {
            status = CmdExamine(condescriptor, arg);
        }
        /* Find. */
        else if(strcasepfx(command, "find"))
        {
            status = CmdFind(condescriptor, arg);
        }
        /* Eco product create. */
        else if(strcasepfx(command, "ecoproductc") ||
                strcasepfx(command, "ecoprodc")
        )
        {
            status = CmdEcoProductCreate(condescriptor, arg);
        }
        /* Eco product create. */
        else if(strcasepfx(command, "ecoproducts") ||
                strcasepfx(command, "ecoprods")
        )
        {
            status = CmdEcoProductSet(condescriptor, arg);
        }
	/* Eco product delete. */
        else if(strcasepfx(command, "ecoproductd") ||
                strcasepfx(command, "ecoprodd")
        )
        {
            status = CmdEcoProductDelete(condescriptor, arg);
        }


        /* Test. */
        else if(!strcasecmp(command, "test")) 
        {
            status = CmdTest(condescriptor, arg);
        }

        /* Unknown command. */
        else
        {
            status = -1;

            sprintf(sndbuf,
                "%s: no such command or macro.",
                command
            );
            NetSendLiveMessage(condescriptor, sndbuf);
        }


        return(status);
}
