/*
                     XSW's File Browser Callback Handler

	Functions:

	void XSWMapFB(char *path, int mode)

        int XSWFBCBOk(char *path)
        int XSWFBCBCancel(char *path)

	---

	Handles mapping and callbacks of file browser.

	Note: Options window file browser mapping is done in
	the optwinop.c module.

 */

#include "xsw.h"



/*
 *	Maps the file browser and sets it up for load mode mode.
 */
void XSWMapFB(char *path, int mode)
{
	char *strptr;
	char tmp_path[PATH_MAX + NAME_MAX];

	static int prev_fb_loadop = PRI_FB_LOADOP_NONE;


	switch(mode)
	{
	  /* ***************************************************** */
	  /* Run server. */
	  case PRI_FB_LOADOP_RUN_SERVER:
            XSWDoUnfocusAllWindows();

	    strptr = PrefixPaths(DEF_SW_SERVER_DIR, "*");
	    strncpy(
		tmp_path,
		((strptr == NULL) ? "/" : strptr),
		PATH_MAX + NAME_MAX
	    );
	    tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

            pri_fb_loadop = PRI_FB_LOADOP_RUN_SERVER;
            pri_fbrowser.func_ok = XSWFBCBOk;
            pri_fbrowser.func_cancel = XSWFBCBCancel;

	    FBrowserSetOpMesg(
		&pri_fbrowser,
		"Start Server",
		"Execute"
	    );
	    FBrowserMapPath(&pri_fbrowser, tmp_path);
            break;

          /* ***************************************************** */
          /* Load Image Set Referance file. */  
          case PRI_FB_LOADOP_ISREF:
            XSWDoUnfocusAllWindows();

            strptr = PrefixPaths(dname.images, FN_ISREF_EXT_MASK);
            strncpy(
                tmp_path,
                ((strptr == NULL) ? "/" : strptr),
                PATH_MAX + NAME_MAX
            );
            tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

            pri_fb_loadop = PRI_FB_LOADOP_ISREF;
            pri_fbrowser.func_ok = XSWFBCBOk;
            pri_fbrowser.func_cancel = XSWFBCBCancel;

            FBrowserSetOpMesg(
                &pri_fbrowser,
                "Load Image Set Referance File",
                "Load"
            );
            FBrowserMapPath(&pri_fbrowser, tmp_path);
            break;

          /* ***************************************************** */
          /* Load OCSN file. */
          case PRI_FB_LOADOP_OCSN:
            XSWDoUnfocusAllWindows();

            strptr = PrefixPaths(dname.etc, FN_OCSN_EXT_MASK);
            strncpy(
                tmp_path,
                ((strptr == NULL) ? "/" : strptr),
                PATH_MAX + NAME_MAX
            );
            tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

            pri_fb_loadop = PRI_FB_LOADOP_OCSN;
            pri_fbrowser.func_ok = XSWFBCBOk;  
            pri_fbrowser.func_cancel = XSWFBCBCancel;

            FBrowserSetOpMesg(
		&pri_fbrowser,
		"Load OCS Names File",
		"Load"
	    );
            FBrowserMapPath(&pri_fbrowser, tmp_path);
            break;

          /* ***************************************************** */
          /* Load Sound Scheme file */
          case PRI_FB_LOADOP_SS:
            XSWDoUnfocusAllWindows(); 

            strptr = PrefixPaths(dname.sounds, FN_SS_EXT_MASK);
            strncpy(
                tmp_path,
                ((strptr == NULL) ? "/" : strptr),
                PATH_MAX + NAME_MAX
            );
            tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

            pri_fb_loadop = PRI_FB_LOADOP_SS;
            pri_fbrowser.func_ok = XSWFBCBOk;
            pri_fbrowser.func_cancel = XSWFBCBCancel;

            FBrowserSetOpMesg(
		&pri_fbrowser,
                "Load Sound Scheme File",
		"Load"
	    );
            FBrowserMapPath(&pri_fbrowser, tmp_path);
            break;

          /* ***************************************************** */
          /* Server script. */
          case PRI_FB_LOADOP_SERVER_SCRIPT:
            XSWDoUnfocusAllWindows();

            pri_fb_loadop = PRI_FB_LOADOP_SERVER_SCRIPT;
            pri_fbrowser.func_ok = XSWFBCBOk;
            pri_fbrowser.func_cancel = XSWFBCBCancel;

            FBrowserSetOpMesg(
		&pri_fbrowser,
                "Load Server Script File",
		"Load"
	    );

            /* Previous load operation the same? */
            if(prev_fb_loadop == PRI_FB_LOADOP_SERVER_SCRIPT)
	    {
		FBrowserMapSearchMask(&pri_fbrowser, "*");
	    }
	    else
            {
                strptr = PrefixPaths(
		    getenv("HOME"),
		    "*"
		);
                strncpy(
                    tmp_path,
                    ((strptr == NULL) ? "/" : strptr),
                    PATH_MAX + NAME_MAX
                );
                tmp_path[PATH_MAX + NAME_MAX - 1] = '\0';

                FBrowserMapPath(&pri_fbrowser, tmp_path);
            }
            break;

          /* ***************************************************** */
	  default:
	    fprintf(
		stderr,
		"XSWMapFB(): Unknown load mode %i.\n",
		mode
	    );
	    break;
	}


	/* Record previous load operation. */
	prev_fb_loadop = mode;


	return;
}


/*
 *	Primary file browser ok callback handler.
 */
int XSWFBCBOk(char *path)
{
        if(path == NULL)
        {
            pri_fb_loadop = PRI_FB_LOADOP_NONE;
            return(-2);
        }
        
        /*   Check which mode the primary filebrowser is in
         *   and handle it accordingly.
         */
        switch(pri_fb_loadop)
        {
          case PRI_FB_LOADOP_RUN_SERVER:
            XSWStartServer(path);
            break;
        
          case PRI_FB_LOADOP_OCSN:
	    XSWLoadOCSN(path);
	    break;

	  case PRI_FB_LOADOP_ISREF:
	    XSWLoadIsrefs(path);
	    break;

	  case PRI_FB_LOADOP_SS:
	    XSWLoadSS(path);
	    break;

	  case PRI_FB_LOADOP_SERVER_SCRIPT:
	    ServScriptDoMapPrompt(path);
	    break;

          default:
            break;
        }  
 
        
        /* Set global variable pri_fb_loadop to none. */
        pri_fb_loadop = PRI_FB_LOADOP_NONE;

        return(0);
} 



/*
 *	Primary file browser cancel callback handler.
 */
int XSWFBCBCancel(char *path)
{
        /* Set global pri_fb_loadop to load operation. */
        pri_fb_loadop = PRI_FB_LOADOP_NONE;

	return(0);
}
