/*
                          Sound Scheme Management

	Functions:

	int SSIsAllocated(int n)
	ss_item_struct *SSGetPtr(int n)

	int SSAllocate(char *path)
        int SSAllocateExplicit(int n) 
	void SSDelete(int n)
	void SSDeleteAll()

	---

 */

#include "xsw.h"


int SSIsAllocated(int n)
{
        if((n < 0) ||
           (n >= total_ss_items) ||
           (ss_item == NULL)
        )
            return(0);
        else if(ss_item[n] == NULL)
            return(0);
        else
            return(1);
}


ss_item_struct *SSGetPtr(int n)
{
        if(SSIsAllocated(n))
            return(ss_item[n]);
        else
            return(NULL);
}



/*
 *	Allocates a sound scheme item and returns its index number
 *	or -1 on error.
 */
int SSAllocate(char *path)
{
        int i, n;

 
        for(i = 0; i < total_ss_items; i++)
        {   
            if(ss_item[i] == NULL)
                break;
        }
        if(i < total_ss_items)
        {
            n = i;
        }
        else
        {
            n = total_ss_items;
            total_ss_items++;

            ss_item = (ss_item_struct **)realloc(
                ss_item,
                total_ss_items * sizeof(ss_item_struct *)
            );
            if(ss_item == NULL)
            {
                total_ss_items = 0;
                return(-1);
            }
        }

        ss_item[n] = (ss_item_struct *)calloc(1,
            sizeof(ss_item_struct)
        );
        if(ss_item[n] == NULL)
        {
            return(-1);
        }
 

        /* Reset values. */
	if(path != NULL)
	{
            ss_item[n]->path = StringCopyAlloc(path);
	}


        return(n);
}


/*
 *	Allocates a sound scheme item explicitly, returns -1 on error
 *	or 0 on success.
 */
int SSAllocateExplicit(int n)
{
	int i, prev_total;


	/* Requested number must be valid. */
	if(n < 0)
	    return(-1);


	/* Delete sound scheme n if already allocated. */
	SSDelete(n);


	/* Sanitize total. */
	if(total_ss_items < 0)
	    total_ss_items = 0;


	/* Need to allocate more pointers? */
	if(n >= total_ss_items)
	{
	    /* Record previous total and set new total. */
	    prev_total = total_ss_items;
	    total_ss_items = n + 1;

	    /* Allocate more pointers. */
	    ss_item = (ss_item_struct **)realloc(
	        ss_item,
	        total_ss_items * sizeof(ss_item_struct *)
	    );
	    if(ss_item == NULL)
	    {
	        total_ss_items = 0;
	        return(-1);
	    }

	    /* Reset new pointers. */
	    for(i = prev_total; i < total_ss_items; i++)
	    {
		ss_item[i] = NULL;
	    }
	}


	ss_item[n] = (ss_item_struct *)calloc(1, sizeof(ss_item_struct));
	if(ss_item[n] == NULL)
	{
	    return(-1);
	}




	return(0);
}


void SSDelete(int n)
{
        if(SSIsAllocated(n))  
        {
	    /* Free resources. */
	    free(ss_item[n]->path);

	    /* Free structure itself. */
            free(ss_item[n]);
            ss_item[n] = NULL;
        }

        return;
}



void SSDeleteAll()
{
        int i;

        for(i = 0; i < total_ss_items; i++)
        {
            SSDelete(i);
        }

        free(ss_item);
        ss_item = NULL;

        total_ss_items = 0;

        return;
}
