/*
                         Economy Window

	Functions:

	char *EcoWinGetRealNameFromOCSN(char *s)
	void EcoWinDeleteAllRealNames()

	void EcoWinUnfocusPrompts()
	int EcoWinDoAddInventory(
		long src_obj,
		long tar_obj,
		xsw_ecoproduct_struct product
	)
	void EcoWinDoDeleteInventory()

	int EcoWinRefreshPBCB(void *ptr)
        int EcoWinBuyPBCB(void *ptr)
        int EcoWinSellPBCB(void *ptr)
	int EcoWinClosePBCB(void *ptr)

	int EcoWinInit()
	int EcoWinResize()
	int EcoWinDraw()
	int EcoWinManage(event_t *event)
	void EcoWinMap()	
	void EcoWinUnmap()
	void EcoWinDestroy()

	---

 */

#include "xsw.h"


#define EW_TITLE	"Buy or Sell"		/* Need better title. */
#define EW_TITLE_ICON	"Buy or Sell"

#define EW_WIDTH	512
#define EW_HEIGHT	480

#define EW_BTN_WIDTH	70
#define EW_BTN_HEIGHT	28

#define EW_NAME_PROMPT_NAME	"Proprietor:"
#define EW_VALUE_PROMPT_NAME	"Quantity:"


#define MIN(a,b)	((a) < (b)) ? (a) : (b)
#define MAX(a,b)	((a) > (b)) ? (a) : (b)


/* Real name structure. */
typedef struct {

	char *name;

} real_name_struct;



char *EcoWinGetRealNameFromOCSN(char *s);
void EcoWinDeleteAllRealNames();


/*
 *	Checks if string s is a real name token string
 *	and if so returns a statically allocated string
 *	containing the parsed name.  Returns s if s is not
 *	a real name token string.
 */
char *EcoWinGetParsedName(char *s)
{
	char *strptr;
	static char rtn_str[ECO_PRODUCT_NAME_MAX];


	if(s == NULL)
	    return(NULL);

	/* Skip leading spaces. */
	while(isblank(*s))
	    s++;

	/* Not a token string? */
	if(*s != '$')
	{
	    strncpy(rtn_str, s, ECO_PRODUCT_NAME_MAX);
	    rtn_str[ECO_PRODUCT_NAME_MAX - 1] = '\0';
	    return(rtn_str);
	}

	/* Get delimiter character ':'. */
	strptr = strchr(s, ':');
	if(strptr == NULL)
	{   
            strncpy(rtn_str, s, ECO_PRODUCT_NAME_MAX);
            rtn_str[ECO_PRODUCT_NAME_MAX - 1] = '\0';
            return(rtn_str);
        }

	strncpy(
	    rtn_str,
	    strptr + 1,
	    ECO_PRODUCT_NAME_MAX
	);
	rtn_str[ECO_PRODUCT_NAME_MAX - 1] = '\0';

	return(rtn_str);
}


/*
 *	Procedure to delete all real names in inventory list.
 */
void EcoWinDeleteAllRealNames()
{
	int i, n;
	colum_list_struct *list;
	colum_list_row_struct *row_ptr;
	real_name_struct *rn_ptr;


	list = &eco_win.inventory;

	for(i = 0; i < list->total_rows; i++)
	{
	    row_ptr = list->row[i];
	    if(row_ptr == NULL)
		continue;

	    for(n = 0; n < row_ptr->total_items; n++)
	    {
		if(row_ptr->item[n] == NULL)
		    continue;

		if(row_ptr->item[n]->client_data == NULL)
		    continue;

		/* Get real name pointer. */
		rn_ptr = (real_name_struct *)row_ptr->item[n]->client_data;

		free(rn_ptr->name);
		free(rn_ptr);

		/* Reset client_data on item. */
		row_ptr->item[n]->client_data = NULL;
	    }
	}



	return;
}


/*
 *	Unfocus all prompts on economy window.
 */
void EcoWinUnfocusPrompts()
{
	eco_win.proprietor_prompt.is_in_focus = 0;
	eco_win.inventory.is_in_focus = 0;
	eco_win.amount_prompt.is_in_focus = 0;

	return;
}

/*
 *	Procedure to add an inventory item to the eco window.
 *
 *	If tar_obj is not the same object or is -1
 *	then all inventory items in the list are deleted.
 */
int EcoWinDoAddInventory(
	long src_obj,
	long tar_obj,		/* Can be -1. */
        xsw_ecoproduct_struct product
)
{
	char stringa[256];
	char *strptr;
	int i, status;
	xsw_object_struct *obj_ptr;
	colum_list_struct *list;
	real_name_struct *rn_ptr;


	list = &eco_win.inventory;


	/* Target object -1 or different from last? */
	if((tar_obj < 0) ||
           (eco_win.proprietor_obj != tar_obj)
	)
	{
	    /* Changed proprietor object, delete all invetory items. */

	    /* Delete all rows from inventory list. */
	    EcoWinDeleteAllRealNames();		/* Delete real names first. */
	    CListDeleteAllRows(list);

	    if(DBIsObjectGarbage(tar_obj))
		obj_ptr = NULL;
	    else
		obj_ptr = xsw_object[tar_obj];


            /* Change name in proprietor prompt. */
            if(eco_win.proprietor_prompt.buf != NULL)
            {
		if(obj_ptr != NULL)
		{
		    strncpy(
			eco_win.proprietor_prompt.buf,
			obj_ptr->name,
			XSW_OBJ_NAME_MAX
		    );

                    PromptMarkBuffer(
			&eco_win.proprietor_prompt,
                        PROMPT_POS_END
                    );
		}
		else
		{
                    eco_win.proprietor_prompt.buf[0] = '\0';

                    PromptUnmarkBuffer(
			&eco_win.proprietor_prompt,
                        PROMPT_POS_END
                    );
		}
            }
	    if(eco_win.map_state)
                PromptDraw(
		    &eco_win.proprietor_prompt,
                    PROMPT_DRAW_AMOUNT_COMPLETE
                );
	}

	/* Don't go any further if tar_obj is invalid. */
	if(tar_obj < 0)
	{
	    eco_win.proprietor_obj = -1;

            if(eco_win.map_state)
                CListDraw(&eco_win.inventory, CL_DRAW_AMOUNT_COMPLETE);

	    return(0);
	}


        /* Set new proprietor object. */
        eco_win.proprietor_obj = tar_obj;


	/* Check if product is already in list. */
	for(i = 0; i < list->total_rows; i++)
	{
	    if(list->row[i] == NULL)
		continue;

	    if(list->row[i]->total_items < 1)
		continue;

	    if(list->row[i]->item[0] == NULL)
		continue;

            /* Get real name pointer. */
            rn_ptr = (real_name_struct *)
                list->row[i]->item[0]->client_data;
            if(rn_ptr == NULL)
		continue;

	    /* Check real names. */
	    if(rn_ptr->name == NULL)
		continue;
            if(!strcasecmp(rn_ptr->name, product.name))
		break;
	}
	if(i < list->total_rows)
	{
	    /* List item already exists. */

	    /* Name. */
	    if(list->row[i]->total_items >= 1)
	    {
	        if(list->row[i]->item[0] != NULL)
		{
		    strptr = EcoWinGetParsedName(product.name);

		    free(list->row[i]->item[0]->label);
		    list->row[i]->item[0]->label = StringCopyAlloc(strptr);
		}
	    }

            /* Sell price. */
            if(list->row[i]->total_items >= 2)
            {
                if(list->row[i]->item[1] != NULL)
                {
                    sprintf(stringa, "%.2f", product.sell_price);
                    free(list->row[i]->item[1]->label);
                    list->row[i]->item[1]->label = StringCopyAlloc(
                        stringa
                    );
                }
            }

            /* Buy price. */
            if(list->row[i]->total_items >= 3)
            {
                if(list->row[i]->item[2] != NULL)
                {
                    sprintf(stringa, "%.2f", product.buy_price);
                    free(list->row[i]->item[2]->label);
                    list->row[i]->item[2]->label = StringCopyAlloc(
                        stringa
                    );
                }
            }

            /* Amount. */
            if(list->row[i]->total_items >= 4)
            {
                if(list->row[i]->item[3] != NULL)
                {
                    sprintf(stringa, "%.2f", product.amount);
                    free(list->row[i]->item[3]->label);
                    list->row[i]->item[3]->label = StringCopyAlloc(
                        stringa
                    );
                }
            }

            /* Amount max. */
            if(list->row[i]->total_items >= 5)
            {
                if(list->row[i]->item[4] != NULL)
                {
		    if(product.amount_max >= 0)
			sprintf(stringa, "%.2f", product.amount_max);
		    else
			sprintf(stringa, "nolimit");
                    free(list->row[i]->item[4]->label);
                    list->row[i]->item[4]->label = StringCopyAlloc(
                        stringa
                    ); 
                }
            }
	}
	else
	{
	    /* List item does not exist, allocate it. */
	    if(
                CListAddRow(
	            list,
	            -1			/* Append. */
	        )
	    )
	        return(-1);

	    i = list->total_rows - 1;
	    /* Name. */
            strptr = EcoWinGetParsedName(product.name);
	    status = CListAddItem(
	        list,
                strptr,
	        osw_gui[0].std_font,
	        widget_global.editable_text_pix,
	        0,
	        i
	    );
	    /* Record real name. */
	    if(status >= 0)
	    {
		rn_ptr = (real_name_struct *)calloc(
		    1,
		    sizeof(real_name_struct)
		);
		if(rn_ptr == NULL)
		    return(-1);

		rn_ptr->name = StringCopyAlloc(product.name);

		/* Set item client data to point to real name struct. */
		list->row[i]->item[0]->client_data = (void *)rn_ptr;
	    }

	    /* Sell price. */
	    sprintf(stringa, "%.2f", product.sell_price);
	    status = CListAddItem(
                list,
                stringa,
                osw_gui[0].std_font,
                widget_global.editable_text_pix,
                0, 
                i
            );

            /* Buy price. */
            sprintf(stringa, "%.2f", product.buy_price);
            status = CListAddItem(
                list,
                stringa,
                osw_gui[0].std_font,
                widget_global.editable_text_pix,
                0,
                i
            );

	    /* Amount. */
            if(product.amount_max >= 0)
                sprintf(stringa, "%.2f", product.amount);
            else
                sprintf(stringa, "-");
            status = CListAddItem(
                list,
                stringa,
                osw_gui[0].std_font,
                widget_global.editable_text_pix,
                0,
                i
            );

            /* Amount max. */
            if(product.amount_max >= 0)
                sprintf(stringa, "%.2f", product.amount_max);
            else
                sprintf(stringa, "nolimit");
            status = CListAddItem(
                list,
                stringa,
                osw_gui[0].std_font,
                widget_global.editable_text_pix,
                0,
                i
            );
	}


	return(0);
}


/*
 *	Procedure to delete all inventory.
 */
void EcoWinDoDeleteInventory()
{
	xsw_ecoproduct_struct product;


	memset(&product, 0x00, sizeof(xsw_ecoproduct_struct));

	/*   Delete all inventory when add input for both
	 *   objects is -1.
	 */
	EcoWinDoAddInventory(
	    -1,		/* Source object. */
	    -1,		/* Target object. */
	    product
	);


	return;
}


int EcoWinRefreshPBCB(void *ptr)
{
	long tar_obj = -1;
	char stringa[1024];


	/* Match target object. */
	if(eco_win.proprietor_prompt.buf != NULL)
	{
	    tar_obj = MatchObjectByName(
		eco_win.proprietor_prompt.buf,
		-1
	    );
	    if(tar_obj < 0)
	    {
	        sprintf(stringa,
		    "Cannot find object:\n\n    `%s'",
		    eco_win.proprietor_prompt.buf
		);
		printdw(&err_dw, stringa);
	    }
	}

	/* Delete all inventory list items. */
	EcoWinDoDeleteInventory();

	NetSendEcoReqValues(
	    lplayer_object,
	    tar_obj
	);


	return(0);
}


int EcoWinBuyPBCB(void *ptr)
{
	int i, n;
	char *strptr;
	colum_list_struct *list;
	colum_list_row_struct *row_ptr;
	real_name_struct *rn_ptr;
	xsw_ecoproduct_struct product;


	if(eco_win.proprietor_obj < 0)
	    return(0);


	/* Get amount from amount prompt. */
	strptr = eco_win.amount_prompt.buf;
	if(strptr != NULL)
	    product.amount = atof(strptr);
	else
	    product.amount = 0;


	/* Go through selected product items. */
	list = &eco_win.inventory;
	for(i = 0; i < list->total_sel_rows; i++)
	{
	    n = list->sel_row[i];
	    if((n < 0) || (n >= list->total_rows))
		continue;
	    row_ptr = list->row[n];
	    if(row_ptr == NULL)
		continue;

	    if(row_ptr->total_items < 1)
		continue;
	    if(row_ptr->item[0] == NULL)
		continue;

	    /* Get real name of product. */
	    rn_ptr = (real_name_struct *)row_ptr->item[0]->client_data;
	    if(rn_ptr == NULL)
		continue;

	    strptr = rn_ptr->name;
	    if(strptr != NULL)
		strncpy(product.name, strptr, ECO_PRODUCT_NAME_MAX);
	    else
		continue;
	    product.name[ECO_PRODUCT_NAME_MAX - 1] = '\0';

	    /* All other product information is not used. */

	    /* Buy. */
	    NetSendEcoBuy(
	        lplayer_object,
	        eco_win.proprietor_obj,
	        product
	    );
	}


        return(0);
}


int EcoWinSellPBCB(void *ptr)
{
        int i, n;
        char *strptr;
        colum_list_struct *list;
        colum_list_row_struct *row_ptr; 
        real_name_struct *rn_ptr;
        xsw_ecoproduct_struct product;


        if(eco_win.proprietor_obj < 0)
            return(0);


        /* Get amount from amount prompt. */
        strptr = eco_win.amount_prompt.buf;
        if(strptr != NULL)
            product.amount = atof(strptr);
        else
            product.amount = 0;


        /* Go through selected product items. */
        list = &eco_win.inventory;
        for(i = 0; i < list->total_sel_rows; i++)
        {
            n = list->sel_row[i]; 
            if((n < 0) || (n >= list->total_rows))
                continue;
            row_ptr = list->row[n];
            if(row_ptr == NULL)
                continue;

            if(row_ptr->total_items < 1)
                continue;
            if(row_ptr->item[0] == NULL)
                continue; 

            /* Get real name of product. */
            rn_ptr = (real_name_struct *)row_ptr->item[0]->client_data;
            if(rn_ptr == NULL)
                continue;

            strptr = rn_ptr->name;
            if(strptr != NULL)
                strncpy(product.name, strptr, ECO_PRODUCT_NAME_MAX);
            else
                continue;
            product.name[ECO_PRODUCT_NAME_MAX - 1] = '\0';

            /* All other product information is not used. */

            /* Sell. */
            NetSendEcoSell(
                lplayer_object,
                eco_win.proprietor_obj,
                product
            );
        }


        return(0);
}


int EcoWinClosePBCB(void *ptr)
{
	EcoWinUnmap();

	return(0);
}




int EcoWinInit()
{
	int btn_x, btn_y;
        pixmap_t pixmap;
	win_attr_t wattr;


	if(!IDC())
	    return(-1);


        /* Reset values. */
        eco_win.map_state = 0;
        eco_win.x = 0;
        eco_win.y = 0;
        eco_win.width = EW_WIDTH;
        eco_win.height = EW_HEIGHT;
        eco_win.is_in_focus = 0;
        eco_win.visibility_state = VisibilityFullyObscured;
        eco_win.disabled = False;
        
        eco_win.proprietor_obj = -1;


        /* ******************************************************* */

        /* Toplevel. */
        if(
            OSWCreateWindow(
                &eco_win.toplevel,
                osw_gui[0].root_win,
                eco_win.x, eco_win.y,
                EW_WIDTH, EW_HEIGHT
            )
        )
            return(-1);

	eco_win.toplevel_buf = 0;

	OSWSetWindowInput(eco_win.toplevel, OSW_EVENTMASK_TOPLEVEL);

        WidgetCenterWindow(eco_win.toplevel, WidgetCenterWindowToRoot);
        OSWGetWindowAttributes(eco_win.toplevel, &wattr);
        eco_win.x = wattr.x;
        eco_win.y = wattr.y;
        eco_win.width = wattr.width;
        eco_win.height = wattr.height;


        /* WM properties. */  
        if(IMGIsImageNumAllocated(IMG_CODE_ECONOMY_ICON))
        {
            pixmap = OSWCreatePixmapFromImage( 
                xsw_image[IMG_CODE_ECONOMY_ICON]->image
            );
        }
        else
        {
            pixmap = widget_global.std_icon_pm;
        } 
        OSWSetWindowWMProperties(
            eco_win.toplevel,
            EW_TITLE,		/* Title. */
            EW_TITLE_ICON,	/* Icon title. */
            pixmap,		/* Icon. */
            False,		/* Let WM set coordinates? */
            eco_win.x, eco_win.y,
            100, 100,
            osw_gui[0].display_width, osw_gui[0].display_height,
            WindowFrameStyleStandard,
            NULL, 0
        );

	/* Set this window to be a transient for the bridge window. */
        OSWSetTransientFor(eco_win.toplevel, bridge_win.toplevel);


	/* Refresh button. */
	btn_x = 10;
	btn_y = 10;
        if(
            PBtnInit(
                &eco_win.refresh_btn,
                eco_win.toplevel, 
                btn_x, btn_y,
                70, EW_BTN_HEIGHT,
                "Refresh",
                PBTN_TALIGN_CENTER,
                NULL,
                (void *)&eco_win.refresh_btn,
                EcoWinRefreshPBCB
            )
        )
            return(-1);


	/* Proprietor prompt. */
	if(
	    PromptInit(
		&eco_win.proprietor_prompt,
		eco_win.toplevel,
		0, 20 + EW_BTN_HEIGHT,
		eco_win.width,
		30,
		PROMPT_STYLE_FLUSHED,
		"Proprietor:",
		XSW_OBJ_NAME_MAX,
		0,
		NULL
	    )
	)
	    return(-1);

	/* Inventory colum list. */
	if(
	    CListInit(
                &eco_win.inventory,
                eco_win.toplevel,
                0, 55 + EW_BTN_HEIGHT,
		eco_win.width,
		(int)eco_win.height - 175,
		(void *)&eco_win.inventory,
                NULL
	    )
	)
	    return(-1);
	/* Heading for colum list. */
	CListAddHeading(
            &eco_win.inventory,
            "Product",
            osw_gui[0].std_font,
            widget_global.normal_text_pix,
            0,			/* Attributes. */
	    0			/* Start position. */
	);
        CListAddHeading(
            &eco_win.inventory,
            "Sell Price",
            osw_gui[0].std_font,        
            widget_global.normal_text_pix,        
            0,                  /* Attributes. */
            200                 /* Start position. */
        );
        CListAddHeading(
            &eco_win.inventory,
            "Buy Price",
            osw_gui[0].std_font,
            widget_global.normal_text_pix,
            0,                  /* Attributes. */
            280                 /* Start position. */
        );
        CListAddHeading(
            &eco_win.inventory,
            "Amount",        
            osw_gui[0].std_font,        
            widget_global.normal_text_pix,        
            0,                  /* Attributes. */
            360                 /* Start position. */
        );
        CListAddHeading(
            &eco_win.inventory,
            "Total",
            osw_gui[0].std_font,        
            widget_global.normal_text_pix,        
            0,                  /* Attributes. */
            440                 /* Start position. */
        );


        /* Amount prompt. */
        if(
            PromptInit(
                &eco_win.amount_prompt,
                eco_win.toplevel,
                0, 60 + EW_BTN_HEIGHT + (int)eco_win.height - 180,
                eco_win.width, 30,
                PROMPT_STYLE_FLUSHED,
                "Quantity:",
                64,			/* Buffer length. */
                0,
                NULL
            )
        )
            return(-1);
	PromptSetI(&eco_win.amount_prompt, 0);

	/* Link prompts togeather. */
	eco_win.proprietor_prompt.next = &eco_win.amount_prompt;
	eco_win.proprietor_prompt.prev = &eco_win.amount_prompt;

	eco_win.amount_prompt.next = &eco_win.proprietor_prompt;
	eco_win.amount_prompt.prev = &eco_win.proprietor_prompt;


	/* Buy button. */
	btn_x = (0 * EW_BTN_WIDTH) + (1 * 10);
	btn_y = (int)eco_win.height - EW_BTN_HEIGHT - 10;
	if(
	    PBtnInit(
		&eco_win.buy_btn,
		eco_win.toplevel,
		btn_x, btn_y,
		70, EW_BTN_HEIGHT,
		"Buy",
		PBTN_TALIGN_CENTER,
		NULL,
		(void *)&eco_win.buy_btn,
		EcoWinBuyPBCB
	    )
	)
	    return(-1);

        /* Sell button. */
        btn_x = (1 * EW_BTN_WIDTH) + (2 * 10);
        btn_y = (int)eco_win.height - 38;
        if(
            PBtnInit(
                &eco_win.sell_btn,
                eco_win.toplevel,
                btn_x, btn_y,
                70, EW_BTN_HEIGHT,
                "Sell",
                PBTN_TALIGN_CENTER,
                NULL,
                (void *)&eco_win.sell_btn,
                EcoWinSellPBCB
            )
        )
            return(-1);

        /* Close button. */
	btn_x = (int)eco_win.width - EW_BTN_WIDTH - 10;
        if(
            PBtnInit(
                &eco_win.close_btn,
                eco_win.toplevel,
                btn_x, btn_y,                 
                70, EW_BTN_HEIGHT,
                "Close",
                PBTN_TALIGN_CENTER,
                NULL,
                (void *)&eco_win.close_btn,
                EcoWinClosePBCB
            )
        )
            return(-1);




	return(0);
}


int EcoWinResize()
{
	int btn_x, btn_y;
	win_attr_t wattr;


	OSWGetWindowAttributes(eco_win.toplevel, &wattr);
	if((eco_win.width == wattr.width) &&
           (eco_win.height == wattr.height)
	)
	    return(0);

	eco_win.x = wattr.x;
	eco_win.y = wattr.y;
	eco_win.width = wattr.width;
        eco_win.height = wattr.height;


	/* Refresh button. */
	btn_x = 10;
	btn_y = 10;
	OSWMoveWindow(
            eco_win.refresh_btn.toplevel,
            btn_x, btn_y
	);

	/* Proprietor prompt. */
	OSWMoveResizeWindow(
	    eco_win.proprietor_prompt.toplevel,
	    0, 20 + EW_BTN_HEIGHT,
            eco_win.width,
            30
	);
        PromptMap(&eco_win.proprietor_prompt);

	/* Inventory colum list. */
        OSWMoveResizeWindow(
            eco_win.inventory.toplevel,
            0, 55 + EW_BTN_HEIGHT,
            eco_win.width, 
            (int)eco_win.height - 175
	);
	CListResize(&eco_win.inventory);

        /* Amount prompt. */
        OSWMoveResizeWindow(
            eco_win.amount_prompt.toplevel,
            0, 60 + EW_BTN_HEIGHT + (int)eco_win.height - 180,
            eco_win.width, 30
        );
        PromptMap(&eco_win.amount_prompt);


	/* Buy button. */
        btn_x = (0 * EW_BTN_WIDTH) + (1 * 10);
        btn_y = (int)eco_win.height - EW_BTN_HEIGHT - 10;
        OSWMoveWindow(
            eco_win.buy_btn.toplevel,
            btn_x, btn_y
        );

        /* Sell button. */
        btn_x = (1 * EW_BTN_WIDTH) + (2 * 10);
        OSWMoveWindow(
            eco_win.sell_btn.toplevel,
            btn_x, btn_y
        );

	/* Close button. */
        btn_x = (int)eco_win.width - EW_BTN_WIDTH - 10;
        OSWMoveWindow(
            eco_win.close_btn.toplevel,
            btn_x, btn_y
        );


	/* Destroy buffer. */
	OSWDestroyPixmap(&eco_win.toplevel_buf);


	return(0);
}


int EcoWinDraw()
{
	int i;
	xsw_object_struct *obj_ptr;
	win_attr_t wattr;
	char text[512];


	/* Map as needed. */
	if(!eco_win.map_state)
	{
	    OSWMapRaised(eco_win.toplevel);

            PBtnMap(&eco_win.refresh_btn);
            PromptMap(&eco_win.proprietor_prompt);
            CListMap(&eco_win.inventory);
	    PromptMap(&eco_win.amount_prompt);

	    PBtnMap(&eco_win.buy_btn);
            PBtnMap(&eco_win.sell_btn);
            PBtnMap(&eco_win.close_btn);

	    eco_win.visibility_state = VisibilityUnobscured;
	    eco_win.map_state = 1;
	}


	/* ******************************************************** */
	/* Recreate buffers as needed. */

	if(eco_win.toplevel_buf == 0)
	{
	    OSWGetWindowAttributes(eco_win.toplevel, &wattr);
            if(OSWCreatePixmap(&eco_win.toplevel_buf,
		wattr.width, wattr.height)
	    )
		return(-1);
	}


        /* ******************************************************** */
        /* Redraw toplevel. */
	if(1)
	{
	    OSWGetWindowAttributes(eco_win.toplevel, &wattr);

	    /* Clear background. */
	    if(widget_global.force_mono)
	    {
		OSWClearPixmap(
		    eco_win.toplevel_buf,
		    wattr.width, wattr.height,
		    osw_gui[0].black_pix
		);

		OSWSetFgPix(osw_gui[0].white_pix);
		OSWDrawLine(eco_win.toplevel_buf,
		    0,
		    (int)eco_win.height - EW_BTN_HEIGHT - 25,
		    (int)eco_win.width,
		    (int)eco_win.height - EW_BTN_HEIGHT - 25
		);

		OSWSetFgPix(osw_gui[0].white_pix);
	    }
	    else
	    {
		WidgetPutImageTile(
		    eco_win.toplevel_buf,
		    widget_global.std_bkg_img,
		    wattr.width, wattr.height
		);

                OSWSetFgPix(widget_global.surface_shadow_pix);
                OSWDrawLine(eco_win.toplevel_buf,
                    0,
                    (int)eco_win.height - EW_BTN_HEIGHT - 25,
                    (int)eco_win.width, 
                    (int)eco_win.height - EW_BTN_HEIGHT - 25
                );
                OSWSetFgPix(widget_global.surface_highlight_pix);
                OSWDrawLine(eco_win.toplevel_buf,
                    0,
                    (int)eco_win.height - EW_BTN_HEIGHT - 24,
                    (int)eco_win.width, 
                    (int)eco_win.height - EW_BTN_HEIGHT - 24
                );

                OSWSetFgPix(widget_global.normal_text_pix);
            }   

	    /* Print credits. */
	    obj_ptr = net_parms.player_obj_ptr;
	    if(obj_ptr != NULL)
	    {
		if(obj_ptr->score != NULL)
		{
		    sprintf(
			text,
			"Your Credits: %.2f",
			obj_ptr->score->credits
		    );
		    i = strlen(text);

	            OSWDrawString(
		        eco_win.toplevel_buf,
			(int)wattr.width - 190,
			22,
			text
		    );
		}
	    }
            if(!DBIsObjectGarbage(eco_win.proprietor_obj))
            {
                obj_ptr = xsw_object[eco_win.proprietor_obj];


                if(obj_ptr->eco != NULL)
                {
                    sprintf(
			text,
			"%s",
                        ((obj_ptr->eco->flags & ECO_FLAG_OPEN) ?
			    "Opened" : "Closed"
			)
                    );

                    OSWDrawString(
                        eco_win.toplevel_buf,
                        (int)wattr.width - 350,
                        22,
                        text
                    );

		    /* Tax friend/general/hostile. */
                    sprintf(
			text,
			"Tax: %.0lf/%.0lf/%.0lf%%",
			(double)(obj_ptr->eco->tax_friend - 1) * 100,                          
			(double)(obj_ptr->eco->tax_general - 1) * 100,
			(double)(obj_ptr->eco->tax_hostile - 1) * 100
                    );

                    OSWDrawString(
                        eco_win.toplevel_buf,
                        (int)wattr.width - 350,
                        40,
                        text
                    );
		}

                if(obj_ptr->score != NULL)
                {
                    sprintf(
			text,
			"Proprietor Credits: %.2f",
                        obj_ptr->score->credits
                    );

                    OSWDrawString(
                        eco_win.toplevel_buf,
                        (int)wattr.width - 232,
                        40,
                        text
                    );
                }
            }


	    OSWPutBufferToWindow(eco_win.toplevel, eco_win.toplevel_buf);
	}


	return(0);
}


int EcoWinManage(event_t *event)
{
	int events_handled = 0;


	if(event == NULL)
	    return(events_handled);

	if(!eco_win.map_state &&
           (event->type != MapNotify)
	)
	    return(events_handled);


	switch(event->type)
	{
          /* ******************************************************** */
	  case KeyPress:
	    if(!eco_win.is_in_focus)
	        return(events_handled);

	    /* Escape. */
	    if(event->xkey.keycode == osw_keycode.esc)
	    {
		EcoWinClosePBCB(
		    (void *)&eco_win.close_btn
		);

		events_handled++;
	    }
            /* Enter. */
            else if((event->xkey.keycode == osw_keycode.enter) ||
                    (event->xkey.keycode == osw_keycode.np_enter)
	    )
            {
                /* Ignore enter but count it as an event. */

                events_handled++;
            }
	    if(events_handled > 0)
		return(events_handled);

	    break;

          /* ******************************************************** */
          case Expose:
            if(event->xany.window == eco_win.toplevel)
	    {
		events_handled++;
	    }
            break;

          /* ******************************************************** */
          case UnmapNotify:
            if(event->xany.window == eco_win.toplevel)
            {
		EcoWinUnmap();

                events_handled++;
		return(events_handled);
            }
            break;

          /* ******************************************************** */
          case MapNotify:
            if(event->xany.window == eco_win.toplevel)
            {
		if(!eco_win.map_state)
		    EcoWinMap();

                events_handled++;
                return(events_handled);
            }
            break;

          /* ******************************************************** */
          case ClientMessage:
            if(OSWIsEventDestroyWindow(eco_win.toplevel, event))
            {
                EcoWinUnmap();
                events_handled++;
                return(events_handled);
            }
            break;

	  /* ******************************************************** */
          case FocusIn:
            if(event->xany.window == eco_win.toplevel)   
            {
                eco_win.is_in_focus = 1;

                events_handled++;
            }
            break;

          /* ******************************************************** */
          case FocusOut:
            if(event->xany.window == eco_win.toplevel)
            {
		EcoWinUnfocusPrompts();

                eco_win.is_in_focus = 0;

                events_handled++;
            }
            break;

          /* ********************************************************* */
          case ConfigureNotify:
            if(event->xany.window == eco_win.toplevel)
            {
                EcoWinResize();

                events_handled++;
            }
            break;
	}

	/* Redraw as needed. */
	if(events_handled > 0)
	{
	    EcoWinDraw();
	}


	/* ********************************************************* */
	/* Manage widgets. */

        /* Refresh button. */
        if(events_handled == 0)
            events_handled += PBtnManage(&eco_win.refresh_btn, event);

	/* Proprietor prompt. */
	if(events_handled == 0)
            events_handled += PromptManage(&eco_win.proprietor_prompt, event);

        /* Inventory colum list. */   
        if(events_handled == 0)
            events_handled += CListManage(&eco_win.inventory, event);

	/* Amount prompt. */
        if(events_handled == 0)
            events_handled += PromptManage(&eco_win.amount_prompt, event);


	/* Buy button. */
        if(events_handled == 0)
            events_handled += PBtnManage(&eco_win.buy_btn, event);

	/* Sell button. */
        if(events_handled == 0)
            events_handled += PBtnManage(&eco_win.sell_btn, event);

	/* Close button. */
        if(events_handled == 0)
            events_handled += PBtnManage(&eco_win.close_btn, event);


	return(events_handled);
}


void EcoWinMap()
{
        /* Unfocus all XSW windows. */  
        XSWDoUnfocusAllWindows();


	/* Unfocus all eco win prompts. */
	EcoWinUnfocusPrompts();


	/* Map economy window. */
	eco_win.map_state = 0;
	EcoWinDraw();

        eco_win.amount_prompt.is_in_focus = 1;   
	eco_win.is_in_focus = 1;


        /* Restack all XSW windows. */
        XSWDoRestackWindows();


	return;
}


void EcoWinUnmap()
{
        PBtnUnmap(&eco_win.refresh_btn); 
        PromptUnmap(&eco_win.proprietor_prompt);
        CListUnmap(&eco_win.inventory);
        PromptUnmap(&eco_win.amount_prompt);
        PBtnUnmap(&eco_win.buy_btn);
        PBtnUnmap(&eco_win.sell_btn);
        PBtnUnmap(&eco_win.close_btn);

	OSWUnmapWindow(eco_win.toplevel);
	eco_win.map_state = 0;
	eco_win.is_in_focus = 0;
	eco_win.visibility_state = VisibilityFullyObscured;

	/* Destroy large buffers. */
	OSWDestroyPixmap(&eco_win.toplevel_buf);


	return;
}



void EcoWinDestroy()
{

	/* Delete all real names from inventory list items first. */
	EcoWinDeleteAllRealNames();


	if(IDC())
	{
	    PBtnDestroy(&eco_win.buy_btn);
            PBtnDestroy(&eco_win.sell_btn);
            PBtnDestroy(&eco_win.close_btn);

	    PromptDestroy(&eco_win.amount_prompt);
	    CListDestroy(&eco_win.inventory);
            PromptDestroy(&eco_win.proprietor_prompt);

	    PBtnDestroy(&eco_win.refresh_btn);

            OSWDestroyWindow(&eco_win.toplevel);
            OSWDestroyPixmap(&eco_win.toplevel_buf);
	}


	/* Reset values. */
        eco_win.map_state = 0;
        eco_win.x = 0;
        eco_win.y = 0;
        eco_win.width = 0;
        eco_win.height = 0;
        eco_win.is_in_focus = 0;
        eco_win.visibility_state = VisibilityFullyObscured;
	eco_win.disabled = False;

        eco_win.proprietor_obj = -1;


	return;
}
